CONTAINER XSLAFluorescence
{
	NAME XSLAFluorescence;

	INCLUDE Mpreview;
	INCLUDE Xbase;

	GROUP ID_SHADERPROPERTIES
	{
		GROUP
		{
			COLUMNS 2;
			LONG SLA_FLUORESCENCE_SIZE_X { MIN 10; MAX 10000; }
			LONG SLA_FLUORESCENCE_SIZE_Y { MIN 10; MAX 10000; }
		}
		REAL SLA_FLUORESCENCE_FALLOFF { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		BUTTON SLA_FLUORESCENCE_RESET { }
	}
	GROUP SLA_FLUORESCENCE_GROUP_FRONT
	{
		SCALE_V;
		GROUP
		{
			BOOL SLA_FLUORESCENCE_ACTIVE_FRONT { }
			COLOR SLA_FLUORESCENCE_COLOR_FRONT { }
			LONG SLA_FLUORESCENCE_ALGORITHM_FRONT
			{
				CYCLE
				{
					SLA_FLUORESCENCE_ALGORITHM_INTERNAL;
					SLA_FLUORESCENCE_ALGORITHM_OREN_NAYAR;
				}
			}
			REAL SLA_FLUORESCENCE_ILLIMINATION_FRONT { UNIT PERCENT; MIN 0; MAX 1000; }
			REAL SLA_FLUORESCENCE_ROUGHNESS_FRONT { UNIT PERCENT; MIN 0; MAX 200; }
			REAL SLA_FLUORESCENCE_SHADOW_INTENSITY_FRONT { UNIT PERCENT; MIN 0; MAX 100; }
			BOOL SLA_FLUORESCENCE_CLIP_FRONT { }
			REAL SLA_FLUORESCENCE_CONTRAST_FRONT { UNIT PERCENT; MIN -500; MAX 500; }
		}
		GROUP
		{
			SCALE_V; 
			IN_EXCLUDE SLA_FLUORESCENCE_LIGHTS_FRONT { NUM_FLAGS 0; INIT_STATE 0; ACCEPT { Olight; } }
		}
	}

	GROUP SLA_FLUORESCENCE_GROUP_BACK
	{
		SCALE_V;
		GROUP
		{
			BOOL SLA_FLUORESCENCE_ACTIVE_BACK { }
			COLOR SLA_FLUORESCENCE_COLOR_BACK { }
			LONG SLA_FLUORESCENCE_ALGORITHM_BACK
			{
				CYCLE
				{
					SLA_FLUORESCENCE_ALGORITHM_INTERNAL;
					SLA_FLUORESCENCE_ALGORITHM_OREN_NAYAR;
				}
			}
			REAL SLA_FLUORESCENCE_ILLIMINATION_BACK { UNIT PERCENT; MIN 0; MAX 1000; }
			REAL SLA_FLUORESCENCE_ROUGHNESS_BACK { UNIT PERCENT; MIN 0; MAX 200; }
			REAL SLA_FLUORESCENCE_SHADOW_INTENSITY_BACK { UNIT PERCENT; MIN 0; MAX 100; }
			BOOL SLA_FLUORESCENCE_CLIP_BACK { }
			REAL SLA_FLUORESCENCE_CONTRAST_BACK { UNIT PERCENT; MIN -500; MAX 500; }
		}
		GROUP
		{
			SCALE_V;
			IN_EXCLUDE SLA_FLUORESCENCE_LIGHTS_BACK { NUM_FLAGS 0; INIT_STATE 0; ACCEPT { Olight; } }
		}
	}
}