/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4D_VIDEOPOSTPLUGIN_H
#define __C4D_VIDEOPOSTPLUGIN_H

#include "ge_math.h"
#include "c4d_basetime.h"
#include "c4d_videopostdata.h"
#include "c4d_nodeplugin.h"

class GlFrameBuffer;

struct VIDEOPOSTPLUGIN : public NODEPLUGIN
{
	LONG	priority;

	Bool	(VideoPostData::*Draw						)(PluginVideoPost *node, BaseDraw *bd, BaseDrawHelp *bh);
	void	(VideoPostData::*AllocateBuffers)(PluginVideoPost *node, Render *render, BaseDocument *doc);
	LONG	(VideoPostData::*GetRenderInfo  )(PluginVideoPost *node);

	LONG	(VideoPostData::*Execute				)(PluginVideoPost *node, VideoPostStruct *vps);
	void	(VideoPostData::*ExecuteLine		)(PluginVideoPost *node, PixelPost *pp);
	void	(VideoPostData::*ExecutePixel   )(PluginVideoPost *node, PixelPost *pp, LONG x, LONG subx, LONG suby);

	void  (VideoPostData::*CalcVolumetric	)(PluginVideoPost *node, VolumeData *vd);
	void  (VideoPostData::*CalcShadow    	)(PluginVideoPost *node, VolumeData *vd);
	Bool	(VideoPostData::*GlDraw					)(PluginVideoPost *node, BaseDraw *bd, GlFrameBuffer* fbuf, LONG colortex, LONG depthtex, LONG flags);

	Vector (VideoPostData::*ComputeDiffuseGI     )(PluginVideoPost *node, VolumeData *vd, Real receive_strength);
	Vector (VideoPostData::*ComputeDiffuseCaustic)(PluginVideoPost *node, VolumeData *vd, Real sampleradius, LONG accuracy);
	Vector (VideoPostData::*ComputeVolumeCaustic )(PluginVideoPost *node, const LVector &p);

	void  (VideoPostData::*CreateRay      )(Ray *dst, Real x, Real y);
	LONG (VideoPostData::*GetGlInfo)(PluginVideoPost *node, BaseDocument* doc, BaseDraw *bd);

	void*	reserved[(32-14)*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
