/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DSTRING_H
#define __C4DSTRING_H

#ifdef __MAC
	#if defined(__cplusplus)
		#include <new>
		using namespace std;
	#endif
#elif defined __LINUX
	#include <new>
#elif	defined	__PC
	#include <new>
#endif

#include "operatingsystem.h"

class String;

inline void FreeString(String *&str)
{
	if (str) C4DOS.St->Free(str);
	str=NULL;
}

class String
{
	private:
#if defined __C4D_64BIT
		C4D_RESERVE_PRIVATE( 24 );															// fixed size of 24 bytes
#else
		C4D_RESERVE_PRIVATE( 16 );															// fixed size of 16 bytes
#endif
public:

		#ifdef	__C4D_NO_NEW_DELETE__																

		void* operator new(size_t, const std::nothrow_t&, int line, const CHAR *file) throw()
		{
			return C4DOS.St->Alloc();
		}

		void operator delete(void* del,int line, const CHAR *file)
		{
			C4DOS.St->Free((String*)del);
		}

		void operator delete(void* del)
		{
			C4DOS.St->Free((String*)del);
		}

		void* operator new(size_t,void *place) { return place; }
		void  operator delete(void*, void*) {}
		#endif

		void CopyTo(String *str) const
		{
			C4DOS.St->CopyTo(this,str);
		}

		String *GetClone(void) const
		{
			return C4DOS.St->GetClone(this);
		}

		const String& operator = (const String &cs)
		{
			C4DOS.St->CopyTo(&cs,this);
			return *this;
		}

		String(void)
		{
			C4DOS.St->Init(this);
		}

		String(const String &cs)
		{
			C4DOS.St->Init(this);
			C4DOS.St->CopyTo(&cs,this);
		}

		String(const UWORD* s)
		{
			C4DOS.St->Init(this);
			C4DOS.St->SetUcBlock(this, s, -1);
		}

		String(const CHAR *cstr,StringEncoding type=StXbit)
		{
			C4DOS.St->Init(this);
			C4DOS.St->InitCString(this,cstr,-1,type);
		}

		String(LONG count,UWORD fillch)
		{
			C4DOS.St->Init(this);
			C4DOS.St->InitArray(this,count,fillch);
		}

		~String(void)
		{
			C4DOS.St->Flush(this);
		}

		LONG GetLength(void) const
		{
			return C4DOS.St->GetLength(this);
		}

		Bool Content(void) const { return GetLength()!=0; }

		friend const String operator + (const String &Str1,const String &Str2)
		{
			return String(Str1)+=Str2;
		}

		const String& operator += (const String &Str)
		{
			Insert(GetLength(),Str);
			return *this;
		}

		Bool operator < (const String &Str) const
		{
			return (Compare(Str) < 0);
		}

		Bool operator > (const String &Str) const
		{
			return (Compare(Str) > 0);
		}

		Bool operator <= (const String &Str) const
		{
			return (Compare(Str) <= 0);
		}

		Bool operator >= (const String &Str) const
		{
			return (Compare(Str) >= 0);
		}

		Bool operator == (const String &Str) const
		{
			return (Compare(Str) == 0);
		}

		Bool operator != (const String &Str) const
		{
			return (Compare(Str) != 0);
		}

		// 0 == , <0 < , >0 >
		LONG Compare(const String &cs) const
		{
			return C4DOS.St->Compare(this,&cs,0);
		}

		LONG ComparePart(const String &Str, LONG cnt, LONG pos) const
		{
			return (this->*C4DOS.St->ComparePart)(Str,cnt,pos);
		}

		LONG LexCompare(const String &cs) const
		{
			return C4DOS.St->Compare(this,&cs,1);
		}

		LONG LexComparePart(const String &Str, LONG cnt, LONG pos) const
		{
			return (this->*C4DOS.St->LexComparePart)(Str,cnt,pos);
		}

		LONG RelCompare(const String &cs) const
		{
			return C4DOS.St->Compare(this,&cs,2);
		}

		Bool FindFirst(const String &cs,LONG *pos,LONG start=0) const
		{
			return C4DOS.St->FindFirst(this,&cs,pos,start);
		}

		Bool FindLast(const String &cs,LONG *pos,LONG start=-1) const
		{
			return C4DOS.St->FindLast(this,&cs,pos,start);
		}

		Bool FindFirst(UWORD ch,LONG *pos,LONG start=0) const
		{
			return (this->*C4DOS.St->FindFirstCh)(ch,pos,start);
		}

		Bool FindLast(UWORD ch,LONG *pos,LONG start=-1) const
		{
			return (this->*C4DOS.St->FindLastCh)(ch,pos,start);
		}

		// searches a string case insensitive, "findupper" has to be uppercase!!!
		Bool FindFirstUpper(const String &findupper, LONG *pos, LONG start) const
		{
			return (this->*C4DOS.St->FindFirstUpper)(findupper,pos,start);
		}

		Bool FindLastUpper(const String &findupper, LONG *pos, LONG start) const
		{
			return (this->*C4DOS.St->FindLastUpper)(findupper,pos,start);
		}

		void Delete(LONG pos,LONG count)
		{
			C4DOS.St->Delete(this,pos,count);
		}

		void Insert(LONG pos,UWORD ch)
		{
			String tmp = String(1,ch);
			C4DOS.St->Insert(this,pos,&tmp);
		}

		void Insert(LONG pos,const String &cs)
		{
			C4DOS.St->Insert(this,pos,&cs);
		}

		const String SubStr(LONG start,LONG count) const
		{
			String str,*s=C4DOS.St->SubStr(this,start,count);
			if (s) str=*s;
			FreeString(s);
			return str;
		}

		const String Left(LONG count) const
		{
			return SubStr(0, count);
		}

		const String Right(LONG count) const
		{
			return SubStr(GetLength() - count, count);
		}

		Real StringToReal(LONG *error=NULL, LONG unit=0, LONG angletype=0, LONG base=10) const
		{
			return C4DOS.St->ToReal(this,error,unit,angletype,base);
		}

		LONG StringToLong(LONG *error=NULL) const
		{
			return C4DOS.St->ToLong(this,error);
		}

		friend const String RealToString(Real v, LONG vk=-1, LONG nk=-1, Bool e=FALSE, UWORD xchar='0');
		friend const String LongToString(LONG l);
		friend const String LLongToString(LLONG l);
			
		const String ToUpper() const
		{
			String str,*s=C4DOS.St->ToUpper(this);
			if (s) str=*s;
			FreeString(s);
			return str;
		}

		const String ToLower() const
		{
			String str,*s=C4DOS.St->ToLower(this);
			if (s) str=*s;
			FreeString(s);
			return str;
		}
		
		LONG GetCStringLen(StringEncoding type=StXbit) const
		{
			return C4DOS.St->GetCStringLen(this,type);
		}

		LONG GetCString(CHAR *scstr, LONG max, StringEncoding type=StXbit) const
		{
			return C4DOS.St->GetCString(this,scstr,max,type);
		}

		CHAR *GetCStringCopy(StringEncoding Type=StXbit) const;
		
		void SetCString(const CHAR *cstr, LONG count=-1, StringEncoding type=StXbit)
		{
			C4DOS.St->InitCString(this, cstr, count, type);
		}

		LONG SetCStringR(const CHAR *cstr, LONG count=-1, StringEncoding type=StXbit)
		{
			C4DOS.St->InitCString(this, cstr, count, type);
			return GetLength();
		}

		void GetUcBlock(UWORD *Ubc, LONG Max) const
		{
			C4DOS.St->GetUcBlock((String*)this,Ubc,Max,FALSE);
		}

		void GetUcBlockNull(UWORD *Ubc, LONG Max) const
		{
			C4DOS.St->GetUcBlock((String*)this,Ubc,Max,TRUE);
		}

		void SetUcBlock(const UWORD *Ubc, LONG Count)
		{
			C4DOS.St->SetUcBlock(this,Ubc,Count);
		}

		class PChar
		{
			friend class String;
			
			private:

				PChar(String *str,LONG pos)
				{
					Str = str;
					Pos = pos;
				}
				
			public:

				PChar& operator = (const PChar& rhs)
				{
					if (!Str) return *this;
					if (Pos < 0 || Pos >= Str->GetLength()) return *this;

					if (rhs.Pos >= 0 && rhs.Pos < rhs.Str->GetLength()) // fixes memory access failure
						C4DOS.St->SetChr(Str,Pos,C4DOS.St->GetChr(rhs.Str,rhs.Pos));
#ifdef _DEBUG
					else
					{
						void _GeDebugBreak(LONG line, const CHAR *file); // Break
						_GeDebugBreak(__LINE__,__FILE__); // Break
					}
#endif

					return *this;
				}

				PChar& operator = (UWORD c)
				{
					if (!Str) return *this;
					if (Pos < 0 || Pos >= Str->GetLength()) return *this;
					C4DOS.St->SetChr(Str,Pos,c);
					return *this;
				}

				operator UWORD(void) const
				{
					if (!Str) return 0;
					if (Pos < 0 || Pos >= Str->GetLength()) return 0;
					else return C4DOS.St->GetChr(Str,Pos);
				}
				
			private:
				String *Str;
				LONG Pos;
		};
		
		const PChar operator[] (LONG Pos) const
		{
			if (Pos >= GetLength() || Pos < 0) Pos = -1;
			return PChar((String *)(this),Pos);
		}

		PChar operator[] (LONG Pos)
		{
			if (Pos >= GetLength() || Pos < 0) Pos = -1;
			return PChar(this,Pos);
		}
};

const String LongToString(LONG l);
const String LLongToString(LLONG l);
const String RealToString(Real v, LONG vvk, LONG nnk, Bool e, UWORD xchar);
String PtrToString(void *hex);
String MemoryToString(LLONG mem);

void FreeString(String *&str);

#define TString(x) String(x) // use TString to mark strings to translate

#endif
