#include "c4d.h"

#include "x4d_filter.h"
#include "c4d_bitmapfilter.h"
#include "filter_prefs.h"
#include "sdk_add.h"

Bool	BfpGetPSFEnabledFlag( BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	
	return((Bool) x_prefs->GetLong( BF_PREFS_PSF_ENABLED, BF_PREFS_PSF_ENABLED_DFLT ));
}

void	BfpSetPSFEnabledFlag( Bool enable_ps_plugins , BaseContainer *x_prefs)
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	x_prefs->SetLong( BF_PREFS_PSF_ENABLED, enable_ps_plugins );
	if (x_prefs==&tprefs)
		SetGlobalFilterPrefs( BF_PREFS_GLOBAL, tprefs );
}

LONG	BfpGetNoPSPaths( BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	return((LONG) x_prefs->GetLong( BF_PREFS_NO_PS_PATHS, BF_PREFS_NO_PS_PATHS_DFLT ));
}

void	BfpSetNoPSPaths( LONG no_paths , BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	x_prefs->SetLong( BF_PREFS_NO_PS_PATHS, no_paths );
	if (x_prefs==&tprefs)
		SetGlobalFilterPrefs( BF_PREFS_GLOBAL, tprefs );
}

String	BfpGetPSPath( LONG index, BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	return((String) x_prefs->GetString( BF_PREFS_PS_PATH0 + index, "" ));
}

void	BfpSetPSPath( LONG index, String path , BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	x_prefs->SetString( BF_PREFS_PS_PATH0 + index, path );
	if (x_prefs==&tprefs)
		SetGlobalFilterPrefs( BF_PREFS_GLOBAL, tprefs );
}

LONG	BfpGetNoPSAppPaths( BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	return((LONG) x_prefs->GetLong( BF_PREFS_NO_PS_APP_PATHS, BF_PREFS_NO_PS_APP_PATHS_DFLT ));
}

void	BfpSetNoPSAppPaths( LONG no_paths, BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	x_prefs->SetLong( BF_PREFS_NO_PS_APP_PATHS, no_paths );
	if (x_prefs==&tprefs)
		SetGlobalFilterPrefs( BF_PREFS_GLOBAL, tprefs );
}

void	BfpSetPSAppPath( String path, Real version, BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	LONG	no_apps;
	LONG	i;
		
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	
	no_apps = x_prefs->GetLong( BF_PREFS_NO_PS_APP_PATHS, BF_PREFS_NO_PS_APP_PATHS_DFLT );
	for ( i = 0; i < no_apps; i++ )
	{
		String	s;
		
		s = x_prefs->GetString( BF_PREFS_PS_APP_PATH0 + i, "" );
		if ( s.LexCompare( path ) == 0 )
			return;				
	}

	BfpSetNoPSAppPaths( no_apps + 1, x_prefs );		// increase the number of host directories
	x_prefs->SetString( BF_PREFS_PS_APP_PATH0 + no_apps, path );		// set host directory
	x_prefs->SetReal( BF_PREFS_PS_APP_VERSION0 + no_apps, version );	// set host version

	if (x_prefs==&tprefs)
		SetGlobalFilterPrefs( BF_PREFS_GLOBAL, tprefs );
}

Real	BfpIsInPSAppPath( String path, BaseContainer *x_prefs )
{
	BaseContainer	tprefs;
	LONG	no_apps;
	LONG	i;
	
	if (!x_prefs)
	{
		tprefs = GetGlobalFilterPrefs( BF_PREFS_GLOBAL );
		x_prefs = &tprefs;
	}
	
	path.ToUpper();
	no_apps = x_prefs->GetLong( BF_PREFS_NO_PS_APP_PATHS, BF_PREFS_NO_PS_APP_PATHS_DFLT );
	for ( i = 0; i < no_apps; i++ )
	{
		String	s;
		LONG		pos;
		
		s = x_prefs->GetString( BF_PREFS_PS_APP_PATH0 + i, "" );
		s.ToUpper();
		if ( path.FindFirst( s, &pos ) && ( pos == 0 ))
		{
			Real	version;

			version = x_prefs->GetReal( BF_PREFS_PS_APP_VERSION0 + i, 0.0 );	// get host version
			return( version );																		// return host version
		}
	}
	return( 0.0 );																						// plugin does not reside in a PS plugin folder
}
