
#include "lib_snd.h"

#define LIBID			LIB_SND
#define LIB				GeSndLib

static LIB *library_cache = NULL;

#ifndef __API_INTERN__
#include "c4d_basesound.h"
GeSndInfo::GeSndInfo(BaseSound *bs)
{
	if (bs) 
	{
		data = bs->GetRAW();
		bs->GetSoundInfo(&stereo,&b16,&f_mode,&samples,NULL);
	}
	else
		data=NULL;
}
#endif

static inline LIB *CheckLibSnd(LONG offset)
{
	return (LIB*)CheckLib(LIBID,offset,(C4DLibrary**)&library_cache);
}


GePlaySnd* GePlaySnd::Alloc()
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,Alloc)); if (!lib || !lib->Alloc) return NULL;
	return lib->Alloc();
}

void GePlaySnd::Free(GePlaySnd *&data)
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,Free)); if (!lib || !lib->Free) return;
	lib->Free(data);
}

GePlaySnd::GePlaySnd()
{
}

Bool GePlaySnd::Open(const GeSndInfo &si)
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,Open)); if (!lib || !lib->Open) return 0;
	return (this->*lib->Open)(si);
}

void GePlaySnd::Close()
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,Close)); if (!lib || !lib->Close) return;
	(this->*lib->Close)();
}

void GePlaySnd::Start(LONG start, LONG count)
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,Start)); if (!lib || !lib->Start) return;
	(this->*lib->Start)(start, count);
}

void GePlaySnd::Stop()
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,Stop)); if (!lib || !lib->Stop) return;
	(this->*lib->Stop)();
}

Bool GePlaySnd::IsPlaying()
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,IsPlaying)); if (!lib || !lib->IsPlaying) return 0;
	return (this->*lib->IsPlaying)();
}

LONG GePlaySnd::GetPosition()
{
	LIB *lib = CheckLibSnd(LIBOFFSET(LIB,GetPosition)); if (!lib || !lib->GetPosition) return 0;
	return (this->*lib->GetPosition)();
}

