#include "lib_sds.h"

//////////////////////////////////////////////////////////////////////////

SDSObjectLib *lib_sds = NULL;

static SDSObjectLib *CheckSDSObjectLib(LONG offset)
{
	return (SDSObjectLib*)CheckLib(LIBRARY_SDS,offset,(C4DLibrary**)&lib_sds);
}

#define SDSObjectLibCall(b) 		SDSObjectLib *lib = CheckSDSObjectLib(LIBOFFSET(SDSObjectLib, b)); \
															if (!lib || !lib->b) return; \
															(lib->b)

#define SDSObjectLibCallR(a,b)  SDSObjectLib *lib = CheckSDSObjectLib(LIBOFFSET(SDSObjectLib, b)); \
															if (!lib || !lib->b) return a; \
															return (lib->b)

//////////////////////////////////////////////////////////////////////////

LONG SDSObject::GetDivision(BaseObject *op)
{
	SDSObjectLibCallR(NOTOK,GetDivision)(this,op);
}

PolygonObject *SDSObject::GetSDSMesh(BaseObject *op)
{
	SDSObjectLibCallR(NULL,GetSDSMesh)(this,op);
}

Bool SDSObject::TransformPoint(BaseObject *op, LONG ply, Real &s, Real &t, Vector *p)
{
	SDSObjectLibCallR(FALSE,TransformPoint)(this,op,ply,s,t,p);
}

Bool SDSObject::GetNormal(BaseObject *op, LONG ply, Vector *p, Vector *n)
{
	SDSObjectLibCallR(FALSE,GetNormal)(this,op,ply,p,n);
}

Real *SDSObject::GetPointWeights(BaseTag *pTag)
{
	SDSObjectLibCallR(NULL,GetPointWeights)(pTag);
}

PolyWeight *SDSObject::GetEdgeWeights(BaseTag *pTag)
{
	SDSObjectLibCallR(NULL,GetEdgeWeights)(pTag);
}

SDSSubdivisionMask* SDSObject::GetSubdivisionMask(BaseObject *op, LONG &maskcnt, LONG *&polymap, Bool &ngonsubdiv)
{
	SDSObjectLibCallR(NULL,GetSubdivisionMask)(this,op,maskcnt,polymap, ngonsubdiv);
}

void *SDSObject::GetCreationData(BaseObject *op)
{
	SDSObjectLibCallR(NULL,GetCreationData)(this,op);
}
