#include "c4d_library.h"
#include "lib_regexpr.h"
#include "c4d_basecontainer.h"

RegExprLib* lib_regexpr = NULL;

static RegExprLib *CheckLibRegExpr(LONG offset)
{
	return (RegExprLib*)CheckLib(REG_EXP_PARSER, offset, (C4DLibrary**)&lib_regexpr);
}

#define RegExprLibCall(b) 		RegExprLib *lib = CheckLibRegExpr(LIBOFFSET(RegExprLib, b)); \
															if (!lib || !lib->b) return; \
															(((RegExpParser*)this)->*lib->b)

#define RegExprLibCallR(a,b)  RegExprLib *lib = CheckLibRegExpr(LIBOFFSET(RegExprLib, b)); \
															if (!lib || !lib->b) return a; \
															return (((RegExpParser*)this)->*lib->b)

RegularExprParser* RegularExprParser::Alloc()
{
	RegExprLib *lib = CheckLibRegExpr(LIBOFFSET(RegExprLib, RegExprLib_Alloc)); if (!lib) return NULL;
	return (RegularExprParser*)lib->RegExprLib_Alloc();	
}

void RegularExprParser::Free(RegularExprParser* p)
{
	if (!p) return;
	RegExprLib *lib = CheckLibRegExpr(LIBOFFSET(RegExprLib, RegExprLib_Free)); if (!lib) return;
  RegExpParser* i = (RegExpParser*)p;
	lib->RegExprLib_Free(i);
	p = NULL;
}

Bool RegularExprParser::Init(const String &strExprssion)
{
  RegExprLibCallR(FALSE, Init)(strExprssion);
}

Bool RegularExprParser::FindFirst(const String &strText, RegParseMode mode, Bool bOnlyFirst, LONG &lPos, String &strPattern)
{
  RegExprLibCallR(FALSE, FindFirst)(strText, mode, bOnlyFirst, lPos, strPattern);
}

Bool RegularExprParser::FindNext(LONG &lPos, String &strPattern)
{
  RegExprLibCallR(FALSE, FindNext)(lPos, strPattern);
}

void RegularExprParser::CleanUp()
{
  RegExprLibCall(CleanUp)();
}
