#include "ge_math.h"
#include "operatingsystem.h"
#include "c4d_gl.h"

#define GlStringCall(fn) (this->*C4DOS.GL->fn)
#define GlPFCall(fn) (this->*C4DOS.GL->fn)
#define GlVBCall(fn) (this->*C4DOS.GL->fn)

/************************************************************************/
/* GlString                                                             */
/************************************************************************/
GlString::GlString()
{
	GlStringCall(SDKInit1)();
}

GlString::GlString(const char* pszString)
{
	GlStringCall(SDKInit2)(pszString);
}

GlString::GlString(const GlString& str)
{
	GlStringCall(SDKInit3)(str);
}

GlString::GlString(LONG n)
{
	GlStringCall(SDKInit4)(n);
}

GlString::GlString(Real r, const char* pszFormat)
{
	GlStringCall(SDKInit5)(r, pszFormat);
}

GlString::~GlString()
{
	GlStringCall(SDKFree)();
}

const GlString& GlString::operator = (const GlString &str)
{
	return GlStringCall(SDKAssign1)(str);
}

const GlString& GlString::operator = (const char* pszString)
{
	return GlStringCall(SDKAssign2)(pszString);
}

const GlString operator + (const GlString &str1, const GlString &str2)
{
	return C4DOS.GL->GlStringAdd1(str1, str2);
}

const GlString& GlString::operator += (const GlString &str)
{
	return GlStringCall(GlStringAdd3)(str);
}

const GlString operator + (const GlString &str1, const char* str2)
{
	return C4DOS.GL->GlStringAdd2(str1, str2);
}

const GlString& GlString::operator += (const char* str)
{
	return GlStringCall(GlStringAdd4)(str);
}

const char* GlString::GetCString() const
{
	return GlStringCall(GetCString)();
}

VLONG GlString::GetLength() const
{
	return GlStringCall(GetLength)();
}


/************************************************************************/
/* GlProgramFactory                                                   */
/************************************************************************/
GlProgramFactory::GlProgramFactory()
{
}

GlProgramFactory::~GlProgramFactory()
{
}

GlProgramFactory* GlProgramFactory::GetFactory(C4DAtom* pObj, LONG lIndex, BaseDraw* pBaseDraw, GlLight* pLights, LONG lLightCount,
	void* pIdentity, VLONG lIdentityLength, LONG lTexCoordIndex, Bool bAllowSharing)
{
	return C4DOS.GL->GetFactory(pObj, lIndex, pBaseDraw, pLights, lLightCount, pIdentity, lIdentityLength, lTexCoordIndex, bAllowSharing);
}

void GlProgramFactory::RemoveReference(C4DAtom* pObj, LONG lIndex)
{
	C4DOS.GL->RemoveReference(pObj, lIndex);
}

void GlProgramFactory::RemoveTextureReference(C4DAtom* pObj, LONG lIndex)
{
	C4DOS.GL->RemoveTextureReference(pObj, lIndex);
}

#undef IncreaseBufferSize
void* GlProgramFactory::_IncreaseBufferSize(GlGetIdentity* pIdentity, VLONG lNeededSize, LONG lLine, const char* pszFile)
{
	return C4DOS.GL->IncreaseBufferSize(pIdentity, lNeededSize, lLine, pszFile);
}

Bool GlProgramFactory::BindToView(BaseDraw* pDraw)
{
	return GlPFCall(BindToView)(pDraw);
}

Bool GlProgramFactory::CompilePrograms()
{
	return GlPFCall(CompilePrograms)();
}

Bool GlProgramFactory::BindPrograms()
{
	return GlPFCall(BindPrograms)();
}

Bool GlProgramFactory::UnbindPrograms()
{
	return GlPFCall(UnbindPrograms)();
}

Bool GlProgramFactory::DestroyPrograms(Bool bChangeContext)
{
	return GlPFCall(DestroyPrograms)(bChangeContext);
}

void GlProgramFactory::LockFactory()
{
	GlPFCall(LockFactory)();
}

void GlProgramFactory::Unlock()
{
	GlPFCall(Unlock)();
}

Bool GlProgramFactory::InitLightParameters()
{
	return GlPFCall(InitLightParameters)();
}

LONG GlProgramFactory::GetMaxLights()
{
	return GlPFCall(GetMaxLights)();
}

void* GlProgramFactory::GetPrivateData(C4DAtom* pObj, LONG lDataIndex, GlProgramFactoryAllocPrivate fnAlloc, GlProgramFactoryFreePrivate fnFree)
{
	return GlPFCall(GetPrivateData)(pObj, lDataIndex, fnAlloc, fnFree);
}

void* GlProgramFactory::GetDescriptionData(LONG lObjIndex, LONG lDataIndex, GlProgramFactoryAllocPrivate fnAlloc, GlProgramFactoryFreePrivate fnFree)
{
	return GlPFCall(GetDescriptionData)(lObjIndex, lDataIndex, fnAlloc, fnFree);
}

Bool GlProgramFactory::IsProgram(GlProgramType t)
{
	return GlPFCall(IsProgram)(t);
}

void GlProgramFactory::InitSetParameters()
{
	GlPFCall(InitSetParameters)();
}

void GlProgramFactory::SetScreenCoordinates(BaseDraw* pBaseDraw)
{
	GlPFCall(SetScreenCoordinates)(pBaseDraw);
}

void GlProgramFactory::AddErrorHandler(GlProgramFactoryErrorHandler fn)
{
	GlPFCall(AddErrorHandler)(fn);
}

Bool GlProgramFactory::SetParameterMatrixState(GlProgramType t, const char* pszName)
{
	return GlPFCall(SetParameterMatrixState)(t, pszName);
}

Bool GlProgramFactory::SetParameterMatrix(GlProgramType t, const char* pszName, const Matrix4 &m)
{
	return GlPFCall(SetParameterMatrix1)(t, pszName, m);
}

Bool GlProgramFactory::SetParameterMatrix3x3(GlProgramType t, const char* pszName, const Real* r)
{
	return GlPFCall(SetParameterMatrix3x3)(t, pszName, r);
}

Bool GlProgramFactory::SetParameterMatrix4x4(GlProgramType t, const char* pszName, const Real* r)
{
	return GlPFCall(SetParameterMatrix4x4)(t, pszName, r);
}

Bool GlProgramFactory::SetParameterVector(GlProgramType t, const char* pszName, const Vector &v)
{
	return GlPFCall(SetParameterVector1)(t, pszName, v);
}

Bool GlProgramFactory::SetParameterVector(GlProgramType t, const char* pszName, const Vector &v, Real w)
{
	return GlPFCall(SetParameterVector2)(t, pszName, v, w);
}

Bool GlProgramFactory::SetParameterReal(GlProgramType t, const char* pszName, const Real r)
{
	return GlPFCall(SetParameterReal)(t, pszName, r);
}

Bool GlProgramFactory::SetParameterReal2(GlProgramType t, const char* pszName, Real a, Real b)
{
	return GlPFCall(SetParameterReal2a)(t, pszName, a, b);
}

Bool GlProgramFactory::SetParameterReal2(GlProgramType t, const char* pszName, const Real* v)
{
	return GlPFCall(SetParameterReal2b)(t, pszName, v);
}

Bool GlProgramFactory::SetParameterReal3(GlProgramType t, const char* pszName, Real a, Real b, Real c)
{
	return GlPFCall(SetParameterReal3a)(t, pszName, a, b, c);
}

Bool GlProgramFactory::SetParameterReal3(GlProgramType t, const char* pszName, const Real* v)
{
	return GlPFCall(SetParameterReal3b)(t, pszName, v);
}

Bool GlProgramFactory::SetParameterReal4(GlProgramType t, const char* pszName, Real a, Real b, Real c, Real d)
{
	return GlPFCall(SetParameterReal4a)(t, pszName, a, b, c, d);
}

Bool GlProgramFactory::SetParameterReal4(GlProgramType t, const char* pszName, const Real* v)
{
	return GlPFCall(SetParameterReal4b)(t, pszName, v);
}

Bool GlProgramFactory::SetParameterRealArray(GlProgramType t, const char* pszName, LONG lElements, const Real *r)
{
	return GlPFCall(SetParameterRealArray)(t, pszName, lElements, r);
}

Bool GlProgramFactory::SetParameterTexture2D(GlProgramType t, const char* pszName, const BaseBitmap* pBmp, LONG lFlags, LONG lAlphaMode, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterTexture2D1)(t, pszName, pBmp, lFlags, lAlphaMode, pnHandle);
}

Bool GlProgramFactory::SetParameterTexture2D(GlProgramType t, const char* pszName, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* lTextureDepth, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterTexture2D2)(t, pszName, fn, lFrame, pObj, lIndex, lFlags, lAlphaMode, lMaxSize, pLayerSet, plWidth, plHeight, lTextureDepth, pnHandle);
}

Bool GlProgramFactory::SetParameterTexture(GlProgramType t, const char* pszName, LONG lDimension, C4DGLuint nTexture)
{
	return GlPFCall(SetParameterTexture)(t, pszName, lDimension, nTexture);
}

Bool GlProgramFactory::SetParameterGradient(GlProgramType t, const char* pszName, Gradient* pGradient, C4DAtom* pObj, LONG lIndex, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterGradient)(t, pszName, pGradient, pObj, lIndex, pnHandle);
}

Bool GlProgramFactory::SetParameterFunctionTexture(GlProgramType t, const char* pszName, C4DAtom* pObj, LONG lIndex, GlProgramFactoryCreateFnCallback fn, void* pData, VLONG lDataLen,
		LONG lInParams, LONG lOutParams, LONG lCycle, Bool bInterpolate, LONG lSizeX, LONG lSizeY, LONG lSizeZ, Bool bParallel, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterFunctionTexture)(t, pszName, pObj, lIndex, fn, pData, lDataLen, lInParams, lOutParams, lCycle, bInterpolate, lSizeX, lSizeY, lSizeZ, bParallel, pnHandle);
}

Bool GlProgramFactory::SetParameterMatrixState(GlProgramParameter param)
{
	return GlPFCall(SetParameterMatrixStateP)(param);
}

Bool GlProgramFactory::SetParameterMatrix(GlProgramParameter param, const Matrix4 &m)
{
	return GlPFCall(SetParameterMatrix1P)(param, m);
}

Bool GlProgramFactory::SetParameterMatrix3x3(GlProgramParameter param, const Real* r)
{
	return GlPFCall(SetParameterMatrix3x3P)(param, r);
}

Bool GlProgramFactory::SetParameterMatrix4x4(GlProgramParameter param, const Real* r)
{
	return GlPFCall(SetParameterMatrix4x4P)(param, r);
}

Bool GlProgramFactory::SetParameterVector(GlProgramParameter param, const Vector &v)
{
	return GlPFCall(SetParameterVector1P)(param, v);
}

Bool GlProgramFactory::SetParameterVector(GlProgramParameter param, const Vector &v, Real w)
{
	return GlPFCall(SetParameterVector2P)(param, v, w);
}

Bool GlProgramFactory::SetParameterReal(GlProgramParameter param, const Real r)
{
	return GlPFCall(SetParameterRealP)(param, r);
}

Bool GlProgramFactory::SetParameterReal2(GlProgramParameter param, Real a, Real b)
{
	return GlPFCall(SetParameterReal2aP)(param, a, b);
}

Bool GlProgramFactory::SetParameterReal2(GlProgramParameter param, const Real* v)
{
	return GlPFCall(SetParameterReal2bP)(param, v);
}

Bool GlProgramFactory::SetParameterReal3(GlProgramParameter param, Real a, Real b, Real c)
{
	return GlPFCall(SetParameterReal3aP)(param, a, b, c);
}

Bool GlProgramFactory::SetParameterReal3(GlProgramParameter param, const Real* v)
{
	return GlPFCall(SetParameterReal3bP)(param, v);
}

Bool GlProgramFactory::SetParameterReal4(GlProgramParameter param, Real a, Real b, Real c, Real d)
{
	return GlPFCall(SetParameterReal4aP)(param, a, b, c, d);
}

Bool GlProgramFactory::SetParameterReal4(GlProgramParameter param, const Real* v)
{
	return GlPFCall(SetParameterReal4bP)(param, v);
}

Bool GlProgramFactory::SetParameterRealArray(GlProgramParameter param, LONG lElements, const Real *r)
{
	return GlPFCall(SetParameterRealArrayP)(param, lElements, r);
}

Bool GlProgramFactory::SetParameterTexture2D(GlProgramParameter param, const BaseBitmap* pBmp, LONG lFlags, LONG lAlphaMode, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterTexture2D1P)(param, pBmp, lFlags, lAlphaMode, pnHandle);
}

Bool GlProgramFactory::SetParameterTexture2D(GlProgramParameter param, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* lTextureDepth, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterTexture2D2P)(param, fn, lFrame, pObj, lIndex, lFlags, lAlphaMode, lMaxSize, pLayerSet, plWidth, plHeight, lTextureDepth, pnHandle);
}

Bool GlProgramFactory::SetParameterTexture2D(GlProgramParameter param, BaseBitmap* pBmp, ULONG ulDirty, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterTexture2D3P)(param, pBmp, ulDirty, pObj, lIndex, lFlags, lAlphaMode, lMaxSize, plWidth, plHeight, plTextureDepth, pnHandle);
}

Bool GlProgramFactory::CacheTextureFn(BaseDraw* pBaseDraw, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, GlProgramType progType, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle)
{
	return C4DOS.GL->CacheTextureFn(pBaseDraw, fn, lFrame, pObj, lIndex, lFlags, lAlphaMode, lMaxSize, progType, pLayerSet, plWidth, plHeight, plTextureDepth, pnHandle);
}

Bool GlProgramFactory::CacheTextureBmp(BaseDraw* pBaseDraw, const BaseBitmap* pBmp, ULONG ulDirty, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, GlProgramType progType, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle)
{
	return C4DOS.GL->CacheTextureBmp(pBaseDraw, pBmp, ulDirty, pObj, lIndex, lFlags, lAlphaMode, lMaxSize, progType, plWidth, plHeight, plTextureDepth, pnHandle);
}

Bool GlProgramFactory::SetParameterTexture(GlProgramParameter param, LONG lDimension, C4DGLuint nTexture)
{
	return GlPFCall(SetParameterTextureP)(param, lDimension, nTexture);
}

Bool GlProgramFactory::SetParameterTexture2DDepth(GlProgramParameter param, C4DGLuint nTexture)
{
	return GlPFCall(SetParameterTexture2DDepthP)(param, nTexture);
}

Bool GlProgramFactory::SetParameterGradient(GlProgramParameter param, Gradient* pGradient, C4DAtom* pObj, LONG lIndex, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterGradientP)(param, pGradient, pObj, lIndex, pnHandle);
}

Bool GlProgramFactory::SetParameterFunctionTexture(GlProgramParameter param, C4DAtom* pObj, LONG lIndex, GlProgramFactoryCreateFnCallback fn, void* pData, VLONG lDataLen,
		LONG lInParams, LONG lOutParams, LONG lCycle, Bool bInterpolate, LONG lSizeX, LONG lSizeY, LONG lSizeZ, Bool bParallel, C4DGLuint* pnHandle)
{
	return GlPFCall(SetParameterFunctionTextureP)(param, pObj, lIndex, fn, pData, lDataLen, lInParams, lOutParams, lCycle, bInterpolate, lSizeX, lSizeY, lSizeZ, bParallel, pnHandle);
}

Bool GlProgramFactory::SetLightParameters(GlLight* pLights, LONG lLightCount, const Matrix4& mObject)
{
	return GlPFCall(SetLightParameters)(pLights, lLightCount, mObject);
}

ULONG GlProgramFactory::Init()
{
	return GlPFCall(Init)();
}

void GlProgramFactory::AddParameters(ULONG ulParameters, ULONG ulFormat)
{
	GlPFCall(AddParameters)(ulParameters, ulFormat);
}

ULONG GlProgramFactory::GetParameters()
{
	return GlPFCall(GetParameters)();
}

ULONG GlProgramFactory::GetParameterFormats()
{
	return GlPFCall(GetParameterFormats)();
}

GlString GlProgramFactory::AddUniformParameter(GlProgramType t, GlUniformParamType p, const char* pszName)
{
	return GlPFCall(AddUniformParameter1)(t, p, pszName);
}

GlString GlProgramFactory::AddUniformParameter(GlProgramType t, GlUniformParamType p, LONG lCount, const char* pszName)
{
	return GlPFCall(AddUniformParameter2)(t, p, lCount, pszName);
}

Bool GlProgramFactory::HeaderFinished()
{
	return GlPFCall(HeaderFinished)();
}

UCHAR* GlProgramFactory::GetIdentity()
{
	return GlPFCall(GetIdentity)();
}

GlProgramParameter GlProgramFactory::GetParameterHandle(GlProgramType t, const char* pszName)
{
	return GlPFCall(GetParameterHandle)(t, pszName);
}

Bool GlProgramFactory::AddLightProjection()
{
	return GlPFCall(AddLightProjection)();
}

void GlProgramFactory::AddLine(GlProgramType t, const GlString &strLine)
{
	GlPFCall(AddLine)(t, strLine);
}

Bool GlProgramFactory::AddEncryptedBlock(GlProgramType t, const char* pchData, VLONG lDataLength, const UCHAR* pchKey, LONG lKeyLength)
{
	return GlPFCall(AddEncryptedBlock)(t, pchData, lDataLength, pchKey, lKeyLength);
}

GlString GlProgramFactory::AddColorBlendFunction(GlProgramType t, LONG lBlendMode)
{
	return GlPFCall(AddColorBlendFunction)(t, lBlendMode);
}

GlString GlProgramFactory::AddRGBToHSVFunction(GlProgramType t)
{
	return GlPFCall(AddRGBToHSVFunction)(t);
}

GlString GlProgramFactory::AddHSVToRGBFunction(GlProgramType t)
{
	return GlPFCall(AddHSVToRGBFunction)(t);
}

GlString GlProgramFactory::AddRGBToHLSFunction(GlProgramType t)
{
	return GlPFCall(AddRGBToHLSFunction)(t);
}

GlString GlProgramFactory::AddHLSToRGBFunction(GlProgramType t)
{
	return GlPFCall(AddHLSToRGBFunction)(t);
}

void GlProgramFactory::StartLightLoop()
{
	GlPFCall(StartLightLoop)();
}

Bool GlProgramFactory::EndLightLoop()
{
	return GlPFCall(EndLightLoop)();
}

GlString GlProgramFactory::GetUniqueID()
{
	return GlPFCall(GetUniqueID)();
}

Bool GlProgramFactory::HasNoiseSupport(GlProgramType t, LONG lNoise, BaseDraw* pBaseDraw, LONG lCompiler)
{
	return C4DOS.GL->HasNoiseSupport(t, lNoise, pBaseDraw, lCompiler);
}

const GlString& GlProgramFactory::AddNoiseFunction(GlProgramType t, LONG lNoise, LONG lFlags)
{
	return GlPFCall(AddNoiseFunction)(t, lNoise, lFlags);
}

ULONG GlProgramFactory::GetLanguageFeatures(LONG lCompiler, LONG lFlags)
{
	return C4DOS.GL->GetLanguageFeatures(lCompiler, lFlags);
}

LONG GlProgramFactory::GetCompiler()
{
	return GlPFCall(GetCompiler)();
}

/************************************************************************/
/* GlFrameBuffer                                                        */
/************************************************************************/
GlFrameBuffer* GlFrameBuffer::GetFrameBuffer(BaseDraw* pBaseDraw, VULONG lID1, LONG lID2, UINT nWidth, UINT nHeight, LONG lColorTextureCount, 
																						 LONG lDepthTextureCount, LONG lFlags, LONG lAAMode)
{
	return C4DOS.GL->GetFrameBuffer(pBaseDraw, lID1, lID2, nWidth, nHeight, lColorTextureCount, lDepthTextureCount, lFlags, lAAMode);
}

GlFrameBuffer* GlFrameBuffer::FindFrameBuffer(BaseDraw* pBaseDraw, VULONG lID1, LONG lID2)
{
	return C4DOS.GL->FindFrameBuffer(pBaseDraw, lID1, lID2);
}

void GlFrameBuffer::RemoveObject(VULONG lID1, LONG lID2)
{
	C4DOS.GL->RemoveObjectF(lID1, lID2);
}

void GlFrameBuffer::PrepareForRendering(LONG lTexture)
{
	GlPFCall(PrepareForRendering)(lTexture);
}

void GlFrameBuffer::SetInterpolation(LONG lInterpolate, LONG lTexture)
{
	GlPFCall(SetInterpolation)(lInterpolate, lTexture);
}

Bool GlFrameBuffer::Activate(BaseDraw* pBaseDraw)
{
	return GlPFCall(Activate)(pBaseDraw);
}

void GlFrameBuffer::Deactivate(BaseDraw* pBaseDraw)
{
	GlPFCall(Deactivate)(pBaseDraw);
}

Bool GlFrameBuffer::SetRenderTarget(LONG lTexture, LONG lFlags)
{
	return GlPFCall(SetRenderTarget)(lTexture, lFlags);
}

void GlFrameBuffer::GetRatios(Real& rWidth, Real& rHeight)
{
	GlPFCall(GetRatios)(rWidth, rHeight);
}

void GlFrameBuffer::GetSize(UINT &nWidth, UINT &nHeight, Bool bFramesize)
{
	GlPFCall(GetSize)(nWidth, nHeight, bFramesize);
}

C4DGLuint GlFrameBuffer::GetTexture(LONG lTexture, LONG lFlags)
{
	return GlPFCall(GetTexture)(lTexture, lFlags);
}

LONG GlFrameBuffer::SaveTextureToDisk(const Filename &fn, LONG lTexture, LONG lFlags)
{
	return GlPFCall(SaveTextureToDisk)(fn, lTexture, lFlags);
}

Bool GlFrameBuffer::CopyToBitmap(BaseBitmap* pBmp, LONG lTexture, LONG lFlags)
{
	return GlPFCall(CopyToBitmap)(pBmp, lTexture, lFlags);
}

Bool GlFrameBuffer::GetTextureData(LONG x1, LONG y1, LONG x2, LONG y2, void* pData, LONG lTexture, LONG lFlags)
{
	return GlPFCall(GetTextureData)(x1, y1, x2, y2, pData, lTexture, lFlags);
}

Bool GlFrameBuffer::DrawBuffer(LONG lTexture, LONG lFlags, Real rAlpha, const Vector &vColor)
{
	return GlPFCall(DrawBuffer)(lTexture, lFlags, rAlpha, vColor);
}

void GlFrameBuffer::Clear()
{
	GlPFCall(Clear1)();
}

void GlFrameBuffer::Clear(const Vector &vColor, Real rAlpha)
{
	GlPFCall(Clear2)(vColor, rAlpha);
}

Bool GlFrameBuffer::IsNPOTBuffer()
{
	return GlPFCall(IsNPOTBuffer)();
}

/************************************************************************/
/* GlVertexBuffer                                                       */
/************************************************************************/
GlVertexBuffer* GlVertexBuffer::GetVertexBuffer(BaseDraw* pBaseDraw, C4DAtom* pObj, LONG lIndex, void* pIdentity, VLONG lIdentityLen, LONG lFlags)
{
	return C4DOS.GL->GetVertexBuffer(pBaseDraw, pObj, lIdentityLen, pIdentity, lIdentityLen, lFlags);
}

void GlVertexBuffer::RemoveObject(C4DAtom* pObj, LONG lIndex)
{
	C4DOS.GL->RemoveObjectV(pObj, lIndex);
}

VLONG GlVertexBuffer::GetDefaultSize()
{
	return C4DOS.GL->GetDefaultSize();
}

void GlVertexBuffer::SetDefaultSize(VLONG lSize)
{
	C4DOS.GL->SetDefaultSize(lSize);
}

VLONG GlVertexBuffer::GetBufferSize()
{
	return GlVBCall(GetBufferSize)();
}

void GlVertexBuffer::SetSubBufferSize(VLONG lSize)
{
	GlVBCall(SetSubBufferSize)(lSize);
}

Bool GlVertexBuffer::SetDataOffset(LONG lElement, LONG lID, LONG lDataFormat, LONG lCount, VLONG lOffset, VLONG lStride)
{
	return GlVBCall(SetDataOffset)(lElement, lID, lDataFormat, lCount, lOffset, lStride);
}

void GlVertexBuffer::ResetDataOffsets()
{
	GlVBCall(ResetDataOffsets)();
}

Bool GlVertexBuffer::IsDirty()
{
	return GlVBCall(IsDirty)();
}

void GlVertexBuffer::SetDirty(Bool bDirty)
{
	GlVBCall(SetDirty)(bDirty);
}

Bool GlVertexBuffer::Draw(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, const Vector* pvColor, Real* prAlpha)
{
	return GlVBCall(Draw)(pBaseDraw, lID1, lID2, pvColor, prAlpha);
}

Bool GlVertexBuffer::DrawSubBuffer(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lMode, LONG lIndex, LONG lFirst, LONG lCount, 
	BaseSelect* pDrawElements, const Vector* pvColor, Real* prAlpha)
{
	return GlVBCall(DrawSubBuffer)(pBaseDraw, lID1, lID2, lMode, lIndex, lFirst, lCount, pDrawElements, pvColor, prAlpha);
}

Bool GlVertexBuffer::DrawSubBufferFan(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lMode, LONG lIndex, LONG lStripCount, 
		LONG lFirst, LONG *plCount, const Vector* pvColor, Real* prAlpha, GlVertexBufferDrawFanCallback fn, void* pCallbackData, Bool bReverse)
{
	return GlVBCall(DrawSubBufferFan)(pBaseDraw, lID1, lID2, lMode, lIndex, lStripCount, lFirst, plCount, pvColor, prAlpha, fn, pCallbackData, bReverse);
}

Bool GlVertexBuffer::AllocSubBuffers(LONG lID1, VLONG lID2, LONG lElementCount, VLONG lElementSize, LONG &lCount, VLONG &lBufferElementCount)
{
	return GlVBCall(AllocSubBuffers)(lID1, lID2, lElementCount, lElementSize, lCount, lBufferElementCount);
}

Bool GlVertexBuffer::AllocSubBuffersFan(LONG lID1, VLONG lID2, LONG lPolyCount, LONG* plCount, VLONG lElementSize, LONG &lCount, VLONG &lBufferElementCount)
{
	return GlVBCall(AllocSubBuffersFan)(lID1, lID2, lPolyCount, plCount, lElementSize, lCount, lBufferElementCount);
}

VLONG GlVertexBuffer::GetSubBufferElementCount(LONG lID1, VLONG lID2)
{
	return GlVBCall(GetSubBufferElementCount)(lID1, lID2);
}

LONG GlVertexBuffer::GetSubBufferCount(LONG lID1, VLONG lID2)
{
	return GlVBCall(GetSubBufferCount)(lID1, lID2);
}

void* GlVertexBuffer::GetSubBufferData(LONG lID1, VLONG lID2)
{
	return GlVBCall(GetSubBufferData)(lID1, lID2);
}

Bool GlVertexBuffer::UpdateSubBuffer(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lIndex, Bool bFreeTempData)
{
	return GlVBCall(UpdateSubBuffer)(pBaseDraw, lID1, lID2, lIndex, bFreeTempData);
}

void GlVertexBuffer::TouchAllBuffers()
{
	GlVBCall(TouchAllBuffers)();
}

void GlVertexBuffer::FreeUnusedBuffers()
{
	GlVBCall(FreeUnusedBuffers)();
}

void* GlVertexBuffer::MapBuffer(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lIndex, LONG lFlags)
{
	return GlVBCall(MapBuffer)(pBaseDraw, lID1, lID2, lIndex, lFlags);
}

Bool GlVertexBuffer::UnmapBuffer(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lIndex)
{
	return GlVBCall(UnmapBuffer)(pBaseDraw, lID1, lID2, lIndex);
}
