#include "c4d_gedata.h"
#include "ge_vector.h"
#include "c4d_string.h"
#include "c4d_memory.h"
#include "c4d_basecontainer.h"
#include "ge_matrix.h"
#include "c4d_file.h"
#include "c4d_baselist.h"

BaseList2D *GeData::GetLink(BaseDocument *doc, LONG instanceof) const
{
	BaseLink *link=C4DOS.Gd->GetLink(this);
	if (!link) return NULL;
	return link->GetLink(doc,instanceof);
}

C4DAtomGoal *GeData::GetLinkAtom(BaseDocument *doc, LONG instanceof) const
{
	BaseLink *link=C4DOS.Gd->GetLink(this);
	if (!link) return NULL;
	return link->GetLinkAtom(doc,instanceof);
}

BrowseContainer::BrowseContainer(const BaseContainer *bc)
{
	t_bc		= (BaseContainer*)bc;
	handle	= C4DOS.Bc->BrowseContainer(t_bc,NULL,NULL,NULL);
}

void BrowseContainer::Reset(void)
{
	handle	= C4DOS.Bc->BrowseContainer(t_bc,NULL,NULL,NULL);
}

Bool BrowseContainer::GetNext(LONG *id,GeData **data)
{
	if (!handle) return FALSE;
	handle = C4DOS.Bc->BrowseContainer(t_bc,id,data,handle);
	return TRUE;
}
