/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4D_FILTERDATA_H
#define __C4D_FILTERDATA_H

#include "c4d_nodedata.h"
#include "c4d_file.h"

class Filename;
class String;
class BaseContainer;
class BaseDocument;
class BaseBitmap;
class PluginSceneLoader;
class PluginSceneSaver;
class PluginMovieData;
class BaseThread;
class BaseSound;

#define PLUGINFLAG_BITMAPLOADER_MOVIE								(1<<6)

struct BitmapLoaderAnimatedData
{
	BitmapLoaderAnimatedData() { LONG i; for (i=0; i<16; i++) moviedata[i]=NULL; }

	Filename	moviename;
	void*			moviedata[16];
};

#define BITMAPLOADER_INIT	1
#define BITMAPLOADER_LOAD	2
#define BITMAPLOADER_FREE	3

class BitmapLoaderData : public BaseData
{
	public:
		virtual Bool Identify(const Filename &name, UCHAR *probe, LONG size)=0;
		virtual LONG Load(const Filename &name, BaseBitmap *bm, LONG frame)=0;
		virtual LONG GetSaver(void);
		virtual Bool GetInformation(const Filename &name, LONG *frames, Real *fps);
		virtual LONG LoadAnimated(BitmapLoaderAnimatedData *bd, LONG action, BaseBitmap *bm, LONG frame);
		virtual LONG ExtractSound(BitmapLoaderAnimatedData *bd, BaseSound *snd);
};

#define PLUGINFLAG_BITMAPSAVER_SUPPORT_8BIT  				(1<<1)
#define PLUGINFLAG_BITMAPSAVER_SUPPORT_16BIT				(1<<2)
#define PLUGINFLAG_BITMAPSAVER_SUPPORT_32BIT 				(1<<0)
#define PLUGINFLAG_BITMAPSAVER_SUPPORT_8BIT_LAYERS	(1<<3)
#define PLUGINFLAG_BITMAPSAVER_SUPPORT_16BIT_LAYERS	(1<<4)
#define PLUGINFLAG_BITMAPSAVER_SUPPORT_32BIT_LAYERS (1<<5)
#define PLUGINFLAG_BITMAPSAVER_MOVIE								(1<<6)

#define PLUGINFLAG_BITMAPSAVER_ALLOWOPTIONS					(1<<27)
#define PLUGINFLAG_BITMAPSAVER_FORCESUFFIX					(1<<26)

class BitmapSaverData : public BaseData
{
	public:
		virtual LONG Save(const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits);
		virtual Bool Edit(BaseContainer *data);
		virtual LONG GetMaxAlphas(BaseContainer *data);

		// additional calls for movie saver
		virtual LONG Open(PluginMovieData *&md, const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits, LONG fps);
		virtual LONG Write(PluginMovieData *md, BaseBitmap *bm);
		virtual void Close(PluginMovieData *&md);
		virtual LONG AddSound(PluginMovieData *md, BaseSound *snd);
};

#define SCENEFILTER_OBJECTS						(1<<0)
#define SCENEFILTER_MATERIALS					(1<<1)
#define SCENEFILTER_DIALOGSALLOWED		(1<<3)
#define SCENEFILTER_PROGRESSALLOWED		(1<<4)
#define SCENEFILTER_MERGESCENE				(1<<5)
#define SCENEFILTER_NONEWMARKERS			(1<<6)
#define SCENEFILTER_SAVECACHES				(1<<7) // for c4d export!

#define PLUGINFLAG_SCENELOADER_MERGEORIGINAL	(1<<26)
#define PLUGINFLAG_SCENEFILTER_DIALOGCONTROL	(1<<27)

class SceneLoaderData : public NodeData
{
	public:
		virtual Bool Identify(PluginSceneLoader *node, const Filename &name, UCHAR *probe, LONG size)=0;
		virtual LONG Load(PluginSceneLoader *node, const Filename &name, BaseDocument *doc, LONG filterflags, String *error, BaseThread *bt)=0;

		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max, ULONG flags);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////
};

class SceneSaverData : public NodeData
{
	public:
		virtual LONG Save(PluginSceneSaver *node, const Filename &name, BaseDocument *doc, LONG filterflags)=0;

		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max, ULONG flags);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////
};

Bool RegisterBitmapLoaderPlugin(LONG id, const String &str, LONG info, BitmapLoaderData *dat);
Bool RegisterBitmapSaverPlugin(LONG id, const String &str, LONG info, BitmapSaverData *dat, const String &suffix);
Bool RegisterSceneLoaderPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, void *emulation=NULL);
Bool RegisterSceneSaverPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, const String &suffix, void *emulation=NULL);

#endif
