// MatrixExtrudeDialolg.cpp
//////////////////////////////////////////////////////////////////////

#include "c4d.h"
#include "c4d_descriptiondialog.h"

void DescriptionToolData::InitDefaultSettings(BaseDocument *pDoc, BaseContainer &data)
{	
	data.SetLong(MDATA_INTERACTIVE,TRUE);

	ToolData::InitDefaultSettings(pDoc,data);
}

Bool DescriptionToolData::GetDDescription(BaseDocument *doc, BaseContainer &data, Description *description,LONG &flags)
{
	if (description->LoadDescription(GetToolPluginId()))
	{
		flags |= DESCFLAGS_DESC_LOADED;
		return TRUE;
	}
	return ToolData::GetDDescription(doc,data,description,flags);
}

Bool DescriptionToolData::GetDEnabling(BaseDocument *doc, BaseContainer &data, const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc)
{
	switch (id[0].id)
	{
		case MDATA_NEWTRANSFORM:		break;
		case MDATA_DEFAULTVALUES:		break;
		case MDATA_APPLY:
			if (!firstaction && /*(*dcu->descid)[0].id!=MDATA_DEFAULTVALUES && */ (data.GetLong(MDATA_INTERACTIVE) || data.GetLong(MDATA_TEMPINTERACTIVE)))
				return FALSE;
			break;

		case MDATA_INTERACTIVE:			break;
	}
	return SUPER::GetDEnabling(doc,data,id,t_data,flags,itemdesc);
}

Bool DescriptionToolData::InteractiveModeling_Restart(BaseDocument *doc)
{
	firstaction = FALSE;
	return ::InteractiveModeling_Restart(doc);
}

Bool DescriptionToolData::InitTool(BaseDocument *doc, BaseContainer &data, BaseThread *bt)
{
	firstaction = TRUE;
	return TRUE;
}

void DescriptionToolData::FreeTool(BaseDocument *doc, BaseContainer &data)
{
	firstaction = TRUE;
}

Bool DescriptionToolData::Message(BaseDocument *doc, BaseContainer &data, LONG type, void *t_data)
{
	if (type == MSG_TOOL_RESTART)
	{
		firstaction = TRUE;
	}
	if (type == MSG_DESCRIPTION_COMMAND)
	{
		DescriptionCommand *dc = (DescriptionCommand*) t_data;
		if (dc->id[0].id==MDATA_NEWTRANSFORM)
		{
			InteractiveModeling_Restart(GetActiveDocument());
			data.SetLong(MDATA_TEMPINTERACTIVE,TRUE);
			return TRUE;
		}
		else if (dc->id[0].id==MDATA_DEFAULTVALUES)
		{
			InitDefaultSettings(doc,data);
			return TRUE;
		}
		else if (dc->id[0].id==MDATA_APPLY || dc->id[0].id==IDC_OK)
		{
			data.SetLong(MDATA_TEMPINTERACTIVE,TRUE);
			firstaction = FALSE;
		}
	}
	if (type==MSG_DESCRIPTION_CHECKUPDATE)
	{
		DescriptionCheckUpdate *dcu = (DescriptionCheckUpdate*)t_data;
		dcu->drawflags |= MSG_DESCRIPTION_CHECKUPDATE_DOCUMENT|MSG_DESCRIPTION_CHECKUPDATE_SYNC;

		BasePlugin *plug = FindPlugin(GetToolPluginId(),C4DPL_TOOL);
		LONG dirty = 0;
		if (plug) dirty = plug->GetDirty(0);
		if (dirty!=last_dirty && !firstaction && /*(*dcu->descid)[0].id!=MDATA_DEFAULTVALUES && */ (data.GetLong(MDATA_INTERACTIVE) || data.GetLong(MDATA_TEMPINTERACTIVE)))
		{
			data.SetLong(MDATA_TEMPINTERACTIVE,FALSE);
			if (plug) dirty = plug->GetDirty(0);
			last_dirty = dirty;

			AutoAlloc<AtomArray> pActive;
			if (!doc || !pActive) return TRUE;

			// undo the step before
			InteractiveModeling_Rewind(doc);

			ModelingCommandData mu;

			doc->GetActiveObjects(*pActive, TRUE);
			ModelingCommandData md;
			md.bc = &data;
			md.arr = pActive;
			md.doc = doc;
			md.flags = MODELINGCOMMANDFLAG_CREATEUNDO;
			switch (doc->GetMode())
			{
				case Mpoints: md.mode = MODIFY_POINTSELECTION; break;
				case Mpolygons: md.mode  = MODIFY_POLYGONSELECTION; break;
				case Medges: md.mode  = MODIFY_EDGESELECTION; break;
				default: md.mode = -1; break;
			};
			//ATInteractStart(md.doc);

			StopAllThreads();
			if (md.doc)
				md.doc->StartUndo();

			SendModelingCommand(GetToolPluginId(), md);
			if (md.doc)
				md.doc->EndUndo();
			//ATInteractEnd(md.doc);
		}
	}
	return ToolData::Message(doc,data,type,t_data);
}

