#include "customgui_gradient.h"
#include "c4d_gui.h"

static CustomGuiGradientLib *lib_gradient = NULL;

static CustomGuiGradientLib *CheckLib(LONG offset)
{
	return (CustomGuiGradientLib*)CheckLib(CUSTOMGUI_GRADIENT,offset,(C4DLibrary**)&lib_gradient);
}

#define GradientCall(b) 			CustomGuiGradientLib *lib = CheckLib(LIBOFFSET(CustomGuiGradientLib,b)); \
															if (!lib || !lib->b) return; \
															(((iGradient*)this)->*lib->b)

#define GradientCallR(a,b) 		CustomGuiGradientLib *lib = CheckLib(LIBOFFSET(CustomGuiGradientLib,b)); \
															if (!lib || !lib->b) return a; \
															return (((iGradient*)this)->*lib->b)

#define GradientGuiCall(b) 		CustomGuiGradientLib *lib = CheckLib(LIBOFFSET(CustomGuiGradientLib,b)); \
															if (!lib || !lib->b) return; \
															(((iGradientCustomGui*)this)->*lib->b)

#define GradientGuiCallR(a,b) CustomGuiGradientLib *lib = CheckLib(LIBOFFSET(CustomGuiGradientLib,b)); \
															if (!lib || !lib->b) return a; \
															return (((iGradientCustomGui*)this)->*lib->b)

Bool Gradient::InvertKnots(void)
{
	GradientCallR(FALSE,InvertKnots)();
}

Bool Gradient::DoubleKnots(void)
{
	GradientCallR(FALSE,DoubleKnots)();
}

void Gradient::FlushKnots(void)
{
	GradientCall(FlushKnots)();
}

Bool Gradient::InitRender(void)
{
	GradientCallR(FALSE,InitRender)();
	return TRUE;
}

void Gradient::FreeRender(void)
{
	GradientCall(FreeRender)();
}

Vector Gradient::CalcGradientPixel(Real pos)
{
	GradientCallR(0.0,CalcGradientPixel)(pos);
}

LONG Gradient::GetKnotCount(void)
{
	GradientCallR(0,GetKnotCount)();
}

LONG Gradient::GetRenderKnotCount(void)
{
	GradientCallR(0,GetRenderKnotCount)();
}

LONG Gradient::InsertKnot(const GradientKnot &knot)
{
	GradientCallR(NOTOK,InsertKnot)(knot);
}

Bool Gradient::RemoveKnot(LONG index)
{
	GradientCallR(FALSE,RemoveKnot)(index);
}

GradientKnot *Gradient::GetRenderKnot(LONG index)
{
	GradientCallR(NULL,GetRenderKnot)(index);
}

GradientKnot Gradient::GetKnot(LONG index)
{
	GradientCallR(GradientKnot(),GetKnot)(index);
}

void Gradient::SetKnot(LONG index, const GradientKnot &k)
{
	GradientCall(SetKnot)(index,k);
}

GeData Gradient::GetData(LONG id) const
{
	GradientCallR(GeData(),iGetData)(id);
}

Bool Gradient::SetData(LONG id,const GeData &data)
{
	GradientCallR(FALSE,iSetData)(id,data);
}

Gradient* Gradient::GetAlphaGradient(void)
{
	GradientCallR(NULL,GetAlphaGradient)();
}

Gradient* Gradient::AllocAlphaGradient(void)
{
	GradientCallR(NULL,AllocAlphaGradient)();
}

Gradient *Gradient::Alloc()
{
	CustomGuiGradientLib *lib = CheckLib(LIBOFFSET(CustomGuiGradientLib,AllocGradient));
	if (!lib || !lib->AllocGradient) return NULL;
	return lib->AllocGradient();
}

void Gradient::Free(Gradient *&grad)
{
	CustomGuiGradientLib *lib = CheckLib(LIBOFFSET(CustomGuiGradientLib,FreeGradient));
	if (lib && lib->FreeGradient) lib->FreeGradient(grad);
	grad=NULL;
}

ULONG Gradient::GetChecksum()
{
	GradientCallR(0,GetChecksum)();
}

Gradient* GradientCustomGui::GetGradient()
{
	GradientGuiCallR(NULL,GetGradient)();
}
										
LONG GradientCustomGui::GetActiveKnot(Bool &bias)
{
	GradientGuiCallR(NOTOK,GetActiveKnot)(bias);
}

void GradientCustomGui::SetActiveKnot(LONG index, Bool bias)
{
	GradientGuiCall(SetActiveKnot)(index,bias);
}
