/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2006 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DCTRACKDATA_H
#define __C4DCTRACKDATA_H

#include "c4d_nodedata.h"

class  CTrack;
class  BaseList2D;
class  BaseKey;
class  BaseDocument;
class  BaseTime;
class  GeClipMap;
class  CAnimInfo;

class CTrackData : public NodeData
{
	public:
		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max, ULONG flags);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////

		virtual Bool		Animate				(CTrack *track, const CAnimInfo *info, Bool *chg, void *data);
		virtual LONG		GuiMessage		(CTrack *track, const BaseContainer &msg,BaseContainer &result);
		virtual Bool		Draw					(CTrack *track, GeClipMap *map, const BaseTime &clip_left, const BaseTime &clip_right);
		virtual LONG		GetHeight			(CTrack *track);
		virtual Bool		FillKey				(CTrack *track, BaseDocument *doc, BaseList2D *bl, CKey *key);
		virtual Bool    TrackInformation(CTrack *track, BaseDocument *doc, CKey *key, String *str, Bool set);

		virtual Bool		KeyMessage				(CTrack *track, CKey *node, LONG type, void *data);
		virtual Bool		KeyGetDDescription(CTrack *track, CKey *node, Description *description,LONG &flags);
		virtual Bool		KeyGetDParameter	(CTrack *track, CKey *node, const DescID &id,GeData &t_data,LONG &flags);
		virtual Bool		KeyGetDEnabling		(CTrack *track, CKey *node, const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		virtual Bool		KeySetDParameter	(CTrack *track, CKey *node, const DescID &id,const GeData &t_data,LONG &flags);
};

Bool RegisterCTrackPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, LONG disklevel);

#endif
