/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DBASESELECT_H
#define __C4DBASESELECT_H

#include "operatingsystem.h"
#include "c4d_file.h"

class BaseSelect
{
	private:
		BaseSelect();
		~BaseSelect();
	public:
		void FlushAll(void);

		LONG GetCount(void) const;
		LONG GetSegments(void) const;

		Bool Select(LONG num);           
		Bool SelectAll(LONG min, LONG max);

		Bool Deselect(LONG num);
		Bool DeselectAll(void);

		Bool Toggle(LONG num);
		Bool ToggleAll(LONG min, LONG max);

		Bool GetRange(LONG seg, LONG *a, LONG *b) const;
		
		Bool IsSelected(LONG num) const { return C4DOS.Bs->IsSelected(this,num); }

		Bool CopyTo(BaseSelect *dest) const;
		Bool Merge(BaseSelect *src);
		Bool Deselect(BaseSelect *src);
		BaseSelect *GetClone(void) const;

		Bool FromArray(UCHAR *selection, LONG count);
		UCHAR *ToArray(LONG count) const;

		void Write(HyperFile *hf);
		Bool Read(HyperFile *hf);

		static BaseSelect *Alloc(void);
		static void Free(BaseSelect *&bs);

		Bool FindSegment(LONG num, LONG *segment) const { return C4DOS.Bs->FindSegment(this,num,segment); }
		LONG *GetData()  { return C4DOS.Bs->GetData(this); }
		Bool CopyFrom(LONG *ndata, LONG ncnt) { return C4DOS.Bs->CopyFrom(this,ndata,ncnt); }

		LONG GetDirty() const { return C4DOS.Bs->GetDirty(this); }
};

#endif
