/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __X4D_MACROS_H
#define __X4D_MACROS_H

#define offsetofI(s,m)   ((VULONG)&(((s *)0)->m))						// from stddef

//----------------------------------------------------------------------------------------
// Structure alignment
//----------------------------------------------------------------------------------------
#define	VARIABLE_ARRAY_SIZE	1																// constant for arrays with variable size

//----------------------------------------------------------------------------------------
// Byte order for the destination platform
//----------------------------------------------------------------------------------------
#if _MSC_VER																								// MSVC

	#define	GE_LITTLE_ENDIAN	1
	#ifndef LITTLE_ENDIAN
		#define	LITTLE_ENDIAN	"please replace with GE_LITTLE_ENDIAN"
	#endif
	
#elif	__GNUC__																							// GNU
	#ifdef __BIG_ENDIAN__
		#define	GE_LITTLE_ENDIAN	0
	#elif	defined( __LITTLE_ENDIAN__ )
		#define	GE_LITTLE_ENDIAN	1
	#else
		#if defined( __ppc__ ) || defined( __ppc64__ )					// PPC-Code
			#define	GE_LITTLE_ENDIAN	0
		#elif defined( __m68k__ )																// 68k-Code
			#define	GE_LITTLE_ENDIAN	0
		#elif defined( __i386__ )	|| defined( __x86_64__ )			// x86-Code
			#define	GE_LITTLE_ENDIAN	1
		#endif
	#endif
#else

#error	"Unknown compiler, unknown endian format"

#endif

//----------------------------------------------------------------------------------------
// Macros for changing the byte order
//----------------------------------------------------------------------------------------
#define	REVERSE16( a )		(SWORD) (((UWORD)(a) >> 8 ) | ((UWORD)(a) << 8 ))
#define	REVERSEu16( a )		(UWORD) (((UWORD)(a) >> 8 ) | ((UWORD)(a) << 8 ))

#define	REVERSE32( a )		(LONG) (((ULONG)(a) << 24 ) | (((ULONG)(a) & 0xff00L ) << 8 ) | \
													(((ULONG)(a) >> 8 ) & 0xff00L ) | ((ULONG)(a) >> 24 ))

#define	REVERSEu32( a )		(ULONG) (((ULONG)(a) << 24 ) | (((ULONG)(a) & 0xff00UL ) << 8 ) | \
													(((ULONG)(a) >> 8 ) & 0xff00UL ) | ((ULONG)(a) >> 24 ))

//----------------------------------------------------------------------------------------
// Macros for converting GE_LITTLE_ENDIAN/BIG_ENDIAN to destination byte order
//----------------------------------------------------------------------------------------
#if GE_LITTLE_ENDIAN

#define HOST_2_LENDIAN_16( a ) ( a )
#define HOST_2_LENDIAN_32( a ) ( a )
#define HOST_2_BENDIAN_16( a ) ( REVERSEu16( a ))
#define HOST_2_BENDIAN_32( a ) ( REVERSEu32( a ))

#define LENDIAN_2_HOST_16( a ) ( a )
#define LENDIAN_2_HOST_32( a ) ( a )
#define BENDIAN_2_HOST_16( a ) ( REVERSEu16( a ))
#define BENDIAN_2_HOST_32( a ) ( REVERSEu32( a ))

#else																												// friendly cpu

#define HOST_2_LENDIAN_16( a ) ( REVERSEu16( a ))
#define HOST_2_LENDIAN_32( a ) ( REVERSEu32( a ))
#define HOST_2_BENDIAN_16( a ) ( a )
#define HOST_2_BENDIAN_32( a ) ( a )

#define LENDIAN_2_HOST_16( a ) ( REVERSEu16( a ))
#define LENDIAN_2_HOST_32( a ) ( REVERSEu32( a ))
#define BENDIAN_2_HOST_16( a ) ( a )
#define BENDIAN_2_HOST_32( a ) ( a )

#endif																											// GE_LITTLE_ENDIAN

//----------------------------------------------------------------------------------------
// Character constants
//----------------------------------------------------------------------------------------
#if GE_LITTLE_ENDIAN																						// reverse byte order

#define	CHAR_CONST32( a )	(ULONG) (((ULONG)(a) << 24 ) | (((ULONG)(a) & 0xff00UL ) << 8 ) | \
												(((ULONG)(a) >> 8 ) & 0xff00UL ) | ((ULONG)(a) >> 24 ))

#else																												// usual byte order

#define	CHAR_CONST32( a )	(ULONG) ( a )

#endif

#endif
