/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef	__X4D_EFFECT_MATRIX_UTILS__
#define	__X4D_EFFECT_MATRIX_UTILS__

#include "x4d_filter.h"

struct WEIGHT_FMATRIX
{
	LONG	no_matrix_columns;
	LONG	no_matrix_rows;
	LONG	x_origin;
	LONG	y_origin;
	SReal	matrix_values[VARIABLE_ARRAY_SIZE];
};

#define	MAXTRIX_MAX_COLUMNS	15															// maximum number of maxtrix columns
#define	MAXTRIX_MAX_ROWS		15															// maximum number of maxtrix rows

struct WEIGHT_FMATRIX_3x3
{
	LONG	no_matrix_columns;
	LONG	no_matrix_rows;
	LONG	x_origin;
	LONG	y_origin;
	SReal	matrix_values[3][3];
};

struct WEIGHT_FMATRIX_5x5
{
	LONG	no_matrix_columns;
	LONG	no_matrix_rows;
	LONG	x_origin;
	LONG	y_origin;
	SReal	matrix_values[5][5];
};

struct WEIGHT_FMATRIX_7x7
{
	LONG	no_matrix_columns;
	LONG	no_matrix_rows;
	LONG	x_origin;
	LONG	y_origin;
	SReal	matrix_values[7][7];
};

struct WEIGHT_FMATRIX_MAX
{
	LONG	no_matrix_columns;
	LONG	no_matrix_rows;
	LONG	x_origin;
	LONG	y_origin;
	SReal	matrix_values[MAXTRIX_MAX_COLUMNS*MAXTRIX_MAX_ROWS];
};

typedef void	*MATRIX_REF;

extern MATRIX_REF  new_effect_matrix( const WEIGHT_FMATRIX *input_matrix, LONG color_space, ULONG px_format, SReal opacity, Bool scale_matrix, LReal angle );
extern LONG	delete_effect_matrix( MATRIX_REF emr );
extern void  update_effect_matrix( MATRIX_REF emr, LONG color_space, ULONG px_format );
extern LONG	apply_matrix_effect( MATRIX_REF emr, void **src_rows, void *dst, LONG width );
extern LONG	get_effect_matrix_info( MATRIX_REF _emr, LONG *no_columns, LONG *no_rows, LONG *x_origin, LONG *y_origin );

#endif