#include "c4d_operatorplugin.h"
#include "lib_description.h"

////////////////////////////////

const String	GvOperatorData::GetDetailedText(GvNode *bn) { return String(); }
const String	GvOperatorData::GetText(GvNode *bn) { return String(); }
const String	GvOperatorData::GetTitle(GvNode *bn) { return String(); }
BaseBitmap*		GvOperatorData::GetPortIcon(GvNode *bn, LONG id, GvLayoutType layout_type) { return NULL; }
const Vector	GvOperatorData::GetBodyColor(GvNode *bn) { return C4DOS.Gv->globals->GetDefaultBodyColor(bn); }
void					GvOperatorData::GetBodySize(GvNode *bn, LONG *width, LONG *height) { C4DOS.Gv->globals->GetDefaultBodySize(width,height); }
void					GvOperatorData::EditorDraw(GvNode *bn, GvNodeGUI *gui, GeUserArea *da, LONG x1, LONG y1, LONG x2, LONG y2) { C4DOS.Gv->globals->OperatorDefaultDraw(bn,gui,da,x1,y1,x2,y2); }
Bool					GvOperatorData::GetOperatorDescription(GvNode *bn, GvOperatorDescription *od) { return FALSE; }
Bool					GvOperatorData::QueryCalculation(GvNode *bn, GvQuery *query) { return TRUE; }
Bool					GvOperatorData::InitCalculation(GvNode *bn, GvCalc *calc, GvRun *run) { return TRUE; }
void					GvOperatorData::FreeCalculation(GvNode *bn, GvCalc *calc) { }
Bool					GvOperatorData::Calculate(GvNode *bn, GvPort *port, GvRun *run, GvCalc *calc) { return FALSE; }
Bool					GvOperatorData::AddToCalculationTable(GvNode *bn, GvRun *run) { return FALSE; }
Bool					GvOperatorData::SetRecalculate(GvNode *bn, GvPort *port, GvRun *r, Bool force_set) { return C4DOS.Gv->globals->DefaultSetRecalculate(bn,port,r,force_set); }
Bool					GvOperatorData::SetData(GvNode *bn, GvDataType type, void *data, GvOpSetDataMode mode) { return FALSE; }
Bool					GvOperatorData::IsSetDataAllowed(GvNode *bn, GvDataType type, void *data, GvOpSetDataMode mode) { return FALSE; }
LONG					GvOperatorData::FillPortMenu(GvNode *bn, BaseContainer& menu, LONG port_id, LONG first_menu_id) { return FALSE; }
Bool					GvOperatorData::PortMenuCommand(GvNode *bn, LONG menu_id, LONG port_id, LONG mx, LONG my) { return FALSE; }
LONG					GvOperatorData::FillOperatorMenu(GvNode *bn, BaseContainer& menu, LONG first_menu_id) { return FALSE; }
Bool					GvOperatorData::OperatorMenuCommand(GvNode *bn, LONG menu_id, LONG mx, LONG my) { return FALSE; }
LONG					GvOperatorData::FillPortsMenu(GvNode *bn, BaseContainer &names, BaseContainer &ids, GvValueID value_type, GvPortIO port, LONG first_menu_id) { return C4DOS.Gv->globals->FillPortsMenu(bn,names,ids,value_type,port,first_menu_id); }
Bool					GvOperatorData::BodyMessage(GvNode *bn, GvNodeGUI *gui, LONG x, LONG y, LONG chn, LONG qua, const BaseContainer &msg) { return FALSE; }
Bool					GvOperatorData::EditSettings(GvNode *bn, GvNodeGUI *gui) { return TRUE; }
const String  GvOperatorData::GetErrorString(GvNode *bn, LONG error) { return LongToString(error); }
Bool					GvOperatorData::SceneDraw(GvNode *bn, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt, LONG flags, void *data, ULONG counter) { return FALSE; }
LONG					GvOperatorData::GetMainID(GvNode *bn, GvPortIO io, const DescID &desc_id) { return GV_PORT_INVALID_ID; };
const DescID	GvOperatorData::GetDescID(GvNode *bn, GvPortIO io, LONG main_id) { return DescID(); }
Bool					GvOperatorData::CreatePortDescriptionCache(GvNode *bn, Bool lock_only) { return TRUE; }
void					GvOperatorData::FreePortDescriptionCache(GvNode *bn) { }


Bool GvOperatorData::Init(GeListNode *bn)
{
	return GetNode(bn) != NULL;
}

Bool GvOperatorData::iCreateOperator(GvNode *bn)
{
	return C4DOS.Gv->node->CreateOperator(bn,1);
}

void GvOperatorData::iGetPortList(GvNode *bn, GvPortIO port, GvPortList &portlist)
{
	C4DOS.Gv->node->GetPortList(bn,port,portlist,1); 
}

Bool GvOperatorData::iGetPortDescription(GvNode *bn, GvPortIO port, LONG id, GvPortDescription *pd) 
{
	return C4DOS.Gv->node->GetPortDescription(bn,port,id,pd,1); 
}

#define BIT_SUPERCALL (1<<31)

Bool GvOperatorData::GetDDescription(GeListNode *node,Description *description,LONG &t_flags)
{
	LONG flags = t_flags|BIT_SUPERCALL;

	NodeData *data = node->GetNodeData(0);
	NODEPLUGIN* tab = (C4DOS.Bl->RetrieveTableX(data,0));
	Bool res = (data->*tab->GetDDescription)(node,description,flags);

	t_flags = flags&~BIT_SUPERCALL;
	return res;
}

Bool GvOperatorData::GetDEnabling(GeListNode *node, const DescID &id,const GeData &t_data,LONG t_flags,const BaseContainer *itemdesc)
{
	LONG flags = t_flags|BIT_SUPERCALL;

	NodeData *data = node->GetNodeData(0);
	NODEPLUGIN* tab = (C4DOS.Bl->RetrieveTableX(data,0));
	Bool res = (data->*tab->GetDEnabling)(node,id,t_data,flags,itemdesc);

	t_flags = flags&~BIT_SUPERCALL;
	return res;
}

Bool GvOperatorData::GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &t_flags)
{
	LONG flags = t_flags|BIT_SUPERCALL;

	NodeData *data = node->GetNodeData(0);
	NODEPLUGIN* tab = (C4DOS.Bl->RetrieveTableX(data,0));
	Bool res = (data->*tab->GetDParameter)(node,id,t_data,flags);

	t_flags = flags&~BIT_SUPERCALL;
	return res;
}

Bool GvOperatorData::SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &t_flags)
{
	LONG flags = t_flags|BIT_SUPERCALL;

	NodeData *data = node->GetNodeData(0);
	NODEPLUGIN* tab = (C4DOS.Bl->RetrieveTableX(data,0));
	Bool res = (data->*tab->SetDParameter)(node,id,t_data,flags);

	t_flags = flags&~BIT_SUPERCALL;
	return res;
}

////////////////////////////////

Bool GvRegisterOperatorPlugin(GvOperatorID operator_id, const String &str, LONG info, DataAllocator *at, const String &description, LONG disklevel, GvOpClassID op_class, GvOpGroupID op_group, LONG op_owner, BaseBitmap *icon)
{
	if (!C4DOS.Gv->globals || !C4DOS.Gv->globals->RegisterOperatorPlugin) return FALSE;

	if (description.Content() && !RegisterDescription(operator_id,description)) return FALSE;

	OPERATORPLUGIN ap;
	ClearMem(&ap,sizeof(ap));
	FillNodePlugin(&ap,info,at,NULL,disklevel);

	ap.iCreateOperator						= &GvOperatorData::iCreateOperator;
	ap.GetDetailedText						= &GvOperatorData::GetDetailedText;
	ap.GetText										= &GvOperatorData::GetText;
	ap.GetTitle										= &GvOperatorData::GetTitle;
	ap.GetPortIcon								= &GvOperatorData::GetPortIcon;
	ap.GetBodySize								= &GvOperatorData::GetBodySize;
	ap.GetBodyColor								= &GvOperatorData::GetBodyColor;
	ap.EditorDraw									= &GvOperatorData::EditorDraw;
	ap.iGetPortList								= &GvOperatorData::iGetPortList;
	ap.iGetPortDescription				= &GvOperatorData::iGetPortDescription;
	ap.GetOperatorDescription			= &GvOperatorData::GetOperatorDescription;
	ap.QueryCalculation						= &GvOperatorData::QueryCalculation;
	ap.InitCalculation						= &GvOperatorData::InitCalculation;
	ap.FreeCalculation						= &GvOperatorData::FreeCalculation;
	ap.Calculate									= &GvOperatorData::Calculate;
	ap.AddToCalculationTable			= &GvOperatorData::AddToCalculationTable;
	ap.SetRecalculate							= &GvOperatorData::SetRecalculate;
	ap.SetData										= &GvOperatorData::SetData;
	ap.IsSetDataAllowed						= &GvOperatorData::IsSetDataAllowed;
	ap.FillPortMenu								= &GvOperatorData::FillPortMenu;
	ap.PortMenuCommand						= &GvOperatorData::PortMenuCommand;
	ap.FillOperatorMenu						= &GvOperatorData::FillOperatorMenu;
	ap.OperatorMenuCommand				= &GvOperatorData::OperatorMenuCommand;
	ap.FillPortsMenu							= &GvOperatorData::FillPortsMenu;
	ap.BodyMessage								= &GvOperatorData::BodyMessage;
	ap.EditSettings								= &GvOperatorData::EditSettings;
	ap.GetErrorString							= &GvOperatorData::GetErrorString;
	ap.SceneDraw									= &GvOperatorData::SceneDraw;
	ap.GetMainID									= &GvOperatorData::GetMainID;
	ap.GetDescID									= &GvOperatorData::GetDescID;
	ap.CreatePortDescriptionCache = &GvOperatorData::CreatePortDescriptionCache;
	ap.FreePortDescriptionCache		= &GvOperatorData::FreePortDescriptionCache;

	return C4DOS.Gv->globals->RegisterOperatorPlugin(operator_id,str,info,at,disklevel,op_class,op_group,op_owner,&ap,icon);
}

////////////////////////////////
