/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2006 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

//----------------------------------------------------
//Falloff controller system
#ifndef _C4D_FALLOFFDATA_H_
#define _C4D_FALLOFFDATA_H_

#include "c4d.h"

#define FALLOFFCAGE			Vector(1.0f, 1.0f, 0.0f)
#define FALLOFFFALLOFF	Vector(0.7f, 0.1f, 0.0f)

#define	ID_C4DFALLDATALIB					1019551
#define ID_C4DFALLOFFLIB					1019541

#define C4DPL_FALLOFF							1019542

struct FalloffDataData
{
public:
	FalloffDataData(void)
	{
		mat = Matrix();
		imat = !mat;
		falloff = scale = strength = 1.0;
		size = 1.0;
		invert = clamped = usespline = FALSE;
		visible = TRUE;
		userdata = NULL;
	}
	~FalloffDataData(void) {}

	Matrix	mat, imat;
	Real		falloff, scale, strength;
	Vector	size;
	Bool		invert, clamped, visible, usespline;
	void		*userdata;
};

class FalloffData : public BaseData
{
public:
	virtual Bool					Init(FalloffDataData &falldata,BaseContainer *bc);
	virtual Bool					InitFalloff(BaseContainer *bc, FalloffDataData &falldata);
	virtual void					Sample(const Vector &p, const FalloffDataData &data, Real *res);
	virtual void					FreeFalloff(FalloffDataData &falldata);
	virtual Bool					CheckDirty(BaseContainer *bc);
	virtual Bool					GetDVisible(DescID &id,BaseContainer *bc,BaseContainer *desc_bc);
	virtual LONG					GetHandleCount(BaseContainer *bc, const FalloffDataData &data);
	virtual Vector				GetHandle(BaseContainer *bc, LONG i, const FalloffDataData &data);
	virtual void					SetHandle(BaseContainer *bc, LONG i, Vector p, const FalloffDataData &data);
	virtual Bool					Draw(const FalloffDataData &data, LONG drawpass, BaseDraw *bd, BaseDrawHelp *bh);
	virtual Bool					Message(LONG type,BaseContainer *bc, void *m_data);
};

class C4D_Falloff
{
private:
	C4D_Falloff(void) {}
	~C4D_Falloff(void) {}
public:
	BaseContainer*					GetContainerInstance(void);

	void										SetDirty(void);
	LONG										GetDirty(BaseContainer *bc=NULL);
	void										SetMg(Matrix mg);
	Matrix									GetMg(void);
	void										SetData(FalloffDataData falldata);
	FalloffDataData					GetData(void);
	Bool										SetMode(LONG type,BaseContainer *bc=NULL);
	LONG										GetMode(void);
	void										SetTime(BaseTime time,BaseContainer *bc=NULL);

	Bool										InitFalloff(BaseContainer *bc=NULL,BaseDocument *doc=NULL, BaseObject *op=NULL);
	void										Sample(const Vector &p,Real *result,Bool usespline=TRUE,Real weight=0.0);

	void										MultiSample(const Vector *p,Real *result,LONG count,Bool usespline=TRUE,Real weight=0.0);
	
	Bool										AddFalloffToDescription(Description *description,BaseContainer *bc=NULL);

	Bool										Message(LONG id,BaseContainer *bc=NULL,void *m_data=NULL);
	LONG										GetHandleCount(BaseContainer *bc=NULL);
	Vector									GetHandle(LONG i, BaseContainer *bc=NULL);
	void										SetHandle(LONG i, Vector p, BaseContainer *bc=NULL);
	Bool										Draw(BaseDraw *bd, BaseDrawHelp *bh, LONG flags,BaseContainer *bc=NULL);
	Bool										CopyTo(C4D_Falloff* dest);

	//Autoallocation code
	static C4D_Falloff*			Alloc(void);
	static void							Free(C4D_Falloff *&node);
};

struct FALLOFFPLUGIN;

typedef FalloffData *FalloffDataAllocator(void);

void FillFalloffPlugin(FALLOFFPLUGIN *fp, LONG info, FalloffDataAllocator *g);
Bool RegisterFalloffPlugin(LONG id, const String &str, LONG info, FalloffDataAllocator *g, const String &description);
void *AllocFalloff(LONG type);

#endif