/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _LIB_SN_H_
#define _LIB_SN_H_

#include "c4d_library.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"

#define SN_OKAY					0		// >=0 means okay
#define SN_WRONGNUMBER	-1
#define SN_EXPIRED			-2
#define SN_EXPIRE_14		-100
#define SN_NET					-4

#define SNFLAG_OWN			1	// use own sn scheme
#define SNFLAG_PRIV			2 // don't use
#define SNFLAG_CLIPID		4 // hook provides clipid

// public stuff
struct SNHook
{
	void					*thisptr;
	LONG					flags;

	LONG					(*SN_Check)(SNHook *snhook,const String &c4dsn,const String &sn,LONG regdate,LONG curdate);
	const String&	(*SN_GetTitle)(SNHook *snhook);
	const CHAR*		(*SN_GetClipID)(SNHook *snhook);
};

// a class for convenience, DO NOT STORE STATIC !!!
class SNHookClass
{
		SNHook hook;

	public:

		SNHookClass();

		Bool Register(LONG id,LONG flags);

		virtual LONG SNCheck(const String &c4dsn,const String &sn,LONG regdate,LONG curdate);
		virtual const String& GetTitle();
		virtual const CHAR* GetClipID();
};

// public class

Bool SN_Register(LONG id,SNHook *snhook);
SNHook *SN_FindHook(LONG id);

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#define LIBRARY_SN	200000008

struct SNLib : public C4DLibrary
{
	Bool    (*SN_Register   )(LONG id,SNHook *snhook);
	SNHook*	(*SN_FindHook		)(LONG id);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
