/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2009 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

//---------------------------------------------------
#ifndef _C4D_PICTUREVIEWER_H_
#define _C4D_PICTUREVIEWER_H_

#ifdef __API_INTERN__
#include "basetime.h"
#include "ge_string.h"
#include "c4d_library.h"
#include "c4d_gui.h"
#else
#include "c4d.h"
#endif

class GeListNode;
class Filename;
class BaseBitmap;
class BaseDocument;
class String;
class BaseSound;

#define C4D_PICTUREVIEWER_LIBRARY_ID		430000795

// EndFrame actions
#define PV_FRAME_END_DESTROY	1
#define PV_FRAME_END_TAKE			2
#define PV_FRAME_END_CANCEL		3

#define PICTUREVIEWER_INIT_ACTIVE		(-1)
#define PICTUREVIEWER_INIT_RENDER		(-2)

#define MSG_PICTUREVIEWER_LAYERCHANGE			300001063
#define MSG_PICTUREVIEWER_OVERWRITEIMAGE	300001064

class PictureViewer
{
	private:
		PictureViewer();
		~PictureViewer();
	public:
		Bool Open(void);

		Bool ShowFile(const Filename &File);
		Bool ShowImage(BaseBitmap *Bmp, const String &Name);
		GeListNode* OpenRendering(const String &Name,Real Fps,LONG lStart,LONG lEnd,BaseContainer* bcrender);
		Bool AddRenderingEx(GeListNode *pNode, BaseBitmap *Bmp,const String &Name,const BaseTime &Time,LONG Frame,
			const Filename &savename,Bool fully_saved,Filename **filename_list,LONG filename_count);
		Bool CloseRenderingEx(GeListNode *&pNode,LONG action);
		Bool AddSound(GeListNode *pNode, const BaseTime &from, const BaseTime &to, BaseSound *snd);
		Bool Message(LONG id, void *t_data);

		Bool AddRendering(GeListNode *pNode, BaseBitmap *Bmp,const String &Name,const BaseTime &Time,LONG Frame,
			const Filename &savename,Bool fully_saved,Filename **filename_list,LONG filename_count, Bool bAlwaysCopy);
		Bool CloseRendering(GeListNode *&pNode,LONG action, Bool bAlwaysCopy);
};

PictureViewer* CreatePictureViewer(LONG type);

//---------------------------------------------------
//	---INTERNAL STUFF

class iPictureViewer;

struct PictureViewLibrary : public C4DLibrary
{
	iPictureViewer*	(*CreatePictureViewer)(LONG type);

	Bool					(iPictureViewer::*Open)								();

	Bool					(iPictureViewer::*ShowFile)						(const Filename &File);
	Bool					(iPictureViewer::*ShowImage)					(BaseBitmap *Bmp,const String &Name);
	GeListNode*		(iPictureViewer::*OpenRendering)			(const String &Name,Real Fps,LONG lStart,LONG lEnd,BaseContainer* bcrender );
	Bool					(iPictureViewer::*AddRenderingEx)				(GeListNode *pNode, BaseBitmap *Bmp,const String &Name,const BaseTime &Time,LONG Frame,const Filename &savename,Bool fully_saved,Filename **filename_list, LONG filename_count);
	Bool					(iPictureViewer::*CloseRenderingEx)			(GeListNode *&pNode, LONG action);
	Bool					(iPictureViewer::*AddSound)						(GeListNode *pNode, const BaseTime &from, const BaseTime &to, BaseSound *snd);
	Bool					(iPictureViewer::*Message)						(LONG id, void *t_data);

	Bool					(iPictureViewer::*AddRendering)				(GeListNode *pNode, BaseBitmap *Bmp,const String &Name,const BaseTime &Time,LONG Frame,const Filename &savename,Bool fully_saved,Filename **filename_list, LONG filename_count, Bool bAlwaysCopy);
	Bool					(iPictureViewer::*CloseRendering)			(GeListNode *&pNode, LONG action, Bool bAlwaysCopy);
};

#endif

