/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _LIB_NOISE_H_
#define _LIB_NOISE_H_

// for the NOISE GUI
#define NOISE_OFFSET					2000

// Note : SLA must be installed to use this class
#define NOISE_LIB         1011190

#include "c4d_library.h"

#ifdef __API_INTERN__
#include "baselist.h"
#endif

enum NoiseType
{
	NOISE_UNKNOWN               =  0,
	// 2D & 3D
	NOISE_BOX_NOISE             =  1,
	NOISE_BLIST_TURB            =  2,
	NOISE_BUYA                  =  3,
	NOISE_CELL_NOISE            =  4,
	NOISE_CRANAL                =  5,
	NOISE_DENTS                 =  6,
	NOISE_DISPL_TURB            =  7,
	NOISE_FBM                   =  8,
	NOISE_HAMA                  =  9,
	NOISE_LUKA                  = 10,
	NOISE_MOD_NOISE             = 11,
	NOISE_NAKI                  = 12,
	NOISE_NOISE                 = 13,
	NOISE_NUTOUS                = 14,
	NOISE_OBER                  = 15,
	NOISE_PEZO                  = 16,
	NOISE_POXO                  = 17,
	NOISE_RANDOM                = 18,
	NOISE_SEMA                  = 19,
	NOISE_STUPL                 = 20,
	NOISE_TURBULENCE            = 21,
	NOISE_VL_NOISE              = 22,
	NOISE_WAVY_TURB             = 23,
	NOISE_CELL_VORONOI          = 24,
	NOISE_DISPL_VORONOI         = 25,
	NOISE_SPARSE_CONV           = 26,
	NOISE_VORONOI_1             = 27,
	NOISE_VORONOI_2             = 28,
	NOISE_VORONOI_3             = 29,
	NOISE_ZADA                  = 30,
	NOISE_FIRE                  = 31,
	NOISE_ELECTRIC              = 32,
	NOISE_GASEOUS               = 33,

	NOISE_NONE                  = 99
};

class BaseContainer;
struct NoiseGradient;

class C4DNoise
{
private:
	C4DNoise();
	~C4DNoise();
public:
	static C4DNoise* Alloc(LONG seed);
	static C4DNoise* Alloc2(LONG seed);
	static void Free(C4DNoise *&p);

	static BaseContainer CreateMenuContainer(Bool bIncludeNone = FALSE);
	static Bool HasOctaves(NoiseType t);
	static Bool HasAbsolute(NoiseType t);
	static Bool HasCycles(NoiseType t);
	static void EvaluateSampleOffset(NoiseType type, Real rOctaves, Real rDelta, Real &rSampleOffset);
	static void GetNoisePreview(NoiseType t, IconData &dat, String *str = NULL);

	Real Noise(NoiseType t, Bool two_d, const Vector &p, Real time = 0.0, Real octaves = 4.0, Bool absolute = FALSE, Real sampleRad = 0.25, Real detailAtt = 0.25, LONG t_repeat=0);
	Bool InitFbm(LONG lMaxOctaves, Real rLacunarity, Real h);

	const Real* GetFBMTable();
	const Real* GetValueTable();
	const Real* GetImpulseTable();
	static const UCHAR* GetPermutationTable();
	const LONG* GetTPPermutationTable();
	const NoiseGradient* GetNoiseGradient();
	const LONG* GetPermutationTableA();

	Real SNoise(Vector p);
	Real SNoise(Vector p, Real t, LONG lRepeat);
	Real Turbulence(Vector p, Real t, Real rOctaves, Bool bAbsolute, LONG lRepeat);
	Real Fbm(Vector p, Real t, Real rOctaves, LONG lRepeat);
	Real RidgedMultifractal(Vector p, Real t, Real rOctaves, Real rOffset, Real rGain, LONG lRepeat);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

class iNoise;

struct NoiseLib : public C4DLibrary
{
	iNoise*       (*NoiseLib_Alloc)(LONG seed);
	void          (*NoiseLib_Free)(iNoise *&p);

	Real          (iNoise::*NoiseLib_Noise2D)(const NoiseType t, const Vector &p, const Real time, const Real octaves, const Bool absolute, const Real sampleRad, const Real detailAtt);
	Real          (iNoise::*NoiseLib_Noise3D)(const NoiseType t, const Vector &p, const Real time, const Real octaves, const Bool absolute, const Real sampleRad, const Real detailAtt);
	Bool          (iNoise::*NoiseLib_InitFbm)(LONG lMaxOctaves, Real rLacunarity, Real h);
	BaseContainer (*NoiseLib_CreateMenuContainer)(Bool bIncludeNone);
	Bool          (*NoiseLib_HasOctaves)(NoiseType t);
	void          (*NoiseLib_EvaluateSampleOffset)(NoiseType type, Real rOctaves, Real rDelta, Real &rSampleOffset);
	void          (*NoiseLib_GetNoisePreview)(NoiseType t, IconData &dat, String *str);
	Real          (iNoise::*NoiseLib_Noise)(NoiseType t, Bool two_d, const Vector &p, Real time, Real octaves, Bool absolute, Real sampleRad, Real detailAtt, LONG t_repeat);
	const Real*   (iNoise::*NoiseLib_GetFBMTable)();
	const Real*   (iNoise::*NoiseLib_GetValueTable)();
	const Real*   (iNoise::*NoiseLib_GetImpulseTable)();
	const UCHAR*  (*NoiseLib_GetPermutationTable)();
	Bool          (*NoiseLib_HasAbsolute)(NoiseType t);
	Bool          (*NoiseLib_HasCycles)(NoiseType t);
	Real					(iNoise::*SNoiseR)(Vector p, Real t, LONG lRepeat);
	Real					(iNoise::*SNoise)(Vector p);
	Real					(iNoise::*Turbulence)(Vector p, Real t, Real rOctaves, Bool bAbsolute, LONG lRepeat);
	Real					(iNoise::*Fbm)(Vector p, Real t, Real rOctaves, LONG lRepeat);
	Real					(iNoise::*RidgedMultifractal)(Vector p, Real t, Real rOctaves, Real rOffset, Real rGain, LONG lRepeat);

	iNoise*       (*NoiseLib_Alloc2)(LONG seed);
	const NoiseGradient* (iNoise::*NoiseLib_GetNoiseGradient)();
	const LONG*		(iNoise::*NoiseLib_GetPermutationTableA)();
};


// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF



#endif // _LIB_NOISE_H_