#include "c4d_memory.h"
#include "c4d_general.h"
#include "c4d_tools.h"
#include "c4d_basebitmap.h"
#include "c4d_scenehookplugin.h"
#include "c4d_file.h"

Bool SceneHookData::MouseInput(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, EditorWindow *win, const BaseContainer &msg)
{
	return FALSE;
}

Bool SceneHookData::KeyboardInput(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, EditorWindow *win, const BaseContainer &msg)
{
	return FALSE;
}

Bool SceneHookData::GetCursorInfo(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, Real x, Real y, BaseContainer &bc)
{
	return FALSE;
}

Bool SceneHookData::Draw(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt,LONG flags)
{
	return TRUE;
}

Bool SceneHookData::AddToExecution(PluginSceneHook *node, PriorityList *list)
{
	return FALSE;
}

LONG SceneHookData::InitSceneHook(PluginSceneHook *node, BaseDocument *doc, BaseThread *bt)
{
	return EXECUTION_RESULT_OK;
}

void SceneHookData::FreeSceneHook(PluginSceneHook *node, BaseDocument *doc)
{
}

LONG SceneHookData::Execute(PluginSceneHook *node, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags)
{
	return EXECUTION_RESULT_OK;
}

static void FillSceneHookPlugin(SCENEHOOKPLUGIN *np, DataAllocator *npalloc, LONG info, LONG disklevel, LONG priority, void *emulation)
{
	FillNodePlugin(np,info,npalloc,NULL,disklevel,emulation);

	np->draw_priority				= priority;
	np->MouseInput					= &SceneHookData::MouseInput;
	np->GetCursorInfo				= &SceneHookData::GetCursorInfo;
	np->Draw								= &SceneHookData::Draw;
	np->AddToExecution			= &SceneHookData::AddToExecution;
	np->InitSceneHook				= &SceneHookData::InitSceneHook;
	np->FreeSceneHook				= &SceneHookData::FreeSceneHook;
	np->Execute							= &SceneHookData::Execute;
	np->KeyboardInput				= &SceneHookData::KeyboardInput;
}

Bool RegisterSceneHookPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, LONG priority, LONG disklevel, void *emulation)
{
	SCENEHOOKPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillSceneHookPlugin(&np,npalloc,info,disklevel,priority,emulation);
	return GeRegisterPlugin(C4DPL_SCENEHOOK,id,str,&np,sizeof(np));
}
