CONTAINER XSLACheen
{
	NAME XSLACheen;

	INCLUDE Mpreview;
	INCLUDE Mbase;

	GROUP Obaselist
	{
		BOOL SLA_CHEEN_GRADIENTS { PARENTMSG ID_CHEEN_GRADIENTS; }
		BOOL SLA_CHEEN_DIFFUSE { PARENTMSG ID_CHEEN_DIFFUSE; }
		BOOL SLA_CHEEN_SPECULAR1 { PARENTMSG ID_CHEEN_SPECULAR1; }
		BOOL SLA_CHEEN_SPECULAR2 { PARENTMSG ID_CHEEN_SPECULAR2; }
		BOOL SLA_CHEEN_SPECULAR3 { PARENTMSG ID_CHEEN_SPECULAR3; }
		BOOL SLA_CHEEN_TRANSPARENCY { PARENTMSG ID_CHEEN_TRANSPARENCY; }
		BOOL SLA_CHEEN_REFLECTION { PARENTMSG ID_CHEEN_REFLECTION; }
		BOOL SLA_CHEEN_ENVIRONMENT { PARENTMSG ID_CHEEN_ENVIRONMENT; }
		BOOL SLA_CHEEN_AMBIENT { PARENTMSG ID_CHEEN_AMBIENT; }
		BOOL SLA_CHEEN_ROUGHNESS { PARENTMSG ID_CHEEN_ROUGHNESS; }
		BOOL SLA_CHEEN_ANISOTROPY { PARENTMSG ID_CHEEN_ANISOTROPY; }
		BOOL SLA_CHEEN_ESOTERICA { PAGE; HIDDEN; PARENTMSG ID_CHEEN_ESOTERICA; }
	}
	GROUP ID_CHEEN_GRADIENTS
	{
		GRADIENT SLA_CHEEN_GRADIENTS_COLOR { }
		GRADIENT SLA_CHEEN_GRADIENTS_OPACITY { }
	}
	GROUP ID_CHEEN_DIFFUSE
	{
		COLOR SLA_CHEEN_DIFFUSE_SURF_COLOR { }
		LONG SLA_CHEEN_DIFFUSE_ALGORITHM
		{
			CYCLE
			{
				SLA_CHEEN_DIFFUSE_ALGORITHM_INTERNAL;
				SLA_CHEEN_DIFFUSE_ALGORITHM_OREN_NAYAR;
			}
		}
		REAL SLA_CHEEN_DIFFUSE_ROUGHNESS { UNIT PERCENT; MIN 0; MAX 200; }
		REAL SLA_CHEEN_DIFFUSE_SURF_ILLUMINATION { UNIT PERCENT; MIN -1000; MAX 1000; }
		REAL SLA_CHEEN_DIFFUSE_CONTRAST { UNIT PERCENT; MIN -1000; MAX 1000; }
	}
	GROUP ID_CHEEN_SPECULAR1
	{
		COLOR SLA_CHEEN_SPEC1_COLOR { };
		REAL SLA_CHEEN_SPEC1_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_SPEC1_SIZE { UNIT PERCENT; MIN 0; MAX 200; }
		REAL SLA_CHEEN_SPEC1_CONTRAST { UNIT PERCENT; MIN 0; MAX 100; }
		REAL SLA_CHEEN_SPEC1_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_SPEC1_FALLOFF { UNIT PERCENT; MIN 0; }
	}
	GROUP ID_CHEEN_SPECULAR2
	{
		COLOR SLA_CHEEN_SPEC2_COLOR { };
		REAL SLA_CHEEN_SPEC2_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_SPEC2_SIZE { UNIT PERCENT; MIN 0; MAX 200; }
		REAL SLA_CHEEN_SPEC2_CONTRAST { UNIT PERCENT; MIN 0; MAX 100; }
		REAL SLA_CHEEN_SPEC2_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_SPEC2_FALLOFF { UNIT PERCENT; MIN 0; }
	}
	GROUP ID_CHEEN_SPECULAR3
	{
		COLOR SLA_CHEEN_SPEC3_COLOR { };
		REAL SLA_CHEEN_SPEC3_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_SPEC3_SIZE { UNIT PERCENT; MIN 0; MAX 200; }
		REAL SLA_CHEEN_SPEC3_CONTRAST { UNIT PERCENT; MIN 0; MAX 100; }
		REAL SLA_CHEEN_SPEC3_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_SPEC3_FALLOFF { UNIT PERCENT; MIN 0; }
	}
	GROUP ID_CHEEN_TRANSPARENCY
	{
		REAL SLA_CHEEN_TRANS_REFRACTION_INDEX { STEP .01; MIN 0.25; MAX 4.0; }
		BOOL SLA_CHEEN_TRANS_INTERNAL_REFLECTION { }
		BOOL SLA_CHEEN_TRANS_SOLID_OBJECT { }
	}

	GROUP ID_CHEEN_REFLECTION
	{
		REAL SLA_CHEEN_REFLECTION_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_REFLECTION_EDGE_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_REFLECTION_FALLOFF { UNIT PERCENT; MIN 0; }
		SEPARATOR { LINE; }
		COLOR SLA_CHEEN_REFLECTION_REFLECTION_COLOR { }
		COLOR SLA_CHEEN_REFLECTION_EDGE_COLOR { }
	}
	GROUP ID_CHEEN_ENVIRONMENT
	{
		SHADERLINK SLA_CHEEN_ENVIRONMENT_IMAGE { }
		REAL SLA_CHEEN_ENVIRONMENT_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_ENVIRONMENT_GLARE { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_ENVIRONMENT_FALLOFF { UNIT PERCENT; MIN 0; }
		SEPARATOR { LINE; }
		BOOL SLA_CHEEN_ENVIRONMENT_UTILIZE_ANISO_SCRATCHES { }
		REAL SLA_CHEEN_ENVIRONMENT_BLUR { UNIT PERCENT; MIN 0; MAX 100; }
		LONG SLA_CHEEN_ENVIRONMENT_SAMPLES { MIN 1; }
		REAL SLA_CHEEN_ENVIRONMENT_JITTER { UNIT PERCENT; MIN 0; MAX 1000; }
		SEPARATOR { LINE; }
		COLOR SLA_CHEEN_ENVIRONMENT_ENVIRONMENT_COLOR { }
		COLOR SLA_CHEEN_ENVIRONMENT_EDGE_COLOR { }
	}
	GROUP ID_CHEEN_AMBIENT
	{
		COLOR SLA_CHEEN_AMBIENT_COLOR { }
		REAL SLA_CHEEN_AMBIENT_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_AMBIENT_EDGE_INTENSITY { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_AMBIENT_FALLOFF { UNIT PERCENT; MIN 0; }
	}
	GROUP ID_CHEEN_ROUGHNESS
	{
		LONG SLA_CHEEN_ROUGHNESS_SEED { }
		LONG SLA_CHEEN_ROUGHNESS_NOISE
		{
			CYCLE
			{
			}
			CUSTOMGUI NOISE; NOISE_OFFSET 2100;
		}
		REAL SLA_CHEEN_ROUGHNESS_AMPLITUDE { UNIT PERCENT; MIN -1000; MAX 1000; }
		REAL SLA_CHEEN_ROUGHNESS_OCTAVES { MIN 0; MAX 20; STEP .5; }
		REAL SLA_CHEEN_ROUGHNESS_SCALE { UNIT PERCENT; MIN 0; }
		REAL SLA_CHEEN_ROUGHNESS_SPEED { UNIT PERCENT; MIN -100; MAX 100; }
		REAL SLA_CHEEN_ROUGHNESS_ATTENUATION { UNIT PERCENT; MIN 0; MAX 1000; }
		REAL SLA_CHEEN_ROUGHNESS_DELTA { UNIT PERCENT; MIN 0; }
		BOOL SLA_CHEEN_ROUGHNESS_HARD_BUMP { }
		BOOL SLA_CHEEN_ROUGHNESS_ABSOLUTE { }
		SEPARATOR { LINE; }
		REAL SLA_CHEEN_ROUGHNESS_LOW_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		REAL SLA_CHEEN_ROUGHNESS_HIGH_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		SEPARATOR { LINE; }
		COLOR SLA_CHEEN_ROUGHNESS_GRIT_COLOR { }
		REAL SLA_CHEEN_ROUGHNESS_GRIT_INTENSITY { UNIT PERCENT; MIN -200; MAX 200; MINSLIDER -200; MAXSLIDER 200; CUSTOMGUI REALSLIDER; }
		REAL SLA_CHEEN_ROUGHNESS_GRIT_LOW_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		REAL SLA_CHEEN_ROUGHNESS_GRIT_HIGH_CLIP { UNIT PERCENT; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
	}
	GROUP ID_CHEEN_ANISOTROPY
	{
		LONG SLA_CHEEN_ANISOTROPY_PROJECTION
		{
			CYCLE
			{
				SLA_CHEEN_ANISOTROPY_PROJECTION_PLANAR;
				SLA_CHEEN_ANISOTROPY_PROJECTION_AUTO_PLANAR;
				SLA_CHEEN_ANISOTROPY_PROJECTION_SHRINK_WRAP;
				SLA_CHEEN_ANISOTROPY_PROJECTION_RADIAL_AUTO_PLANAR;
				SLA_CHEEN_ANISOTROPY_PROJECTION_RAD_PATTERN_AUTO_PLANAR;
				SLA_CHEEN_ANISOTROPY_PROJECTION_RADIAL_PLANAR;
				SLA_CHEEN_ANISOTROPY_PROJECTION_RAD_PATTERN_PLANAR;
			}
		}
		REAL SLA_CHEEN_ANISOTROPY_PROJ_SCALE { UNIT PERCENT; MIN 0; MAX 1000; }
		SEPARATOR { LINE; }
		REAL SLA_CHEEN_ANISOTROPY_X_ROUGH { UNIT PERCENT; MIN 0; }
		REAL SLA_CHEEN_ANISOTROPY_Y_ROUGH { UNIT PERCENT; MIN 0; }
		SEPARATOR { LINE; }
		REAL SLA_CHEEN_ANISOTROPY_AMPL { UNIT PERCENT; MIN 0; MAX 100; }
		REAL SLA_CHEEN_ANISOTROPY_SCALE { UNIT PERCENT; MIN 0; }
		REAL SLA_CHEEN_ANISOTROPY_LENGTH { UNIT PERCENT; MIN 0; }
		REAL SLA_CHEEN_ANISOTROPY_ATT { UNIT PERCENT; MIN 0; }
		BOOL SLA_CHEEN_ANISOTROPY_CHANNEL1 { }
		BOOL SLA_CHEEN_ANISOTROPY_CHANNEL2 { }
		BOOL SLA_CHEEN_ANISOTROPY_CHANNEL3 { }
	}
	INCLUDE Millum;
	GROUP ID_CHEEN_ESOTERICA
	{
		REAL SLA_CHEEN_ESOTERICA_OPACITY { UNIT PERCENT; MIN 0; MAX 100; }
	}
	INCLUDE Massign;
}
