/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DVIDEOPOSTDATA_H
#define __C4DVIDEOPOSTDATA_H

#include "c4d_nodedata.h"
#include "ge_lvector.h"
#include "ge_lmatrix.h"

class  PluginVideoPost;
class  BaseContainer;
class  BaseDocument;
class  BaseObject;
class  BaseDraw;
class  BaseDrawHelp;
class  BaseDocument;
class  BaseBitmap;
class  String;
class  CDialog;
class  Render;
class  GlFrameBuffer;
struct Multipass;
struct PixelPost;
struct VideoPostStruct;
struct VolumeData;
struct RayFragment;
struct Ray;

struct BaseVideoPostStruct
{
	// C4D version number
	LONG					version;	

	// VP_xxx type
	LONG					vp;

	// TRUE if it is an opener, FALSE if it is a closer
	Bool					open;

	// current time
	BaseTime			time;			

	// render frame rate (this may be different to doc->GetFps())
	LONG					fps;      

	// pointer to LONG containing RAY_xxx states
	LONG					*error;

	// pointer to VolumeData; may be NULL
	VolumeData		*vd;	

	// document
	BaseDocument	*doc;

	// thread; use thread->TestBreak() to check for a user break
	BaseThread		*thread;

	// current subframe and number of subframes
	LONG					subframe,subframe_cnt;

	// current field and number of fields
	LONG					field,field_cnt;

	// rendering in editor
	Bool					editor_render;

	// render instance
	Render				*render;

	// renderflags passed to RenderDocument
	LONG					renderflags;
};

#define VP_FRAMESEQUENCE	1 // called when the renderer prepares to render a sequence of images
#define VP_FRAME					2 // called when the renderer prepares to render a frame
#define VP_SUBFRAME				3 // called when the renderer prepares to render a subframe
#define VP_RENDER					4 // called before the rendering process starts and before shaders are initialized
#define VP_INNER					5 // called immediately before rendering starts
#define VP_PREPASS				6 // called before prepass starts (and after it finishes)

// common buffers
#define VPBUFFER_RGBA									 1 
#define VPBUFFER_AMBIENT							 2 
#define VPBUFFER_DIFFUSE							 3 
#define VPBUFFER_SPECULAR							 4 
#define VPBUFFER_SHADOW								 5 
#define VPBUFFER_REFLECTION						 6
#define VPBUFFER_TRANSPARENCY					 7
#define VPBUFFER_RADIOSITY						 8
#define VPBUFFER_CAUSTICS							 9
#define VPBUFFER_ATMOSPHERE						10
#define VPBUFFER_ATMOSPHERE_MUL				11
#define VPBUFFER_ALLPOSTEFFECTS				12
																			
#define VPBUFFER_IMAGEBUILDING_PASS		32

// special buffers
#define VPBUFFER_DEPTH								100
#define VPBUFFER_MAT_COLOR						101
#define VPBUFFER_MAT_DIFFUSION				102
#define VPBUFFER_MAT_LUMINANCE				103
#define VPBUFFER_MAT_TRANSPARENCY			104
#define VPBUFFER_MAT_REFLECTION				105
#define VPBUFFER_MAT_ENVIRONMENT			106
#define VPBUFFER_MAT_SPECULAR					107
#define VPBUFFER_MAT_SPECULARCOLOR		108
#define VPBUFFER_ILLUMINATION					109
#define VPBUFFER_OBJECTBUFFER					110

#define VPBUFFER_POSTEFFECT						111
#define VPBUFFER_POSTEFFECT_MUL				112
#define VPBUFFER_AMBIENTOCCLUSION			113
#define VPBUFFER_MAT_NORMAL						114
#define VPBUFFER_MAT_UV								115
#define VPBUFFER_MOTIONVECTOR					116

#define VPBUFFER_BLEND								1000
#define VPBUFFER_LIGHTBLEND						1001 // private ID
#define VPBUFFER_ALPHA								1002 // for sdk request only 

struct PixelPost
{
#ifdef __API_INTERN__
	RayFragment **frag;
	RayFragment **frag_nx;
#else
	PixelFragment **frag;
	PixelFragment **frag_nx;
#endif
	VolumeData	*vd;
	Real				*col;
	Multipass		*mp;
	Bool				aa,valid_line;
	LONG				comp;
	LONG				cpu_num;
	LONG				xmin,xmax,line;
};

#define VPlenseffects								  1001049
#define VPobjectglow									1001007
#define VPcolorcorrection							1001008
#define VPcomic												1001009
#define VPscenemotionblur							1001010
#define VPobjectmotionblur						1001011
#define VPsoftfilter									1001012
#define VPsharpenfilter								1001013
#define VPmedianfilter								1001014
#define VPremote											1001015
#define VPopticsuite_depthoffield		  1001400
#define VPopticsuite_glow						  1001401
#define VPopticsuite_highlights			  1001402
#define VPambientocclusion						300001045 

#define VPPRIORITY_OBJECTGLOW						 500
#define VPPRIORITY_OBJECTMOTIONBLUR			 400
#define VPPRIORITY_DEPTHOFFIELD					 300
#define VPPRIORITY_LENSEFFECTS					 200
#define VPPRIORITY_FILTERSOFT						 100
#define VPPRIORITY_FILTERSHARPEN				 100
#define VPPRIORITY_FILTERMEDIAN					 100

#define VPPRIORITY_COMIC								 600
#define VPPRIORITY_COLORCORRECTION			 500
#define VPPRIORITY_SCENEMOTIONBLUR			 100
#define VPPRIORITY_EXTERNAL							 100

// info flags
#define PLUGINFLAG_VIDEOPOST_MULTIPLE							(1<<0)	// allow multiple effects of this type
#define PLUGINFLAG_VIDEOPOST_INHERENT							(1<<1)  // VP always is present
#define PLUGINFLAG_VIDEOPOST_GL										(1<<2)  // post effect supports OpenGL drawing
#define PLUGINFLAG_VIDEOPOST_ISRENDERER						(1<<3)
																					
// GetRenderInfo flags										
#define VIDEOPOST_STOREFRAGMENTS					(1<<0)  // VP needs fragment information for whole image at VP_INNER/VP_RENDER
#define VIDEOPOST_EXECUTELINE							(1<<4)	// line override
#define VIDEOPOST_EXECUTEPIXEL						(1<<5)	// pixel override
#define VIDEOPOST_REQUEST_MOTIONMATRIX		(1<<6)  
#define VIDEOPOST_REQUEST_MOTIONGEOMETRY	(1<<7)
#define VIDEOPOST_CALCVOLUMETRIC					(1<<8)
#define VIDEOPOST_CALCSHADOW							(1<<9)
#define VIDEOPOST_CUSTOMLENS							(1<<10)
#define VIDEOPOST_GLOBALILLUMINATION			(1<<11)	// post effect supports GI
#define VIDEOPOST_CAUSTICS								(1<<12) // post effect supports Caustics
																					
// GetGlInfo flags
#define VIDEOPOST_GLINFO_PREPASS											0x01000000

// GlDraw flags
#define VIDEOPOST_GLDRAW_PREPASS						(1 << 2)

#define VPGETFRAGMENTS_Z_P								(1<<0)	
#define VPGETFRAGMENTS_N									(1<<1)

// message ID
#define MSG_VIDEOPOST_TIMESHIFT						300000106
#define MSG_GLOBALILLUMINATIONINFORMATION	300001050

struct GlobalIlluminationInformation
{
	Bool reflective_caustics;
	Bool refractive_caustics;
	Real refractive_cutoff;
};
	
// set render properties
#define RENDERPROPERTY_CLUSTERFRAGMENTS		1
#define RENDERPROPERTY_BUCKETOVERLAP      2

class VideoPostData : public NodeData
{
	public:
		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max, ULONG flags);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////

		virtual Bool Draw(PluginVideoPost *node, BaseDraw *bd, BaseDrawHelp *bh);
		virtual void AllocateBuffers(PluginVideoPost *node, Render *render, BaseDocument *doc);
		virtual LONG GetRenderInfo(PluginVideoPost *node);

		virtual LONG Execute(PluginVideoPost *node, VideoPostStruct *vps);
		virtual void ExecuteLine(PluginVideoPost *node, PixelPost *pp);
		virtual void ExecutePixel(PluginVideoPost *node, PixelPost *pp, LONG x, LONG subx, LONG suby);

		virtual void CalcVolumetric(PluginVideoPost *node, VolumeData *vd);
		virtual void CalcShadow(PluginVideoPost *node, VolumeData *vd);
		virtual Bool GlDraw(PluginVideoPost *node, BaseDraw *bd, GlFrameBuffer* fbuf, LONG colortex, LONG depthtex, LONG flags);
		virtual LONG GetGlInfo(PluginVideoPost *node, BaseDocument* doc, BaseDraw *bd);

		virtual Vector ComputeDiffuseGI(PluginVideoPost *node, VolumeData *vd, Real receive_strength);
		virtual Vector ComputeDiffuseCaustic(PluginVideoPost *node, VolumeData *vd, Real sampleradius, LONG accuracy);
		virtual Vector ComputeVolumeCaustic(PluginVideoPost *node, const LVector &p);

		virtual void CreateRay(Ray *dst, Real x, Real y);
};

Bool RegisterVideoPostPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, LONG disklevel, LONG priority, void *emulation=NULL);

#endif
