/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __X4D_MERGE_LINES__
#define __X4D_MERGE_LINES__

#include	"x4d_filter.h"

//----------------------------------------------------------------------------------------
// Merging several lines
//----------------------------------------------------------------------------------------
extern ULONG	*merge_lines_px1_8( LONG line_cnt, LONG dst_cnt, 
																	LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																	ULONG *src, ULONG *dst );

extern ULONG	*merge_lines_G8_G8( LONG line_cnt, LONG dst_cnt, 
																	LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																	UCHAR *src, UCHAR *dst );

extern ULONG	*merge_lines_G16_G16( LONG line_cnt, LONG dst_cnt, 
																	LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																	PIX_W *src, PIX_W *dst );

extern PIX_F	*merge_lines_G32_G32( LONG line_cnt, LONG dst_cnt, 
																	LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																	PIX_F *src, PIX_F *dst );

extern ULONG	*merge_lines_xRGB15_xRGB15( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					UWORD *src, UWORD *dst );

extern ULONG	*merge_lines_AB16_AB16( LONG line_cnt, LONG dst_cnt, 
																			LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																			UWORD *src, UWORD *dst );

extern ULONG	*merge_lines_AB32_AB32( LONG line_cnt, LONG dst_cnt, 
																			LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																			ULONG *src, ULONG *dst );

extern PIX_F	*merge_lines_AB64_AB64( LONG line_cnt, LONG dst_cnt, 
																			LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																			PIX_F *src, PIX_F *dst );

extern ULONG	*merge_lines_AG16_AG16( LONG line_cnt, LONG dst_cnt, 
																			LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																			UWORD *src, UWORD *dst );

extern ULONG	*merge_lines_AG32_AG32( LONG line_cnt, LONG dst_cnt, 
																			LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																			ULONG *src, ULONG *dst );

extern PIX_F	*merge_lines_AG64_AG64( LONG line_cnt, LONG dst_cnt, 
																			LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																			PIX_F *src, PIX_F *dst );

extern ULONG	*merge_lines_RGB24_RGB24( LONG line_cnt, LONG dst_cnt, 
																				LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																				UCHAR *src, UCHAR *dst );

extern ULONG	*merge_lines_xRGB24_xRGB24( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					ULONG *src, ULONG *dst );

extern ULONG	*merge_lines_CMYK32_CMYK32( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					ULONG *src, ULONG *dst );

extern ULONG	*merge_lines_ARGB32_ARGB32( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					ULONG *src, ULONG *dst );


extern ULONG	*merge_lines_RGB48_RGB48( LONG line_cnt, LONG dst_cnt, 
																				LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																				PIX_W *src, PIX_W *dst );

extern ULONG	*merge_lines_xRGB48_xRGB48( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					ULONG *src, ULONG *dst );

extern ULONG	*merge_lines_CMYK64_CMYK64( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					ULONG *src, ULONG *dst );

extern ULONG	*merge_lines_ARGB64_ARGB64( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					ULONG *src, ULONG *dst );


extern PIX_F	*merge_lines_RGB96_RGB96( LONG line_cnt, LONG dst_cnt, 
																				LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																				PIX_F *src, PIX_F *dst );

extern PIX_F	*merge_lines_xRGB96_xRGB96( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					PIX_F *src, PIX_F *dst );

extern PIX_F	*merge_lines_CMYK128_CMYK128( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					PIX_F *src, PIX_F *dst );

extern PIX_F	*merge_lines_ARGB128_ARGB128( LONG line_cnt, LONG dst_cnt, 
																					LONG src_bits, LONG src_bit_offset, LONG src_line_offset, LONG dst_length,
																					PIX_F *src, PIX_F *dst );


#endif