/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _GERESOURCE_H
#define _GERESOURCE_H

#ifndef __API_INTERN__
	#include "ge_math.h"
	#include "c4d_string.h"
	#include "c4d_file.h"
#else
	#include "ge_math.h"
	#include "ge_string.h"
#endif

class Filename;
class BaseContainer;
class GeData;

class GeResource
{
	private:
		class LocalResource *lr;
		Bool state,glob;
		Filename *initfn;

	public:
		GeResource(void);
		~GeResource(void);

		Bool   Init(void);
		Bool   Init(const Filename &path);
		Bool	 InitAsGlobal(void);
		const String &LoadString(LONG id);
		Bool   ReloadResource(void); // dangerous! don't use this in release code!!!
		void   Free(void);

		LocalResource *Get() { return lr; }
};

const String &GeLoadString(LONG id);
String GeLoadString(LONG id, const String &p1);
String GeLoadString(LONG id, const String &p1, const String &p2);
String GeLoadString(LONG id, const String &p1, const String &p2, const String &p3);
String GeLoadString(LONG id, const String &p1, const String &p2, const String &p3,const String &p4);

Bool RegisterDescription(LONG id, const String &idstr, LocalResource *res=NULL);

BaseContainer* GetMenuResource(const String &menuname);
Bool SearchMenuResource(BaseContainer *bc, const String &searchstr);
GeData *SearchPluginMenuResource(const String &identifier = String("IDS_EDITOR_PLUGINS"));
void UpdateMenus(void);

extern GeResource resource;
void FreeResource();

#endif
