/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4D_OBJECTPLUGIN_H
#define __C4D_OBJECTPLUGIN_H

#include "ge_math.h"
#include "c4d_objectdata.h"
#include "c4d_nodeplugin.h"

#define QUALIFIER_SHIFT			(1<<0)
#define QUALIFIER_CTRL			(1<<1)
#define QUALIFIER_MOUSEHIT	(1<<10)

#define DRAWPASS_OBJECT			0
#define DRAWPASS_BOX				1
#define DRAWPASS_HANDLES		2
#define DRAWPASS_HIGHLIGHTS	3
#define DRAWPASS_XRAY				4

struct OBJECTPLUGIN : public NODEPLUGIN
{
	BaseBitmap		*command_icon;

	void					(ObjectData::*GetDimension			)(BaseObject *op, Vector *mp, Vector *rad);
	Bool					(ObjectData::*Draw							)(BaseObject *op, LONG drawpass, BaseDraw *bd, BaseDrawHelp *bh);
	LONG					(ObjectData::*DetectHandle			)(BaseObject *op, BaseDraw *bd, LONG x, LONG y, LONG qualifier);
	Bool					(ObjectData::*MoveHandle				)(BaseObject *op, BaseObject *undo, const Matrix &tm, LONG hit_id, LONG qualifier);

	// generator
	BaseObject*		(ObjectData::*GetVirtualObjects)(BaseObject *op, HierarchyHelp *hh);

	// modifier
	Bool					(ObjectData::*ModifyObject			)(BaseObject *mod, BaseDocument *doc, BaseObject *op, const Matrix &op_mg, const Matrix &mod_mg, Real lod, LONG flags, BaseThread *thread);
	void					(ObjectData::*CheckDirty				)(BaseObject *op, BaseDocument *doc);
	
	// spline
	SplineObject* (ObjectData::*GetContour				)(BaseObject *op, BaseDocument *doc, Real lod, BaseThread *bt);

	// particle
	void					(ObjectData::*ModifyParticles		)(BaseObject *op, Particle *pp, BaseParticle *ss, LONG pcnt, Real diff);
	Bool					(ObjectData::*AddToExecution	  )(BaseObject *op, PriorityList *list);
	LONG					(ObjectData::*Execute						)(BaseObject *op, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags);

	void					(ObjectData::*GetModelingAxis		)(BaseObject *op, BaseDocument *doc, Matrix &axis);
	
	void*	reserved[(32-12)*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
