#include "lib_viewport.h"

//////////////////////////////////////////////////////////////////////////

ViewportHUDLib *lib_viewhud = NULL;
ViewportHighlightLib *lib_viewhlight = NULL;
ViewportHUDControlLib *lib_viewhudctrl = NULL;

static ViewportHUDLib *CheckViewportHUDLib(LONG offset) { return (ViewportHUDLib*)CheckLib(LIBRARY_HUD,offset,(C4DLibrary**)&lib_viewhud); }
static ViewportHighlightLib *CheckViewportHighlightLib(LONG offset) { return (ViewportHighlightLib*)CheckLib(LIBRARY_HIGHLIGHT,offset,(C4DLibrary**)&lib_viewhlight); }

static ViewportHUDControlLib *CheckViewportHUDControlLib(LONG offset)
{
	return (ViewportHUDControlLib*)CheckLib(LIBRARY_HUD_CONTROL,offset,(C4DLibrary**)&lib_viewhudctrl);
}

#define ViewportHUDLibCall(b) 		ViewportHUDLib *lib = CheckViewportHUDLib(LIBOFFSET(ViewportHUDLib, b)); \
															if (!lib || !lib->b) return; \
															(((iViewportHUD*)this)->*lib->b)

#define ViewportHUDLibCallR(a,b)  ViewportHUDLib *lib = CheckViewportHUDLib(LIBOFFSET(ViewportHUDLib, b)); \
															if (!lib || !lib->b) return a; \
															return (((iViewportHUD*)this)->*lib->b)

#define ViewportHighlightLibCall(b) 		ViewportHighlightLib *lib = CheckViewportHighlightLib(LIBOFFSET(ViewportHighlightLib, b)); \
															if (!lib || !lib->b) return; \
															(((iViewportHighlight*)this)->*lib->b)

#define ViewportHighlightLibCallR(a,b)  ViewportHighlightLib *lib = CheckViewportHighlightLib(LIBOFFSET(ViewportHighlightLib, b)); \
															if (!lib || !lib->b) return a; \
															return (((iViewportHighlight*)this)->*lib->b)

#define ViewportHUDControlLibCall(b)  ViewportHUDControlLib *lib = CheckViewportHUDControlLib(LIBOFFSET(ViewportHUDControlLib, b)); \
															if (!lib || !lib->b) return; \
															(lib->b)

#define ViewportHUDControlLibCallR(a,b)  ViewportHUDControlLib *lib = CheckViewportHUDControlLib(LIBOFFSET(ViewportHUDControlLib, b)); \
															if (!lib || !lib->b) return a; \
															return (lib->b)

//////////////////////////////////////////////////////////////////////////

ViewportHUD* ViewportHUD::Alloc()
{
	ViewportHUDLib *lib = CheckViewportHUDLib(LIBOFFSET(ViewportHUDLib,Alloc)); if (!lib) return NULL;
	return (ViewportHUD*)lib->Alloc();	
}

void ViewportHUD::Free(ViewportHUD *&p)
{
	if (!p) return;
	ViewportHUDLib *lib = CheckViewportHUDLib(LIBOFFSET(ViewportHUDLib,Free)); if (!lib) return;
	iViewportHUD* i = (iViewportHUD*)p;
	lib->Free(i);
	p = NULL;
}

//////////////////////////////////////////////////////////////////////////

Bool ViewportHUD::AddDescID(BaseDocument *doc, BaseList2D *obj, const DescID &id, const BaseContainer &data)
{
	ViewportHUDLibCallR(FALSE,AddDescID)(doc,obj,id,data);
}

Bool ViewportHUD::BeginGroup()
{
	ViewportHUDLibCallR(FALSE,BeginGroup)();
}

ViewportHUDControl *ViewportHUD::EndGroup()
{
	ViewportHUDLibCallR(NULL,EndGroup)();
}

Bool ViewportHUD::SetElement(BaseDocument *doc, LONG id, Bool state)
{
	ViewportHUDLibCallR(FALSE,SetElement)(doc,id,state);
}

Bool ViewportHUD::IsValidControl(BaseDocument *doc, BaseList2D *obj, const DescID &id, const BaseContainer &data)
{
	ViewportHUDLibCallR(FALSE,IsValidControl)(doc,obj,id,data);
}

Bool ViewportHUD::DrawHUD(BaseDocument *doc, GeClipMap *clipmap, LONG fps, BaseDraw *bd, LONG flags)
{
	ViewportHUDLibCallR(FALSE,DrawHUD)(doc,clipmap,fps,bd,flags);
}

ViewportHUDControl *ViewportHUD::AddControl(LONG type, BaseDocument *doc, BaseDraw *bd, BaseList2D *obj, const DescID &id, const BaseContainer &data, const GeData &t_data, LONG datatype)
{
	ViewportHUDLibCallR(NULL,AddControl)(type,doc,bd,obj,id,data,t_data,datatype);
}

//////////////////////////////////////////////////////////////////////////

void ViewportHUDControl::SetLabel(const String &label) { ViewportHUDControlLibCall(SetLabel)(this,label); }
String ViewportHUDControl::GetLabel() { ViewportHUDControlLibCallR(String(),GetLabel)(this); }
void ViewportHUDControl::RemoveFlag(LONG flag) { ViewportHUDControlLibCall(RemoveFlag)(this,flag); }
void ViewportHUDControl::SetFlag(LONG flag) { ViewportHUDControlLibCall(SetFlag)(this,flag); }
LONG ViewportHUDControl::GetFlags() { ViewportHUDControlLibCallR(0,GetFlags)(this); }
void ViewportHUDControl::SetFlags(LONG flag) { ViewportHUDControlLibCall(SetFlags)(this,flag); }
LONG ViewportHUDControl::GetType() { ViewportHUDControlLibCallR(0,GetType)(this); }
Real ViewportHUDControl::GetLeft() { ViewportHUDControlLibCallR(0,GetLeft)(this); }
Real ViewportHUDControl::GetTop() { ViewportHUDControlLibCallR(0,GetTop)(this); }
String ViewportHUDControl::GetNameLabel() { ViewportHUDControlLibCallR(String(),GetNameLabel)(this); }
LONG ViewportHUDControl::GetWidth() { ViewportHUDControlLibCallR(0,GetWidth)(this); }
LONG ViewportHUDControl::GetHeight() { ViewportHUDControlLibCallR(0,GetHeight)(this); }
IconData *ViewportHUDControl::GetIconData() { ViewportHUDControlLibCallR(NULL,GetIconData)(this); }
void ViewportHUDControl::SetActionID(LONG id) { ViewportHUDControlLibCall(SetActionID)(this,id); }
void ViewportHUDControl::SetAction(const String &str) { ViewportHUDControlLibCall(SetAction)(this,str); }
void ViewportHUDControl::SetTopLeft(Real left, Real top) { ViewportHUDControlLibCall(SetTopLeft)(this,left,top); }
void ViewportHUDControl::SetActiveMode(LONG mode) { ViewportHUDControlLibCall(SetActiveMode)(this,mode); }
void ViewportHUDControl::SetDisplayFlags(LONG flags) { ViewportHUDControlLibCall(SetDisplayFlags)(this,flags); }
LONG ViewportHUDControl::GetDisplayFlags() { ViewportHUDControlLibCallR(0,GetDisplayFlags)(this); }
void ViewportHUDControl::RemoveDisplayFlags(LONG flags) { ViewportHUDControlLibCall(RemoveDisplayFlags)(this,flags); }
void ViewportHUDControl::SetObjectPos(LONG left, LONG top) { ViewportHUDControlLibCall(SetObjectPos)(this,left,top); }
void ViewportHUDControl::SetUnits(LONG units) { ViewportHUDControlLibCall(SetUnits)(this,units); }
void ViewportHUDControl::SetName(const String &name) { ViewportHUDControlLibCall(SetName)(this,name); }
String ViewportHUDControl::GetName() { ViewportHUDControlLibCallR(String(),GetName)(this); }
void ViewportHUDControl::SetControlID(LONG id) { ViewportHUDControlLibCall(SetControlID)(this,id); }
LONG ViewportHUDControl::GetControlID() { ViewportHUDControlLibCallR(NOTOK,GetControlID)(this); }
LONG ViewportHUDControl::GetControlCloneID() { ViewportHUDControlLibCallR(NOTOK,GetControlCloneID)(this); }
LONG ViewportHUDControl::GetGroupID() { ViewportHUDControlLibCallR(NOTOK,GetGroupID)(this); }
void ViewportHUDControl::SetGroupID(LONG id) { ViewportHUDControlLibCall(SetGroupID)(this,id); }

//////////////////////////////////////////////////////////////////////////

ViewportHighlight* ViewportHighlight::Alloc()
{
	ViewportHighlightLib *lib = CheckViewportHighlightLib(LIBOFFSET(ViewportHighlightLib,Alloc)); if (!lib) return NULL;
	return (ViewportHighlight*)lib->Alloc();	
}

void ViewportHighlight::Free(ViewportHighlight *&p)
{
	if (!p) return;
	ViewportHighlightLib *lib = CheckViewportHighlightLib(LIBOFFSET(ViewportHighlightLib,Free)); if (!lib) return;
	iViewportHighlight* i = (iViewportHighlight*)p;
	lib->Free(i);
	p = NULL;
}

//////////////////////////////////////////////////////////////////////////

Bool ViewportHighlight::Update(BaseDocument *pDoc, BaseDraw *pDraw, LONG x, LONG y)
{
	ViewportHighlightLibCallR(FALSE,Update)(pDoc,pDraw,x,y);
}

Bool ViewportHighlight::Draw(BaseDocument *pDoc, BaseDraw *pDraw)
{
	ViewportHighlightLibCallR(FALSE,Draw)(pDoc,pDraw);
}

Bool ViewportHighlight::Changed(BaseDocument *pDoc)
{
	ViewportHighlightLibCallR(FALSE,Changed)(pDoc);
}

void ViewportHighlight::ResetChanged(BaseDocument *pDoc)
{
	ViewportHighlightLibCall(ResetChanged)(pDoc);
}

Bool ViewportHighlight::HasHit(BaseDocument *pDoc)
{
	ViewportHighlightLibCallR(FALSE,HasHit)(pDoc);
}

void ViewportHighlight::GetHit(BaseDocument *pDoc, HighlightHitData *hitdata)
{
	ViewportHighlightLibCall(GetHit)(pDoc,hitdata);
}

void ViewportHighlight::SetMode(BaseDocument *pDoc, LONG mode)
{
	ViewportHighlightLibCall(SetMode)(pDoc,mode);
}

void ViewportHighlight::SetColor(BaseDocument *pDoc, Vector hcol)
{
	ViewportHighlightLibCall(SetColor)(pDoc,hcol);
}

void ViewportHighlight::SetFlags(BaseDocument *pDoc, LONG flags)
{
	ViewportHighlightLibCall(SetFlags)(pDoc,flags);
}

ViewportSelect *ViewportHighlight::GetViewportSelect(BaseDocument *pDoc, BaseDraw *pDraw)
{
	ViewportHighlightLibCallR(FALSE,GetViewportSelect)(pDoc,pDraw);
}

AtomArray *ViewportHighlight::GetObjects(BaseDocument *pDoc)
{
	ViewportHighlightLibCallR(FALSE,GetObjects)(pDoc);
}

LONG ViewportHighlight::GetFlags(BaseDocument *pDoc)
{
	ViewportHighlightLibCallR(0,GetFlags)(pDoc);
}
