/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2006 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

//---------------------------------------------------
//Spline Helper Class :: Header
//Routines to generate a full set of spline matrices
//incorporating a correct normal
//and accurate spline length to realworld length controls
//---------------------------------------------------
#ifndef _C4D_SPLINEHELP_H_
#define _C4D_SPLINEHELP_H_

#include "c4d.h"

#define C4D_SPLINEHELP_LIBRARY_ID		1019534

class SplineHelp
{
private:
	SplineHelp();
	~SplineHelp();
public:
	// autoalloc
	static SplineHelp *Alloc(void);
	static void				Free(SplineHelp *&node);

	Bool							InitSpline(BaseObject *op, Vector upvector=0.0, BaseObject *rail = NULL, Bool target_rail = TRUE, Bool use_deformed_points = FALSE, Bool force_update = FALSE, Bool use_global_space = TRUE); //must be called before any other command, optional up-vector
	void							FreeSpline(void); //must be called afterwards to free data
	//-----------------------------------------------------
	//helper routines
	Bool							Exists(void);
	LONG							GetSegmentCount(void);
	Real							GetSplineLength(void);
	Real							GetSegmentLength(LONG segment);
	Matrix						GetVertexMatrix(LONG index);
	Real							GetPointValue(Real offset, LONG segment);
	LONG							GetPointIndex(Real offset, LONG segment);
	Vector						GetPosition(Real offset, LONG segment = 0, Bool smooth = TRUE, Bool realoffset = FALSE);
	Vector						GetTangent(Real offset, LONG segment = 0, Bool smooth = TRUE, Bool realoffset = FALSE);
	Vector						GetNormal(Real offset, LONG segment = 0, Bool smooth = TRUE, Bool realoffset = FALSE);
	Vector						GetCrossNormal(Real offset, LONG segment = 0, Bool smooth = TRUE, Bool realoffset = FALSE);
	Real							GetOffsetFromUnit(Real unitoffset, LONG segment = 0);
	Real							GetOffsetFromReal(Real offset, LONG segment = 0);
	Matrix						GetMatrix(Real offset, LONG segment = 0, Bool smooth = TRUE, Bool realoffset = FALSE);
	void							GetLinePointSegment(LONG index, Real *offset, LONG *ind, LONG *segment);
	void							GetSplinePointSegment(LONG index, Real *offset, LONG *ind, LONG *segment);
	void							GlobalToLocal(Real offset, Real *off, LONG *segment, Bool realoffset = FALSE);
	LONG							SplineToLineIndex(LONG index);

	Real							GetSize(Real offset, LONG segment = 0, Bool smooth = TRUE, Bool realoffset = FALSE);
	Real							GetVertexSize(LONG index);
	LONG							GetVertexCount(LONG segment = NOTOK);
	Matrix						GetVertexMatrix(LONG segment, LONG index);

	Bool							IsClosed(LONG segment = 0);
	LONG							GetType(void);
	
	Bool							CopyTo(SplineHelp *dest);
};


//---------------------------------------------------
//	---INTERNAL STUFF
class iSplineHelp;

struct SplineHelpLibrary : public C4DLibrary
{
	iSplineHelp*			(*Alloc)();
	void							(*Free)(iSplineHelp *&node);


	Bool							(iSplineHelp::*InitSplineEx)(SplineObject *op, Vector upvector);

	void							(iSplineHelp::*FreeSpline)();
	Bool							(iSplineHelp::*Exists)();
	LONG							(iSplineHelp::*GetSegmentCount)();
	Real							(iSplineHelp::*GetSplineLength)();
	Real							(iSplineHelp::*GetSegmentLength)(LONG segment);
	Real							(iSplineHelp::*GetPointValue)(Real offset, LONG segment);
	LONG							(iSplineHelp::*GetPointIndex)(Real offset, LONG segment);

	Vector						(iSplineHelp::*GetPositionEx)(Real offset, LONG segment, Bool smooth);
	Vector						(iSplineHelp::*GetTangentEx)(Real offset, LONG segment, Bool smooth);
	Vector						(iSplineHelp::*GetNormalEx)(Real offset, LONG segment, Bool smooth);
	Vector						(iSplineHelp::*GetCrossNormalEx)(Real offset, LONG segment, Bool smooth);

	Real							(iSplineHelp::*GetOffsetFromUnit)(Real unitoffset, LONG segment);
	Real							(iSplineHelp::*GetOffsetFromReal)(Real offset, LONG segment);

	Matrix						(iSplineHelp::*GetMatrix)(Real offset, LONG segment, Bool smooth, Bool realoffset);
	void							(iSplineHelp::*GetLinePointSegment)(LONG index, Real *offset, LONG *ind, LONG *segment);
	void							(iSplineHelp::*GetSplinePointSegment)(LONG index, Real *offset, LONG *ind, LONG *segment);
	void							(iSplineHelp::*GlobalToLocal)(Real offset, Real *off, LONG *segment, Bool realoffset);
	Matrix						(iSplineHelp::*GetVertexMatrix)(LONG index);
	LONG							(iSplineHelp::*SplineToLineIndex)(LONG index);

	//MoGraph 2 Updates
	Bool							(iSplineHelp::*InitSpline)(BaseObject *op, Vector upvector, BaseObject *rail, Bool target_rail, Bool use_deformed_points, Bool force_update, Bool use_global_space);
	Vector						(iSplineHelp::*GetPosition)(Real offset, LONG segment, Bool smooth, Bool realoffset);
	Vector						(iSplineHelp::*GetTangent)(Real offset, LONG segment, Bool smooth, Bool realoffset);
	Vector						(iSplineHelp::*GetNormal)(Real offset, LONG segment, Bool smooth, Bool realoffset);
	Vector						(iSplineHelp::*GetCrossNormal)(Real offset, LONG segment, Bool smooth, Bool realoffset);
	Real							(iSplineHelp::*GetSize)(Real offset, LONG segment, Bool smooth, Bool realoffset);
	Real							(iSplineHelp::*GetVertexSize)(LONG index);
	LONG							(iSplineHelp::*GetVertexCount)(LONG segment);
	Matrix						(iSplineHelp::*GetVertexMatrix2)(LONG segment, LONG index);
	Bool							(iSplineHelp::*IsClosed)(LONG segment);
	LONG							(iSplineHelp::*GetType)();
	Bool							(iSplineHelp::*CopyTo)(iSplineHelp *dest);
};

//	---INTERNAL STUFF
//---------------------------------------------------


#endif
 
 