/////////////////////////////////////////////////////////////
// IGES 4D    : GENERIC CURVE AND SURFACES LIBRARY         //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D                                  //
/////////////////////////////////////////////////////////////
// (c) 2003-2004 MAXON Computer GmbH, Stefan Bauer         //
/////////////////////////////////////////////////////////////

#ifndef __DWGO_H
#define __DWGO_H

#include "c4d.h"
#include "lib_dwgobjectsdef.h"

#ifndef _INTERNAL_USE_ONLY_

class xBaseCurveData;

class xBaseCurveClass
{
		xBaseCurveClass();
		~xBaseCurveClass();
	public:
		xBaseCurveData *AllocCurve(LONG type);

		Bool Update(GeListNode *node);

		LONG GetSubDivision();
		void SetSubDivision(LONG subdiv);

		void SetOutput(LONG output);
};

class xBaseGeometryData
{
		xBaseGeometryData() { }
		~xBaseGeometryData() {}
	public:
		void Initialize(GeListNode *node);
};

class xBaseCurveData : public xBaseGeometryData
{
		xBaseCurveData();
		~xBaseCurveData();
	public:
		void SetPlanar(Bool planar);
};

class xLineCurveData : public xBaseCurveClass
{
		xLineCurveData();
		~xLineCurveData();
	public:
		void SetStartPoint(const Vector &v);
		void SetEndPoint(const Vector &v);
		void SetLimit(Real v);
		void SetLineType(LineCurveTypeEnum type);
};

class xCircularCurveData : public xBaseCurveData
{
		xCircularCurveData();
		~xCircularCurveData();
	public:
		void SetCenter(Real x, Real y);
		void SetZValue(Real z);
		void SetStartPoint(Real x, Real y);
		void SetEndPoint(Real x, Real y);
		void SetIsClockWise(Bool value);

		Real GetParameterMax(GeListNode *node=NULL);
		Real GetParameterMin(GeListNode *node=NULL);
};

class xConicCurveData : public xBaseCurveData
{
		xConicCurveData();
		~xConicCurveData();
	public:
		void SetZValue(Real z);
		void SetStartPoint(Real x, Real y);
		void SetEndPoint(Real x, Real y);
		void SetCoefficients(const ConicCurveCoeffcients &coeff);
		void SetCoefficients(Real a, Real b, Real c, Real d, Real e, Real f);
};

class xNurbsKnots
{
		xNurbsKnots();
		~xNurbsKnots();
	public:
		
		void SetPeriodic(Bool state);
		void Set(LONG i, Real value);
		Real GetMinValue(void);
		Real GetMaxValue(void);
		Real Get(LONG i);
};

class xBaseCurvePoint
{
		xBaseCurvePoint();
		~xBaseCurvePoint();
	public:
		void SetPosition(const Vector &vector);	
		const Vector &GetPosition();
};

class xNurbsCurvePoint : public xBaseCurvePoint
{
		xNurbsCurvePoint();
		~xNurbsCurvePoint();
	public:
		void SetWeight(Real w);
		Real GetWeight();
};

class xNurbsCurveData : public xBaseCurveData
{
		xNurbsCurveData();
		~xNurbsCurveData();
	public:
		Bool ResizeObject(LONG count, LONG degree);
		void SetClosed(Bool value);
		void SetPoint(LONG index, const Vector& position, const Real& weight);
		xNurbsKnots *GetKnots();
		void SetParameterRange(Real min, Real max);
		void SetPolynomial(Bool value);
		xNurbsCurvePoint* GetPoint(LONG index);
};

class xCompositeCurveData : public xBaseCurveData
{
		xCompositeCurveData();
		~xCompositeCurveData();
	public:
};

class xBaseSurfaceData;

class xBaseSurfaceClass : public ObjectData
{
		xBaseSurfaceClass();
		~xBaseSurfaceClass();
	public:
		xBaseSurfaceData *AllocSurface(LONG type);

		Bool Update(GeListNode *node);
		
		void SetSubU(LONG subu);
		void SetSubV(LONG subv);
		void SetOutput(LONG output);
		void SetNormalsActive(Bool normals_active);
		void SetNormalsSwap(Bool normals_swap);
};

class xBaseSurfaceData : public xBaseGeometryData
{
		xBaseSurfaceData();
		~xBaseSurfaceData();
	public:
};

class xExtrudeSurfaceData : public xBaseSurfaceData
{
		xExtrudeSurfaceData();
		~xExtrudeSurfaceData();
		
	public:
		void SetDirection(const Vector &v);
};

class xPlaneSurfaceData : public xBaseSurfaceData
{
		xPlaneSurfaceData();
		~xPlaneSurfaceData();
	public:
		void SetCoefficients(Real a, Real b, Real c, Real d);
		void SetDisplayPosition(const Vector &v);
		void SetDisplaySize(Real s);
		void SetLimit(Real v);
		void SetPlaneType(PlaneSurfaceTypeEnum type);
};

class xPolynomCurvePoint : public xBaseCurvePoint
{
		xPolynomCurvePoint();
		~xPolynomCurvePoint();
	public:
		void SetCoeff(LONG number, const Vector &vector);
};

class xPolynomCurveData : public xBaseCurveData
{
		xPolynomCurveData();
		~xPolynomCurveData();
	public:
		Bool ResizeObject(LONG count, LONG degree);
		Real* GetBreakPoint(LONG index);
		xPolynomCurvePoint* GetPoint(LONG index);
		LONG GetPointCount(GeListNode *node=NULL);
		void InitClosed();
};

class xPolynomSurfacePoint : public xPolynomCurvePoint
{
		xPolynomSurfacePoint();
		~xPolynomSurfacePoint();
	public:
		void SetUVCoeff(LONG uindex, LONG vindex, const Vector &vector);
};

class xPolynomSurfaceData : public xBaseSurfaceData
{
		xPolynomSurfaceData();
		~xPolynomSurfaceData();
	public:
		Bool ResizeObject(LONG ucount, LONG vcount, LONG udegree, LONG vdegree);
		Real* GetUBreakPoint(LONG index);
		Real* GetVBreakPoint(LONG index);
		xPolynomSurfacePoint* GetPoint(LONG uindex, LONG vindex);
		LONG GetPointCount(GeListNode *node=NULL);
		void InitClosed();
};

class xRotateSurfaceData : public xBaseSurfaceData
{
		xRotateSurfaceData();
		~xRotateSurfaceData();
	public:
		void SetStartAngle(Real angle);
		void SetEndAngle(Real angle);
		void SetInvert(Bool state);
};

class xUVPairFF
{
		xUVPairFF();
		~xUVPairFF();
	public:
		void SetPeriodicU(Bool u);
		void SetPeriodicV(Bool v);
		void SetU(LONG idx, Real u);
		void SetV(LONG idx, Real v);
		Real GetU(LONG idx);
		Real GetV(LONG idx);
};

class xNurbsSurfaceData : public xBaseSurfaceData
{
		xNurbsSurfaceData();
		~xNurbsSurfaceData();
	public:
		xUVPairFF* GetKnots();
		void SetPolynomial(Bool p);
		void SetUClosed(Bool c);
		void SetVClosed(Bool c);
		Bool ResizeObject(LONG ucount, LONG vcount, LONG udegree, LONG vdegree);
		void SetUParameterRange(Real min, Real max);
		void SetVParameterRange(Real min, Real max);
		LONG GetUPointCount(GeListNode *node=NULL);
		LONG GetVPointCount(GeListNode *node=NULL);
		xNurbsCurvePoint* GetPoint(LONG uindex, LONG vindex);
};

class xMappedCurveData;

class xMappedCurveClass : public ObjectData
{
		xMappedCurveClass();
		~xMappedCurveClass();
	public:
		xMappedCurveData *AllocMapped(LONG type);
		Bool Update(GeListNode *node);
};

class xMappedCurveData : public xBaseGeometryData
{
		xMappedCurveData();
		~xMappedCurveData();
	public:

};

class xStandardMappedCurveData : public xMappedCurveData
{
		xStandardMappedCurveData();
		~xStandardMappedCurveData();
	public:
		void SetSegmented(Bool value);
};

class xSegmentMappedCurveData : public xMappedCurveData
{
		xSegmentMappedCurveData();
		~xSegmentMappedCurveData();
	public:
		void SetReversed(Bool value);
};

class xTrimmedSurfaceData;

class xTrimmedSurfaceClass : public ObjectData
{
		xTrimmedSurfaceClass();
		~xTrimmedSurfaceClass();
	public:
		xTrimmedSurfaceData *AllocTrimmed(LONG type);
		void SetPrecision(Real precision);
		Bool Update(GeListNode *node);
};

class xTrimmedSurfaceData : public xBaseGeometryData
{
		xTrimmedSurfaceData();
		~xTrimmedSurfaceData();
	public:
};

class xStandardTrimmedSurfaceData : public xTrimmedSurfaceData
{
		xStandardTrimmedSurfaceData();
		~xStandardTrimmedSurfaceData();
	public:
		void SetFirstOuter(Bool value);
};

#else
	#define xBaseCurveClass								BaseCurveClass
	#define xBaseGeometryData							BaseGeometryData
	#define xBaseCurveData								BaseCurveData 
	#define xLineCurveData								LineCurveData 
	#define xCircularCurveData						CircularCurveData
	#define xConicCurveData								ConicCurveData 
	#define xNurbsKnots										NurbsKnots
	#define xNurbsCurveData								NurbsCurveData 
	#define xCompositeCurveData						CompositeCurveData
	#define xBaseSurfaceClass							BaseSurfaceClass
	#define xBaseSurfaceData							BaseSurfaceData
	#define xExtrudeSurfaceData						ExtrudeSurfaceData
	#define xBaseCurvePoint								BaseCurvePoint
	#define xNurbsCurvePoint							NurbsCurvePoint
	#define xPlaneSurfaceData							PlaneSurfaceData
	#define xPolynomCurvePoint						PolynomCurvePoint
	#define xPolynomCurveData							PolynomCurveData
	#define xPolynomSurfacePoint					PolynomSurfacePoint
	#define xPolynomSurfaceData						PolynomSurfaceData
	#define xRotateSurfaceData						RotateSurfaceData
	#define xUVPairFF											UVPairFF
	#define xNurbsSurfaceData							NurbsSurfaceData
	#define xMappedCurveClass							MappedCurveClass
	#define xMappedCurveData							MappedCurveData
	#define xStandardMappedCurveData			StandardMappedCurveData
	#define xSegmentMappedCurveData				SegmentMappedCurveData
	#define xTrimmedSurfaceClass					TrimmedSurfaceClass
	#define xTrimmedSurfaceData						TrimmedSurfaceData
	#define xStandardTrimmedSurfaceData		StandardTrimmedSurfaceData
#endif

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#define DWGOBJECTS_LIB 200000212

struct DWGObjectsLib : public C4DLibrary
{
	Bool									(xBaseCurveClass::*Update)(GeListNode *node);
	xBaseCurveData* 			(xBaseCurveClass::*AllocCurve)(LONG type);
	LONG									(xBaseCurveClass::*GetSubDivision)();
	void									(xBaseCurveClass::*SetSubDivision)(LONG subdiv);
	void									(xBaseCurveClass::*SetOutput)(LONG output);

	void									(xBaseCurveData::*SetPlanar)(Bool planar);

	void									(xBaseGeometryData::*Initialize)(GeListNode *node);

	void									(xLineCurveData::*SetStartPoint)(const Vector &v);
	void									(xLineCurveData::*SetEndPoint)(const Vector &v);
	void									(xLineCurveData::*SetLimit)(Real v);
	void									(xLineCurveData::*SetLineType)(LineCurveTypeEnum type);

	void									(xCircularCurveData::*SetCenter)(Real x, Real y);
	void									(xCircularCurveData::*SetZValue)(Real z);
	void									(xCircularCurveData::*SetStartPoint2)(Real x, Real y);
	void									(xCircularCurveData::*SetEndPoint2)(Real x, Real y);
	void									(xCircularCurveData::*SetIsClockWise)(Bool value);
	Real									(xCircularCurveData::*GetParameterMax)(GeListNode *node);
	Real									(xCircularCurveData::*GetParameterMin)(GeListNode *node);

	void									(xConicCurveData::*SetZValue2)(Real z);
	void									(xConicCurveData::*SetStartPoint3)(Real x, Real y);
	void									(xConicCurveData::*SetEndPoint3)(Real x, Real y);
	void									(xConicCurveData::*SetCoefficients1)(const ConicCurveCoeffcients &coeff);
	void									(xConicCurveData::*SetCoefficients2)(Real a, Real b, Real c, Real d, Real e, Real f);
	
	void									(xNurbsKnots::*SetPeriodic)(Bool state);
	void									(xNurbsKnots::*Set)(LONG i, Real value);
	Real									(xNurbsKnots::*GetMinValue)(void);
	Real									(xNurbsKnots::*GetMaxValue)(void);
	Real									(xNurbsKnots::*Get)(LONG i);

	void									(xBaseCurvePoint::*SetPosition)(const Vector &vector);	
	const Vector &				(xBaseCurvePoint::*GetPosition)();

	void									(xNurbsCurvePoint::*SetWeight)(Real w);
	Real									(xNurbsCurvePoint::*GetWeight)();

	Bool									(xNurbsCurveData::*ResizeObject4)(LONG count, LONG degree);
	void									(xNurbsCurveData::*SetClosed)(Bool value);
	void									(xNurbsCurveData::*SetPoint)(LONG index, const Vector& position, const Real& weight);
	xNurbsKnots*					(xNurbsCurveData::*GetKnots2)();
	void									(xNurbsCurveData::*SetParameterRange)(Real min, Real max);
	void									(xNurbsCurveData::*SetPolynomial3)(Bool value);
	xNurbsCurvePoint* 		(xNurbsCurveData::*GetPoint)(LONG index);

	xBaseSurfaceData*			(xBaseSurfaceClass::*AllocSurface)(LONG type);
	Bool									(xBaseSurfaceClass::*Update2)(GeListNode *node);
	void									(xBaseSurfaceClass::*SetSubU)(LONG subu);
	void									(xBaseSurfaceClass::*SetSubV)(LONG subv);
	void 									(xBaseSurfaceClass::*SetOutput2)(LONG output);
	void									(xBaseSurfaceClass::*SetNormalsActive)(Bool normals_active);
	void									(xBaseSurfaceClass::*SetNormalsSwap)(Bool normals_swap);

	void									(xExtrudeSurfaceData::*SetDirection)(const Vector &v);

	void									(xPlaneSurfaceData::*SetCoefficients)(Real a, Real b, Real c, Real d);
	void									(xPlaneSurfaceData::*SetDisplayPosition)(const Vector &v);
	void									(xPlaneSurfaceData::*SetDisplaySize)(Real s);
	void									(xPlaneSurfaceData::*SetLimit2)(Real v);
	void 									(xPlaneSurfaceData::*SetPlaneType)(PlaneSurfaceTypeEnum type);

	void									(xPolynomCurvePoint::*SetCoeff)(LONG number, const Vector &vector);

	Bool									(xPolynomCurveData::*ResizeObject2)(LONG count, LONG degree);
	Real*									(xPolynomCurveData::*GetBreakPoint)(LONG index);
	xPolynomCurvePoint*		(xPolynomCurveData::*GetPoint2)(LONG index);
	LONG									(xPolynomCurveData::*GetPointCount2)(GeListNode *node);
	void									(xPolynomCurveData::*InitClosed)();

	void 									(xPolynomSurfacePoint::*SetUVCoeff)(LONG uindex, LONG vindex, const Vector &vector);

	Bool									(xPolynomSurfaceData::*ResizeObject3)(LONG ucount, LONG vcount, LONG udegree, LONG vdegree);
	Real*									(xPolynomSurfaceData::*GetUBreakPoint)(LONG index);
	Real*									(xPolynomSurfaceData::*GetVBreakPoint)(LONG index);
	xPolynomSurfacePoint*	(xPolynomSurfaceData::*GetPoint3)(LONG uindex, LONG vindex);
	LONG									(xPolynomSurfaceData::*GetPointCount3)(GeListNode *node);
	void									(xPolynomSurfaceData::*InitClosed3)();

	void									(xRotateSurfaceData::*SetStartAngle)(Real angle);
	void									(xRotateSurfaceData::*SetEndAngle)(Real angle);
	void 									(xRotateSurfaceData::*SetInvert)(Bool state);

	void									(xUVPairFF::*SetPeriodicU)(Bool u);
	void									(xUVPairFF::*SetPeriodicV)(Bool v);
	void 									(xUVPairFF::*SetU)(LONG idx, Real u);
	void 									(xUVPairFF::*SetV)(LONG idx, Real v);
	Real 									(xUVPairFF::*GetU)(LONG idx);
	Real 									(xUVPairFF::*GetV)(LONG idx);

	xUVPairFF*						(xNurbsSurfaceData::*GetKnots)();
	void									(xNurbsSurfaceData::*SetPolynomial2)(Bool p);
	void									(xNurbsSurfaceData::*SetUClosed)(Bool c);
	void 									(xNurbsSurfaceData::*SetVClosed)(Bool c);
	Bool									(xNurbsSurfaceData::*ResizeObject5)(LONG ucount, LONG vcount, LONG udegree, LONG vdegree);
	void									(xNurbsSurfaceData::*SetUParameterRange)(Real min, Real max);
	void									(xNurbsSurfaceData::*SetVParameterRange)(Real min, Real max);
	LONG									(xNurbsSurfaceData::*GetUPointCount2)(GeListNode *node);
	LONG									(xNurbsSurfaceData::*GetVPointCount2)(GeListNode *node);
	xNurbsCurvePoint*			(xNurbsSurfaceData::*GetPoint4)(LONG uindex, LONG vindex);

	xMappedCurveData *		(xMappedCurveClass::*AllocMapped)(LONG type);
	Bool									(xMappedCurveClass::*Update3)(GeListNode *node);

	void									(xStandardMappedCurveData::*SetSegmented)(Bool value);

	void									(xSegmentMappedCurveData::*SetReversed)(Bool value);

	xTrimmedSurfaceData *	(xTrimmedSurfaceClass::*AllocTrimmed)(LONG type);
	void									(xTrimmedSurfaceClass::*SetPrecision4)(Real precision);
	Bool									(xTrimmedSurfaceClass::*Update4)(GeListNode *node);

	void									(xStandardTrimmedSurfaceData::*SetFirstOuter)(Bool value);

	Bool									(*xConvertToPolygons)(BaseObject *oroot, BaseObject *destination, LONG flags);
	Bool									(*xConvertToPolygonGroups)(BaseObject *oroot, BaseObject *destination, LONG flags);
	Bool									(*xCenterAxis)(BaseObject *oroot);
	Bool									(*xFilterModelSpaceCurves)(BaseObject *oroot);
};

#define CONVERT_CACHES (1<<0)
#define CONVERT_TOONE  (1<<1)

Bool xConvertToPolygons(BaseObject *oroot, BaseObject *destination, LONG flags);
Bool xConvertToPolygonGroups(BaseObject *oroot, BaseObject *destination, LONG flags);
Bool xCenterAxis(BaseObject *oroot);
Bool xFilterModelSpaceCurves(BaseObject *oroot);

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif //__DWGO_H