/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4D_FILTERPLUGIN_H
#define __C4D_FILTERPLUGIN_H

#include "ge_math.h"
#include "c4d_filterdata.h"
#include "c4d_nodeplugin.h"

struct BITMAPLOADERPLUGIN : public STATICPLUGIN
{
	Bool (BitmapLoaderData::*Identify			 )(const Filename &name, UCHAR *probe, LONG size);
	LONG (BitmapLoaderData::*Load					 )(const Filename &name, BaseBitmap *bm, LONG frame);
	LONG (BitmapLoaderData::*GetSaver			 )(void);
	Bool (BitmapLoaderData::*GetInformation)(const Filename &name, LONG *frames, Real *fps);
	LONG (BitmapLoaderData::*LoadAnimated  )(BitmapLoaderAnimatedData *bd, LONG action, BaseBitmap *bm, LONG frame);
	LONG (BitmapLoaderData::*ExtractSound  )(BitmapLoaderAnimatedData *bd, BaseSound *snd);

	void*	reserved[(32-6)*C4DPL_MEMBERMULTIPLIER];
};

struct BITMAPSAVERPLUGIN : public STATICPLUGIN
{
	String		*suffix;

	LONG (BitmapSaverData::*Save					)(const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits);
	Bool (BitmapSaverData::*Edit					)(BaseContainer *data);
	LONG (BitmapSaverData::*GetMaxAlphas	)(BaseContainer *data);

	LONG (BitmapSaverData::*Open					)(PluginMovieData *&md, const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits, LONG fps);
	LONG (BitmapSaverData::*Write					)(PluginMovieData *md, BaseBitmap *bm);
	void (BitmapSaverData::*Close					)(PluginMovieData *&md);
	LONG (BitmapSaverData::*AddSound      )(PluginMovieData *md, BaseSound *snd);

	void*	reserved[(32-7)*C4DPL_MEMBERMULTIPLIER-1];
};

struct SCENELOADERPLUGIN : public NODEPLUGIN
{
	Bool (SceneLoaderData::*Identify			)(PluginSceneLoader *node, const Filename &name, UCHAR *probe, LONG size);
	LONG (SceneLoaderData::*LoadEx				)(PluginSceneLoader *node, const Filename &name, BaseDocument *doc, LONG filterflags, String *error, Bool *framescene);
	LONG (SceneLoaderData::*Load  				)(PluginSceneLoader *node, const Filename &name, BaseDocument *doc, LONG filterflags, String *error, BaseThread *bt);
	void*	reserved[(32-3)*C4DPL_MEMBERMULTIPLIER-0];
};

struct SCENESAVERPLUGIN : public NODEPLUGIN
{
	String		*suffix;

	LONG (SceneSaverData::*Save						)(PluginSceneSaver *node, const Filename &name, BaseDocument *doc, LONG filterflags);

	void*	reserved[(32-1)*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
