/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4D_COMMANDDATA_H
#define __C4D_COMMANDDATA_H

#include "c4d_basedata.h"

class String;
class BaseContainer;
class BaseDocument;
class BaseBitmap;

struct RestoreLayoutSecret
{
	LONG subid;	
};

#define PLUGINFLAG_COMMAND_HOTKEY (1<<27)

#define MSG_COMMANDINFORMATION 300001001	
#define MSG_BODYPAINTEXCHANGE  300001002

struct CommandInformationData
{
	LONG command_id;	// read

	LONG managergroup; // write
	LONG parentid;
};

class CommandData : public BaseData
{
	public:
		virtual Bool Execute(BaseDocument *doc);
		virtual Bool ExecuteSubID(BaseDocument *doc, LONG subid);

		virtual LONG GetState(BaseDocument *doc);
		virtual Bool GetSubContainer(BaseDocument *doc, BaseContainer &submenu);

		virtual Bool RestoreLayout(void *secret);
		virtual String GetScriptName(void); 

		virtual Bool Message(LONG type, void *data);
};

#ifndef _API_INTERN
	Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, BaseBitmap *icon, const String &help, CommandData *dat);
	Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, String icon, const String &help, CommandData *dat);
#endif

Bool RegisterManagerInformation(LONG id, const String &str, LONG info);

#endif
