/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DCOFFEE_H
#define __C4DCOFFEE_H

class String;
class Coffee;
class Value;
class GeData;

Bool GeCoffeeCompileString(Coffee* cof, const String& src);
Bool GeCoffeeCompileFile(Coffee* cof, const Filename& file);

VALUE* GeCoffeeAddGlobalSymbol(Coffee* cof, const String& name);
VALUE* GeCoffeeFindGlobalSymbol(Coffee* cof, const String& name);

Coffee *GetCoffeeMaster(void);

Bool GeCoffeeExecute(Coffee* cof, VALUE* func, GeData* retval = NULL, GeData* arg1 = NULL, GeData* arg2 = NULL, GeData* arg3 = NULL);
Bool GeCoffeeGeData2Value(Coffee* cof, const GeData& src, VALUE* dest);
Bool GeCoffeeValue2GeData(Coffee* cof, VALUE *src, GeData* dest);
Bool GeCoffeeGetLastError(Coffee* cof, String *err_string, LONG *err_line, LONG *err_pos);

Bool CoffeeEditor_Open(BaseList2D *obj,CoffeeEditorCallback *callback);

enum SyType
{
  ST_CLASS			= 1, 	// class definition
  ST_DATA				= 2, 	// public data
  ST_CDATA			= 3, 	// protected/static data
  ST_PDATA			= 4, 	// private data
  ST_FUNCTION		= 5, 	// function
  ST_METHOD			= 6, 	// public method
  ST_CMETHOD		= 7,  // protected method
  ST_PMETHOD		= 8		// private method
};

enum VaType
{
  DT_NIL				= 0, 	
  DT_LONG				= 1, 	
  DT_FLOAT			= 2,
  DT_VECTOR			= 3,
  DT_VOID				= 4, 	
  DT_BYTES			= 5,
  DT_STRING			= 6,
  DT_CLASS			= 7,
  DT_OBJECT			= 8,
  DT_ARRAY			= 9,
  DT_BYTECODE		= 10,
  DT_CODE				= 11, 	
  DT_EXTCODE		= 12,

  DT_EXCEPTION	= 13,
  DT_SEXCEPTION	= 14,
  DT_DICTIONARY	= 15,
  DT_ENTRY			= 16,
  DT_INSTANCE		= 17,

  DT_NUMBER			= 99	
};

enum CoffeeError
{
	COFFEEERROR_BBLOCK			= 1,
	COFFEEERROR_MEM					= 2,
	COFFEEERROR_ARGV				= 3,
	COFFEEERROR_ARGW				= 4,
	COFFEEERROR_BTYP				= 5,
	COFFEEERROR_BOPCODE			= 6,
	COFFEEERROR_NPROC				= 7,
	COFFEEERROR_BMETHOD			= 8,
	COFFEEERROR_NMETHOD			= 9,
	COFFEEERROR_NPUBLIC			= 10,
	COFFEEERROR_MPROTECTED	= 11,
	COFFEEERROR_MPRIVATE		= 12,
	COFFEEERROR_SUBSCR			= 13,
	COFFEEERROR_STACKOV			= 14,
	COFFEEERROR_DIV0				= 15,
	COFFEEERROR_EXEPT				= 16,
	COFFEEERROR_INVALIDID		= 17,
	COFFEEERROR_PARAMACCESS	= 18,
	COFFEEERROR_PARAMVALUE  = 19,
	COFFEEERROR_PARAMTYPE   = 20,
	COFFEEERROR_EDEC				= 100,
	COFFEEERROR_EMDEC				= 101,
	COFFEEERROR_EFUNC				= 102,
	COFFEEERROR_IRDEF				= 103,
	COFFEEERROR_ECNAME			= 104,
	COFFEEERROR_TMLOOP			= 105,
	COFFEEERROR_BOLOOP			= 106,
	COFFEEERROR_COLOOP			= 107,
	COFFEEERROR_SOLOOP			= 108,
	COFFEEERROR_NCASE				= 109,
	COFFEEERROR_NVAR				= 110,
	COFFEEERROR_ELVAL				= 111,
	COFFEEERROR_NCLASSM			= 112,
	COFFEEERROR_BPARENT			= 113,
	COFFEEERROR_NPARENT			= 114,
	COFFEEERROR_BSUPER			= 115,
	COFFEEERROR_NSUPER			= 116,
	COFFEEERROR_PROTECT			= 117,
	COFFEEERROR_EVAR				= 118,
	COFFEEERROR_EPRIM				= 119,
	COFFEEERROR_ISPACE			= 120,
	COFFEEERROR_ECLOSE			= 121,
	COFFEEERROR_PARGV				= 122,
	COFFEEERROR_PARGW				= 123,
	COFFEEERROR_SYNTAX			= 124,
	COFFEEERROR_INCLUDE			= 125,
	COFFEEERROR_VARONLY			= 126,
	COFFEEERROR_CLASSB			= 200,
	COFFEEERROR_CLASS				= 201,
	COFFEEERROR_FUNC				= 202,
	COFFEEERROR_MEMBERF			= 203,
	COFFEEERROR_EXPECT			= 204
};

// Opcodes

class VALUE
{
		VaType v_type; 				
		union
		{
			LONG	v_integer; 		
			Real	v_float; 			
			Real	v_vector[3]; 	
			void*	v_void; 			
		}v;

	public:

		VALUE(void);

		Bool		IsType(VaType type) const;

		VaType	GetType(void) const;
		void		SetNil(void);

		LONG		GetLong(LONG *err = NULL) const;
		Real		GetReal(LONG *err = NULL) const;
		Vector	GetVector(LONG *err = NULL) const;
		void*		GetVoid(LONG *err = NULL) const;

		void		SetVoid(const void *v);
		void		SetLong(LONG i);
		void		SetReal(Real f);
		void		SetVector(const Vector &v);

		VALUE*	GetObjMember(LONG nr);

		VALUE*	GetArrayMember(LONG i);
		void		SetArray(ARRAY *a);

		OBJECT*	GetObject(LONG *err = NULL);
		void		SetObject(OBJECT *o);

		void		SetString(STRING *s);
		String  GetString(void);

		Bool		IsInstanceOf(VALUE *cl, LONG *err = NULL);

		LONG		GetSize(void);
		UCHAR*	GetBytes(void);
};

class	Coffee
{
	private:
		Coffee();
		~Coffee();
	public:
		VALUE*	GetGlobalClass(const String &name);

		CLASS*	AddGlobalClass(const String &name, const String &parent = String());
		Bool		AddGlobalSymbol(const String &name, const VALUE *v, SyType type);
		Bool		AddGlobalFunction(const String &name, V_CODE fcn);

		Bool		AddClassMember(const String &name, CLASS *c, SyType type);
		Bool		AddClassMethod(const String &name, CLASS *c, SyType type, V_CODE fcn, LONG argc = -1);

		STRING*	AllocString(const String &s);

		OBJECT*	NewObject(const String &cl_name);
		ARRAY*	NewArray(LONG size);

		void		Wrongcnt(LONG n, LONG cnt);
		void		ErrCheckType(VALUE *v, VaType type, LONG *err = NULL);
		void		ErrCheckObjectType(VALUE *v, const String &cl_name, LONG *err = NULL);
		void		ErrCheckArgCount(LONG argc, LONG cnt, LONG *err = NULL);

		void		SetError(LONG type,const String &s1=String(), const String &s2=String());
		void		InstallErrorHook(COFFEE_ERRORHANDLER *priv_hndl, void *priv_data);

		LONG		GetType(void);

		const Filename&	GetRootFile(void);
		void		SetRootFile(const Filename &fn);

		OBJECT* AllocDynamic(BaseList2D *bl, Bool coffeeallocation);
		CLASS*  AddInheritance(LONG id, const String &name, const String &from, Bool use_constructor=TRUE);

		static Coffee* Alloc();
		static void Free(Coffee* &cof);
};

#endif
