#include "c4d_memory.h"
#include "c4d_basetag.h"
#include "c4d_basecontainer.h"

class BaseSelect;

LONG VariableTag::GetDataCount(void)
{
	return C4DOS.Tg->GetDataCount(this);	
}	

LONG VariableTag::GetDataSize(void)
{
	return C4DOS.Tg->GetDataSize(this);	
}	

const void *VariableTag::GetDataAddressR(void)
{
	return C4DOS.Tg->GetDataAddressR(this);	
}	

void *VariableTag::GetDataAddressW(void)
{
	return C4DOS.Tg->GetDataAddressW(this);	
}	

BaseSelect *SelectionTag::GetBaseSelect(void)
{
	return C4DOS.Tg->GetBaseSelect(this);
}

Vector TextureTag::GetPos(void)
{
	return C4DOS.Tx->GetPos(this);
}

Vector TextureTag::GetScale(void)
{
	return C4DOS.Tx->GetScale(this);
}

Vector TextureTag::GetRot(void)
{
	return C4DOS.Tx->GetRot(this);
}

Matrix TextureTag::GetMl(void)
{
	return C4DOS.Tx->GetMl(this);
}

Matrix TextureTag::GetMln(void)
{
	return C4DOS.Tx->GetMln(this);
}

void TextureTag::SetPos(const Vector &v)
{
	C4DOS.Tx->SetPos(this,v);
}

void TextureTag::SetScale(const Vector &v)
{
	C4DOS.Tx->SetScale(this,v);
}

void TextureTag::SetRot(const Vector &v)
{
	C4DOS.Tx->SetRot(this,v);
}

void TextureTag::SetMl(const Matrix &m)
{
	C4DOS.Tx->SetMl(this,m);
}

BaseMaterial *TextureTag::GetMaterial(Bool ignoredoc)
{
	return C4DOS.Tx->GetMaterial(this,ignoredoc);
}

void TextureTag::SetMaterial(BaseMaterial *mat)
{
	C4DOS.Tx->SetMaterial(this,mat);
}

Bool StickTextureTag::Record(BaseObject *op, Bool always)
{
	return C4DOS.Tg->Record(this,op,always);
}

BaseTag *BaseTag::Alloc(LONG type)
{
	return C4DOS.Tg->Alloc(type,0,0);
}

void BaseTag::Free(BaseTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

PluginTag *PluginTag::Alloc(LONG type)
{
	return (PluginTag*)C4DOS.Tg->Alloc(type,0,0);
}

void PluginTag::Free(PluginTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

VariableTag *VariableTag::Alloc(LONG type, LONG count)
{
	return (VariableTag*)C4DOS.Tg->Alloc(type,0,count);
}

void VariableTag::Free(VariableTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

SelectionTag *SelectionTag::Alloc(LONG type)
{
	return (SelectionTag*)C4DOS.Tg->Alloc(type,0,0);
}

void SelectionTag::Free(SelectionTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

UVWTag *UVWTag::Alloc(LONG count)
{
	return (UVWTag*)C4DOS.Tg->Alloc(Tuvw,0,count);
}

void UVWTag::Free(UVWTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

TextureTag *TextureTag::Alloc()
{
	return (TextureTag*)C4DOS.Tg->Alloc(Ttexture,0,0);
}

void TextureTag::Free(TextureTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

StickTextureTag *StickTextureTag::Alloc(LONG type)
{
	return (StickTextureTag*)C4DOS.Tg->Alloc(Tsticktexture,0,0);
}

void StickTextureTag::Free(StickTextureTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

GvNodeMaster *XPressoTag::GetNodeMaster(void)
{
	RetrievePrivateData rp;
	rp.flags=0;
	rp.data =NULL;
	
	if (!Message(MSG_RETRIEVEPRIVATEDATA,&rp)) return NULL;
	return (GvNodeMaster*)rp.data;
}

XPressoTag *XPressoTag::Alloc()
{
	return (XPressoTag*)C4DOS.Tg->Alloc(Texpresso,0,0);
}

void XPressoTag::Free(XPressoTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}


HNWeightTag *HNWeightTag::Alloc()
{
	return (HNWeightTag*)C4DOS.Tg->Alloc(Tsds, 0, 0);
}

void HNWeightTag::Free(HNWeightTag *&bl)
{
	C4DOS.Bl->Free(bl);
	bl = NULL;
}

Bool HNWeightTag::GetTagData(HNData* data)
{
  if (!data) return FALSE;

	RetrievePrivateData rp;
	rp.flags = 0;
	rp.data = data;

  if (!Message(MSG_RETRIEVEPRIVATEDATA, &rp)) return FALSE;

  return TRUE;
}

BaseTag *BaseTag::GetOrigin()
{
	return C4DOS.Tg->GetOrigin(this);
}
