/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2006 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _C4D_EFFECTORDATAPLUGIN_H_
#define _C4D_EFFECTORDATAPLUGIN_H_

#include "c4d.h"
#include "c4d_baseeffectordata.h"

//--------------------------------------------------------
//	--- Internal Stuff

struct EFFECTORPLUGIN : public OBJECTPLUGIN
{
	EffectorDataStruct*	(EffectorData::*GetEffectorData				)();
	C4D_Falloff*				(EffectorData::*GetFalloff						)();
	void								(EffectorData::*AddEffectorDependence	)(BaseObject *op);
	LONG								(EffectorData::*GetEffectorFlags			)();
	Bool								(EffectorData::*ModifyDDescription		)(GeListNode *node, Description *description, AtomArray *ar);
	Bool								(EffectorData::*ExecuteEffector				)(BaseObject *op, BaseDocument *doc, BaseObject *gen, MoData *md, Real strength, BaseThread *thread);
	void								(EffectorData::*InitPoints						)(BaseObject *op, BaseObject *gen, BaseDocument *doc, EffectorDataStruct *data, MoData *md, BaseThread *thread);
	void								(EffectorData::*ModifyPoints					)(BaseObject *op, BaseObject *gen, BaseDocument *doc, EffectorDataStruct *data, MoData *md, BaseThread *thread);
	void								(EffectorData::*FreePoints						)();
	void								(EffectorData::*CalcPlacebo						)(BaseObject *op,BaseObject *gen,BaseDocument	*doc,EffectorDataStruct *data, LONG index, MoData *md, const Vector &globalpos, Real fall_weight);
	void								(EffectorData::*CalcPointValue				)(BaseObject *op, BaseObject *gen, BaseDocument *doc, EffectorDataStruct *data, LONG index, MoData *md, const Vector &globalpos, Real fall_weight);
	Vector							(EffectorData::*CalcPointColor				)(BaseObject *op, BaseObject *gen, BaseDocument *doc, EffectorDataStruct *data, LONG index, MoData *md, const Vector &globalpos, Real fall_weight );
	Bool								(EffectorData::*InitEffector					)(GeListNode *node);
	void								(EffectorData::*FreeEffector					)(GeListNode *node);

	void*	reserved[(32-14)*C4DPL_MEMBERMULTIPLIER];
};

struct EffectorDataLib : public C4DLibrary
{
	Bool								(*Effector_Init									)(GeListNode *node);
	void								(*Effector_Free									)(GeListNode *node);
	Bool								(*Effector_GetDDescription			)(GeListNode *node, Description *description, LONG &flags);
	Bool								(*Effector_Draw									)(BaseObject *op, LONG type, BaseDraw *bd, BaseDrawHelp *bh);
	void								(*Effector_GetDimension					)(BaseObject *op, Vector *mp, Vector *rad);
	LONG								(*Effector_Execute							)(BaseObject *op, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags);
	Bool								(*Effector_ModifyObject					)(BaseObject *mod,BaseDocument *doc,BaseObject *op,const Matrix &op_mg,const Matrix	&mod_mg,Real lod,LONG flags,BaseThread *thread);
	Bool								(*Effector_Message							)(GeListNode *node, LONG type, void *t_data);
	LONG								(*Effector_GetHandleCount				)(BaseObject *op);
	Vector							(*Effector_GetHandle						)(BaseObject *op, LONG i);
	void								(*Effector_SetHandle						)(BaseObject *op, LONG i, Vector p);

	EffectorDataStruct*	(*Effector_GetEffectorData			)(GeListNode *node);
	C4D_Falloff*				(*Effector_GetFalloff						)(GeListNode *node);
	void								(*Effector_AddEffectorDependence)(GeListNode *node,BaseObject *op);
	Bool								(*Effector_ExecuteEffector			)(BaseObject *op, BaseDocument *doc, BaseObject *gen, MoData *md, Real strength, BaseThread *thread);
	void								(*Effector_ModifyPoints					)(BaseObject *op, BaseObject *gen, BaseDocument *doc, EffectorDataStruct *data, MoData *md, BaseThread *thread);
	Bool								(*Effector_CopyTo								)(NodeData *dest,GeListNode *snode,GeListNode *dnode,LONG flags,AliasTrans *trn);
};

class iMoData;

struct MoDataLib : public C4DLibrary
{
	ULONG								(iMoData::*GetDirty							)(LONG mask);
	void								(iMoData::*SetDirty							)(LONG mask);
	Bool								(iMoData::*SetWithEx						)(const MoDataEx &md);
	void								(iMoData::*Clear								)(Bool reset);
	Bool								(iMoData::*Read									)(HyperFile *hf);
	Bool								(iMoData::*Write								)(HyperFile *hf);
	VLONG								(iMoData::*GetMemorySize				)();
	Bool								(iMoData::*SetCount							)(VLONG cnt);
	VLONG								(iMoData::*GetCount							)();
	LONG								(iMoData::*GetArrayCount				)();
	DescID							(iMoData::*GetArrayDescID				)(LONG index) const;
	LONG								(iMoData::*GetArrayID						)(LONG index) const;
	LONG								(iMoData::*GetArrayIndexType		)(LONG index);
	LONG								(iMoData::*GetArrayType					)(LONG id);
	VLONG								(iMoData::*GetArrayIndex1				)(const DescID &id);
	VLONG								(iMoData::*GetArrayIndex2				)(LONG id);
	BaseContainer*			(iMoData::*GetDataInstance1			)(const DescID &id);
	BaseContainer*			(iMoData::*GetDataInstance2			)(LONG id);
	BaseContainer*			(iMoData::*GetDataIndexInstance	)(LONG id);
	BaseContainer				(iMoData::*GetData							)(LONG id);
	void								(iMoData::*SetData							)(const BaseContainer &bc, LONG id);
	GE_SPINLOCK*				(iMoData::*GetSpinLock					)();
	GE_AUTOLOCK*				(iMoData::*GetAutoLock					)();
	LONG								(iMoData::*AddArray1						)(const DescID &id, const String &name, LONG default_flags);
	LONG								(iMoData::*AddArray2						)(LONG id, LONG type, const String &name, LONG default_flags);
	Bool								(iMoData::*RemoveArray1					)(const DescID &id);
	Bool								(iMoData::*RemoveArray2					)(LONG id);
	LONG								(iMoData::*GetFlags1						)(const DescID &id);
	LONG								(iMoData::*GetFlags2						)(LONG id);
	LONG								(iMoData::*GetIndexFlags				)(LONG index);
	void								(iMoData::*SetFlags1						)(const DescID &id, LONG flags);
	void								(iMoData::*SetFlags2						)(LONG id, LONG flags);
	void								(iMoData::*SetIndexFlags				)(LONG index, LONG flags);
	void								(iMoData::*SetFlag1							)(const DescID &id, LONG flag);
	void								(iMoData::*SetFlag2							)(LONG id, LONG flag);
	void								(iMoData::*SetIndexFlag					)(LONG index, LONG flag);
	void								(iMoData::*DelFlag1							)(const DescID &id, LONG flag);
	void								(iMoData::*DelFlag2							)(LONG id, LONG flag);
	void								(iMoData::*DelIndexFlag					)(LONG index, LONG flag);
	void								(iMoData::*SetName1							)(const DescID &id, const String &name);
	void								(iMoData::*SetName2							)(LONG id, const String &name);
	void								(iMoData::*SetIndexName					)(LONG index, const String &name);
	String							(iMoData::*GetName1							)(const DescID &id);
	String							(iMoData::*GetName2							)(LONG id);
	String							(iMoData::*GetIndexName					)(LONG index);

	void*								(iMoData::*GetArray1						)(const DescID &id) const;
	MDArray<CHAR>				(iMoData::*GetCharArray1				)(const DescID &id, CHAR default_value) const;
	MDArray<UCHAR>			(iMoData::*GetUCharArray1				)(const DescID &id, UCHAR default_value) const;
	MDArray<LONG>				(iMoData::*GetLongArray1				)(const DescID &id, LONG default_value) const;
	MDArray<ULONG>			(iMoData::*GetULongArray1				)(const DescID &id, ULONG default_value) const;
	MDArray<Bool>				(iMoData::*GetBoolArray1				)(const DescID &id, Bool default_value) const;
	MDArray<LLONG>			(iMoData::*GetLLongArray1				)(const DescID &id, LLONG default_value) const;
	MDArray<Real>				(iMoData::*GetRealArray1				)(const DescID &id, Real default_value) const;
	MDArray<Matrix>			(iMoData::*GetMatrixArray1			)(const DescID &id, Matrix default_value) const;
	MDArray<Vector>			(iMoData::*GetVectorArray1			)(const DescID &id, Vector default_value) const;

	void*								(iMoData::*GetArray2						)(LONG id) const;
	MDArray<CHAR>				(iMoData::*GetCharArray2				)(LONG id, CHAR default_value) const;
	MDArray<UCHAR>			(iMoData::*GetUCharArray2				)(LONG id, UCHAR default_value) const;
	MDArray<LONG>				(iMoData::*GetLongArray2				)(LONG id, LONG default_value) const;
	MDArray<ULONG>			(iMoData::*GetULongArray2				)(LONG id, ULONG default_value) const;
	MDArray<Bool>				(iMoData::*GetBoolArray2				)(LONG id, Bool default_value) const;
	MDArray<LLONG>			(iMoData::*GetLLongArray2				)(LONG id, LLONG default_value) const;
	MDArray<Real>				(iMoData::*GetRealArray2				)(LONG id, Real default_value) const;
	MDArray<Matrix>			(iMoData::*GetMatrixArray2			)(LONG id, Matrix default_value) const;
	MDArray<Vector>			(iMoData::*GetVectorArray2			)(LONG id, Vector default_value) const;

	//Get arrays using LONG indexes
	void*								(iMoData::*GetIndexArray				)(LONG index) const;
	MDArray<CHAR>				(iMoData::*GetCharIndexArray		)(LONG index) const;
	MDArray<UCHAR>			(iMoData::*GetUCharIndexArray		)(LONG index) const;
	MDArray<LONG>				(iMoData::*GetLongIndexArray		)(LONG index) const;
	MDArray<ULONG>			(iMoData::*GetULongIndexArray		)(LONG index) const;
	MDArray<Bool>				(iMoData::*GetBoolIndexArray		)(LONG index) const;
	MDArray<LLONG>			(iMoData::*GetLLongIndexArray		)(LONG index) const;
	MDArray<Real>				(iMoData::*GetRealIndexArray		)(LONG index) const;
	MDArray<Matrix>			(iMoData::*GetMatrixIndexArray	)(LONG index) const;
	MDArray<Vector>			(iMoData::*GetVectorIndexArray	)(LONG index) const;

	Bool								(iMoData::*CopyTo								)(iMoData *dest, Bool merge_data, VLONG max_count);
	Bool								(iMoData::*MergeData						)(iMoData *source, Real percent);
	void								(iMoData::*Flush								)();
	void								(iMoData::*SetOffset						)(VLONG offset);
	void								(iMoData::*SetLimit							)(VLONG limit);

	//--------------------------------
	//For AutoAlloc
	iMoData* (*Alloc)();
	void (*Free)(iMoData *&d);
};

//	--- Internal Stuff
//--------------------------------------------------------

#endif