#include "c4d_basedraw.h"
#include "lib_description.h"



BaseDrawHelp* BaseDrawHelp::Alloc(BaseDraw *bd, BaseDocument *doc)
{
	return C4DOS.Br->BbAlloc(bd,doc);
}

void BaseDrawHelp::Free(BaseDrawHelp *&p)
{
	if (!p) return;
	C4DOS.Br->BbFree(p);
}

void BaseView::GetFrame(LONG *cl, LONG *ct, LONG *cr, LONG *cb)
{
	C4DOS.Bv->GetFrame(this,cl,ct,cr,cb);
}

void BaseView::GetSafeFrame(LONG *from, LONG *to, LONG *horizontal)
{
	C4DOS.Bv->GetSafeFrame(this,from,to,horizontal);
}

void BaseView::GetViewParameter(Vector *offset, Vector *scale, Vector *scale_z)
{
	C4DOS.Bv->GetParameter(this,offset,scale,scale_z);
}

Bool BaseView::TestClipping3D(const Vector &mp, const Vector &rad, const Matrix &mg, Bool *clip2d, Bool *clipz)
{
	return C4DOS.Bv->TestClipping3D(this,mp,rad,mg,clip2d,clipz);
}


LONG BaseDraw::GetFrameScreen(LONG *cl, LONG *ct, LONG *cr, LONG *cb)
{
	return C4DOS.Bv->GetFrameScreen(this,cl,ct,cr,cb);
}

const Matrix4& BaseDraw::GetViewMatrix(LONG n)
{
	return C4DOS.Bv->GetViewMatrix(this,n);
}

ViewportSelect* ViewportSelect::Alloc()
{
	return C4DOS.Bv->VSAlloc();
}

void ViewportSelect::Free(ViewportSelect *&p)
{
	if (!p)
		return;
	C4DOS.Bv->VSFree(p);
}

Bool ViewportSelect::Init(LONG w, LONG h, BaseDraw* bd, BaseObject* op, LONG mode, Bool onlyvisible, LONG flags)
{
	return C4DOS.Bv->VSInitObj(this, w, h, bd, op, mode, onlyvisible, flags);
}

Bool ViewportSelect::Init(LONG w, LONG h, BaseDraw* bd, AtomArray* ar, LONG mode, Bool onlyvisible, LONG flags)
{
	return C4DOS.Bv->VSInitAr(this, w, h, bd, ar, mode, onlyvisible, flags);
}

ViewportPixel* ViewportSelect::GetPixelInfoPoint(LONG x, LONG y)
{
	return C4DOS.Bv->VSGetPixelInfoPoint(this, x, y);
}

ViewportPixel* ViewportSelect::GetPixelInfoPolygon(LONG x, LONG y)
{
	return C4DOS.Bv->VSGetPixelInfoPolygon(this, x, y);
}

ViewportPixel* ViewportSelect::GetPixelInfoEdge(LONG x, LONG y)
{
	return C4DOS.Bv->VSGetPixelInfoEdge(this, x, y);
}

void ViewportSelect::ShowHotspot(EditorWindow *bw, LONG x, LONG y)
{
	C4DOS.Bv->VSShowHotspot(this, bw, x, y);
}

void ViewportSelect::ShowHotspot(EditorWindow *bw, LONG x, LONG y, LONG rad, Bool bRemove)
{
	C4DOS.Bv->VSShowHotspotS(bw, x, y, rad, bRemove);
}

void ViewportSelect::SetBrushRadius(LONG r)
{
	C4DOS.Bv->VSSetBrushRadius(this, r);
}

ViewportPixel* ViewportSelect::GetNearestPoint(BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected, LONG* ignorelist, LONG ignorecnt)
{
	return C4DOS.Bv->VSGetNearestPoint(this, op, x, y, maxrad, onlyselected, ignorelist, ignorecnt);
}

ViewportPixel* ViewportSelect::GetNearestPolygon(BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected, LONG* ignorelist, LONG ignorecnt)
{
	return C4DOS.Bv->VSGetNearestPolygon(this, op, x, y, maxrad, onlyselected, ignorelist, ignorecnt);
}

ViewportPixel* ViewportSelect::GetNearestEdge(BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected, LONG* ignorelist, LONG ignorecnt)
{
	return C4DOS.Bv->VSGetNearestEdge(this, op, x, y, maxrad, onlyselected, ignorelist, ignorecnt);
}

void ViewportSelect::ClearPixelInfo(LONG x, LONG y, UCHAR mask)
{
	C4DOS.Bv->VSClearPixelInfo(this, x, y, mask);
}

Bool ViewportSelect::GetCameraCoordinates(Real x, Real y, Real z, Vector &v)
{
	return C4DOS.Bv->VSGetCameraCoordinates(this, x, y, z, v);
}

Bool ViewportSelect::DrawPolygon(const Vector* p, LONG ptcnt, LONG i, BaseObject* op, Bool onlyvisible)
{
	return C4DOS.Bv->VSDrawPolygon(this, p, ptcnt, i, op, onlyvisible);
}

Bool ViewportSelect::DrawHandle(const Vector& p, LONG i, BaseObject* op, Bool onlyvisible)
{
	return C4DOS.Bv->VSDrawHandle(this, p, i, op, onlyvisible);
}

Bool ViewportSelect::PickObject(BaseDraw* bd, BaseDocument* doc, LONG x, LONG y, LONG rad, Bool allowOpenGL, LassoSelection* ls, C4DObjectList* list)
{
	return C4DOS.Bv->VSPickObject(bd, doc, x, y, rad, allowOpenGL, ls, list);
}

GeData BaseDraw::GetParameterData(LONG id)
{
	GeData t_data;
	BaseList2D::GetParameter(DescLevel(id),t_data,0);
	return t_data;
}
