/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __GE_MATH_H
#define __GE_MATH_H

#if defined __MAC
	#include "ge_mac_math.h"
#elif defined __PC
	#include "ge_win_math.h"
#elif defined __LINUX
	#include "ge_lx_math.h"
#else
	#error "Unsupported OS"
#endif

#ifndef GCC34T
	#define GCC34T
#endif

typedef UCHAR PIX;
typedef UCHAR PIX_C;
typedef UWORD PIX_W;
typedef SReal PIX_F;

Real RepairFloat(Real r);
LReal RepairFloat(LReal r);
Bool CompareFloatTolerant(Real a, Real b);

#define C4D_FOUR_BYTE(x1,x2,x3,x4)	( (x1<<24) | (x2<<16) | (x3<<8) | x4 )
#define	C4D_RESERVE_PRIVATE( size )	LONG	priv[(( size ) + 3 ) / 4]

#endif