/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DTHREAD_KEYS_H
#define	__C4DTHREAD_KEYS_H

#include "ge_math.h"

#ifdef __PC

typedef unsigned long	GeThreadVariableKey;

// no inlines because we get to many conflicts with Windows headers
extern GeThreadVariableKey	GeCreateThreadVariable( void );
extern Bool	GeDeleteThreadVariable( GeThreadVariableKey key );
extern void	*GeGetThreadVariable( GeThreadVariableKey key );
extern Bool	GeSetThreadVariable( GeThreadVariableKey key, void *value );

#else

#include <pthread.h>
typedef pthread_key_t	GeThreadVariableKey;

inline GeThreadVariableKey	GeCreateThreadVariable( void )
{
	GeThreadVariableKey	key;
	
	if ( pthread_key_create( &key, NULL ) == 0 )
		return key;
	
	return NULL;
}

inline Bool	GeDeleteThreadVariable( GeThreadVariableKey key )
{
	return pthread_key_delete( key ) == 0;
}

// if no value has been set for the key, this function returns NULL
inline void	*GeGetThreadVariable( GeThreadVariableKey key )
{
	return (void *) pthread_getspecific( key );
}

inline Bool	GeSetThreadVariable( GeThreadVariableKey key, void *value )
{
	return pthread_setspecific( key, value ) == 0;
}

#endif
#endif