#ifndef _C4D_BASELINK_ARRAY_H_
#define _C4D_BASELINK_ARRAY_H_

#ifdef __API_INTERN__
	#include "c4d_alias.h"
	#define BaseLink AliasLink
#endif

#include "ge_mtools.h"
#include "ge_autoptr.h"

class BaseLinkArray : public GeTempDynArray<BaseLink>
{
	public:

		~BaseLinkArray()
		{
			FlushAll();
		}

		void FlushAll()
		{
			BaseLink *c; LONG i;

			for (i = 0; i < GetCount(); ++i)
			{
				c = GeTempDynArray<BaseLink>::GetIndex(i); if (!c) continue;
				BaseLink::Free(c);
			}
			FlushThis();
		}

		LONG Find(C4DAtomGoal *bl,BaseDocument *doc) const
		{
			LONG i;
			for (i=0;i<GetCount();i++)
			{
				BaseLink *l = GeTempDynArray<BaseLink>::GetIndex(i); if (!l) continue;
				C4DAtomGoal *b = l->GetLink(doc); if (!b) continue;
				if (b==bl)
					return i;
			}
			return NOTOK;
		}

		BaseLink *GetIndexLink(LONG i) const
		{
			return GeTempDynArray<BaseLink>::GetIndex(i);
		}

		C4DAtomGoal *GetIndex(LONG i,BaseDocument *doc) const
		{
			BaseLink *l = GeTempDynArray<BaseLink>::GetIndex(i); if (!l) return NULL;
			return l->GetLinkAtom(doc);
		}

		BaseList2D *GetIndexBl(LONG i,BaseDocument *doc,LONG instanceof=Tbaselist2d) const
		{
			BaseLink *l = GeTempDynArray<BaseLink>::GetIndex(i); if (!l) return NULL;
			return (BaseList2D*)l->GetLinkAtom(doc,instanceof);
		}

		Bool Remove(LONG n)
		{
			BaseLink *l = GeTempDynArray<BaseLink>::GetIndex(n);
			if (l) BaseLink::Free(l);
			return GeTempDynArray<BaseLink>::Remove(n);
		}

		Bool Append(C4DAtomGoal *bl)
		{
			BaseLink *l = BaseLink::Alloc(); if (!l) return FALSE;
			l->SetLink(bl);
			return GeTempDynArray<BaseLink>::Append(l);
		}

		LONG GetRealCount(BaseDocument *doc) const
		{
			LONG realcnt=0;
			LONG i,cnt = GetCount();
			for (i=0;i<cnt;i++)
			{
				C4DAtomGoal *bl = GetIndex(i,doc);
				if (bl) realcnt++;
			}
			return realcnt;
		}

		void GetAtomArray(BaseDocument *doc, AtomArray &res) const
		{
			LONG i,cnt = GetCount();
			for (i=0;i<cnt;i++)
			{
				C4DAtomGoal *bl = GetIndex(i,doc);
				if (bl) res.Append(bl);
			}
		}
};

#endif
