/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef	__X4D_FETCH_PIXEL_UTILS__
#define	__X4D_FETCH_PIXEL_UTILS__

#include "x4d_filter.h"

typedef	struct PIXEL_ROOT	*PIXEL_REF;

PIXEL_REF new_pixel_fetcher( BM_REF bm, LONG tile_flags, LONG no_cached_tiles );
void delete_pixel_fetcher( PIXEL_REF pf );
UCHAR *pf_get_pixel_addr( PIXEL_REF pf, LONG x, LONG y );

Bool pf_get_pixel( PIXEL_REF pf, LONG x, LONG y, PIX_C *dst );
Bool pf_get_pixel( PIXEL_REF pf, LONG x, LONG y, PIX_W *dst );
Bool pf_get_pixel( PIXEL_REF pf, LONG x, LONG y, PIX_F *dst );

Bool pf_get_pixel_bilinear( PIXEL_REF pf, Real fx, Real fy, PIX_C *pixel );
Bool pf_get_pixel_bilinear( PIXEL_REF pf, Real fx, Real fy, PIX_W *pixel );
Bool pf_get_pixel_bilinear( PIXEL_REF pf, Real fx, Real fy, PIX_F *pixel );

UCHAR	bilinear8( Real x, Real y, UCHAR *values );
UWORD	bilinear16( Real x, Real y, UWORD *values );
Real	bilinear_double( Real x, Real y, Real *values );


#endif