#include "c4d_library.h"
#include "c4d_gedata.h"
#include "c4d_string.h"
#include "lib_layershader.h"

LayerShaderLib* lib_layershader = NULL;


static LayerShaderLib *CheckLibNoise(LONG offset)
{
	return (LayerShaderLib*)CheckLib(LAYER_SHADER_LIB, offset, (C4DLibrary**)&lib_layershader);
}

#define LayerShaderLibCall(b) 		LayerShaderLib *lib = CheckLibNoise(LIBOFFSET(LayerShaderLib, b)); \
															if (!lib || !lib->b) return; \
															(((BlendLayer*)this)->*(lib->b))

#define LayerShaderLibCallR(a,b)  LayerShaderLib *lib = CheckLibNoise(LIBOFFSET(LayerShaderLib, b)); \
															if (!lib || !lib->b) return a; \
															return (((BlendLayer*)this)->*(lib->b))

LayerShaderLayer* LayerShaderLayer::GetNext()
{
	LayerShaderLibCallR(NULL, GetNext)();
}

LayerType LayerShaderLayer::GetType()
{
	LayerShaderLibCallR(TypeUnknown, GetType)();
}

String LayerShaderLayer::GetName(BaseDocument* doc)
{
	LayerShaderLibCallR(String(), GetName)(doc);
}

BaseBitmap* LayerShaderLayer::GetPreview()
{
	LayerShaderLibCallR(NULL, GetPreview)();
}

Bool LayerShaderLayer::GetParameter(LONG id, GeData &d)
{
	LayerShaderLibCallR(FALSE, GetParameter)(id, d);
}

Bool LayerShaderLayer::SetParameter(LONG id, const GeData &d)
{
	LayerShaderLibCallR(FALSE, SetParameter)(id, d);
}

LayerShaderLayer* LayerShader::GetFirstLayer()
{
	LayerShaderLib *lib = CheckLibNoise(LIBOFFSET(LayerShaderLib, GetNext)); 
  if (!lib) return NULL;
	return lib->GetFirstLayer((PluginShader*)this);
}
