/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4D_BITMAPFILTERSTRUCT_H
#define __C4D_BITMAPFILTERSTRUCT_H

struct BM_TILE;
struct BM_INFO;
typedef BM_INFO *BM_REF;
struct RECT32;
typedef LONG	PROGRESS_ID;

struct C4D_BitmapFilter
{
	BM_TILE*    (*BitmapTileGet       )(BM_REF bm, const RECT32 *src_rect, LONG width, LONG height, LONG tile_mode, LONG flags, LONG unused);
	LONG        (*BitmapTileDetach    )(BM_REF bm, BM_TILE *tile_buf, LONG flags);
	Bool        (*ConvertTileToBasebmp)(const BM_TILE *tile, const RECT32 *tile_rect, BaseBitmap *bmp, LONG zero);

	LONG        (*DiscardChanges      )(BM_REF bm);
	LONG        (*UpdateView          )(BM_REF bm);

	PROGRESS_ID	(*ProgressNewEx       )(void);
	LONG        (*ProgressDeleteEx    )(PROGRESS_ID pid);
	LONG        (*ProgressUpdateEx    )(PROGRESS_ID pid, LONG current_value, LONG max_value, const String *text);

	Bool				(*GetGlobalFilterPrefs)(BaseContainer *prefs);
	Bool        (*SetGlobalFilterPrefs)(const BaseContainer *prefs);

	void*				(*GetEditorWindow     )(void);					// returns the hwnd of the editor window
	Bool				(*IsHostWindow        )(void *win);			// check if the hwnd is one of cinema windows
	Bool        (*Mac_hostProcessEvent)(void *event);		// call mac event proc, return TRUE programm should stop

	PROGRESS_ID	(*ProgressNew         )(BM_REF bm);
	LONG        (*ProgressDelete      )(BM_REF bm, PROGRESS_ID pid);
	LONG        (*ProgressUpdate      )(BM_REF bm, PROGRESS_ID pid, LONG current_value, LONG max_value, const String *text);
};

#endif
