#include "c4d_commandplugin.h"
#include "c4d_memory.h"
#include "c4d_basebitmap.h"
#include "c4d_file.h"
#include "c4d_general.h"
#include "c4d_gui.h"

Bool CommandData::Execute(BaseDocument *doc)
{
	return TRUE;
}

LONG CommandData::GetState(BaseDocument *doc)
{
	return CMD_ENABLED;
}

Bool CommandData::RestoreLayout(void *secret)
{
	return TRUE;
}

Bool CommandData::Message(LONG type, void *data)
{
	return TRUE;
}

String CommandData::GetScriptName(void)
{
	return String();
}

Bool CommandData::ExecuteSubID(BaseDocument *doc, LONG subid)
{
	return FALSE;
}

Bool CommandData::GetSubContainer(BaseDocument *doc, BaseContainer &submenu)
{
	return FALSE;
}

Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, String iconname, const String &help, CommandData *dat)
{
	if (!dat) return FALSE;

	Bool ok=FALSE;

	if (iconname.Content())
	{
		AutoAlloc<BaseBitmap> icon;
		if (icon && icon->Init(GeGetPluginPath()+String("res")+iconname)==IMAGE_OK)
			ok=RegisterCommandPlugin(id,str,info,icon,help,dat);
	}
	else
		ok=RegisterCommandPlugin(id,str,info,NULL,help,dat);

	return ok;
}

Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, BaseBitmap *icon, const String &help, CommandData *dat)
{
	if (!dat) return FALSE;

	COMMANDPLUGIN np;
	ClearMem(&np,sizeof(np));

	np.adr						= dat;
	np.help						= (String*)&help;
	np.command_icon		= icon;
	np.info						= info;
	np.Destructor			= &CommandData::Destructor;
	np.Execute				= &CommandData::Execute;
	np.GetState				= &CommandData::GetState;
	np.RestoreLayout	= &CommandData::RestoreLayout;
	np.Message				= &CommandData::Message;
	np.GetScriptName  = &CommandData::GetScriptName;
	np.GetSubContainer= &CommandData::GetSubContainer;
	np.ExecuteSubID   = &CommandData::ExecuteSubID;

	return GeRegisterPlugin(C4DPL_COMMAND,id,str,&np,sizeof(np));
}

Bool RegisterManagerInformation(LONG id, const String &str, LONG info)
{
	MANAGERINFORMATION np;
	ClearMem(&np,sizeof(np));

	np.adr						= NULL;
	np.info						= info;

	return GeRegisterPlugin(C4DPL_MANAGERINFORMATION,id,str,&np,sizeof(np));
}