/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef	__X4D_FETCH_LINE_UTILS__
#define	__X4D_FETCH_LINE_UTILS__

#include "c4d_general.h"
#include "c4d_memory.h"
#include "c4d_gui.h"

#include "x4d_filter.h"
#include "c4d_bitmapfilter.h"

typedef	struct ROW_ROOT	*ROW_REF;

#define	ROW_FETCH_UPDATE_VIEW		0x0001											// update view when destination tiles are detached

extern ROW_REF	new_row_fetcher( BM_REF bm, LONG x1, LONG x2, LONG tile_flags, LONG tile_mode, BM_TILE *static_tile, LONG update_flags = ROW_FETCH_UPDATE_VIEW );
extern void			delete_row_fetcher( ROW_REF rr, Bool discard_all );
extern UCHAR		*rf_get_bitmap_row( ROW_REF rr, LONG y );
extern void			rf_free_bitmap_row( ROW_REF rr, LONG y );

extern ROW_REF	new_column_fetcher( BM_REF bm, LONG y1, LONG y2, LONG tile_flags, LONG tile_mode, BM_TILE *static_tile, LONG update_flags = ROW_FETCH_UPDATE_VIEW );
extern void			delete_column_fetcher( ROW_REF rr, Bool discard_all );
extern UCHAR		*rf_get_bitmap_column( ROW_REF rr, LONG x, LONG *pixel_offset );
extern void			rf_free_bitmap_column( ROW_REF rr, LONG x );

void premultiply_alpha( UCHAR *buf, LONG width, LONG no_components, LONG pixel_offset );
void premultiply_alpha( UWORD *buf, LONG width, LONG no_components, LONG pixel_offset );
void premultiply_alpha( SReal *buf, LONG width, LONG no_components, LONG pixel_offset );
void separate_alpha( UCHAR *buf, LONG width, LONG no_components, LONG pixel_offset );
void separate_alpha( UWORD *buf, LONG width, LONG no_components, LONG pixel_offset );
void separate_alpha( SReal *buf, LONG width, LONG no_components, LONG pixel_offset, SReal clip = 1e-6 );

#endif
