/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DBASEMATERIAL_H
#define __C4DBASEMATERIAL_H

#include "operatingsystem.h"
#include "c4d_baselist.h"

#define MatCall(fnc) (this->*C4DOS.Mt->fnc)

class BaseMaterial : public BaseList2D
{
	private:
		BaseMaterial();
		~BaseMaterial();
	public:
		BaseMaterial *GetNext(void) { return (BaseMaterial*)AtCall(GetNext)(); }
		BaseMaterial *GetPred(void) { return (BaseMaterial*)AtCall(GetPred)(); }

		void Update(Bool preview, Bool rttm);

		BaseChannel	  *GetChannel(LONG id) { return C4DOS.Mt->GetChannel(this,id); }
		BaseBitmap		*GetPreview(LONG flags);

		Bool Compare(BaseMaterial *snd);

		Vector GetAverageColor(LONG channel=NOTOK);

		void Displace(VolumeData *sd) { MatCall(Displace)(sd); }
		void ChangeNormal(VolumeData *sd) { MatCall(ChangeNormal)(sd); }
		void CalcSurface(VolumeData *sd) { MatCall(CalcSurface)(sd); }
		void CalcTransparency(VolumeData *sd) { MatCall(CalcTransparency)(sd); }
		void CalcAlpha(VolumeData *sd) { MatCall(CalcAlpha)(sd); }
		void CalcVolumetric(VolumeData *sd) { MatCall(CalcVolumetric)(sd); }
		void InitCalculation(VolumeData *sd, LONG type) { MatCall(InitCalculation)(sd,type); }
		LONG GetRenderInfo(void) { return MatCall(GetRenderInfo)(); }
		LONG GlMessage(LONG type, void *data=NULL) { return MatCall(GlMessage)(type, data); }

		static BaseMaterial *Alloc(LONG type);
		static void Free(BaseMaterial *&mat);
};

class PluginMaterial : public BaseMaterial
{
	private:
		PluginMaterial();
		~PluginMaterial();
	public:
		static PluginMaterial *Alloc(LONG type);
		static void Free(PluginMaterial *&mat);
};

class Material : public BaseMaterial
{
	private:
		Material();
		~Material();
	public:
		Bool GetChannelState(LONG channel) { return C4DOS.Mt->GetChannelState(this,channel); }
		void SetChannelState(LONG channel, Bool state) { C4DOS.Mt->SetChannelState(this,channel,state); }

		static Material *Alloc();
		static void Free(Material *&mat);
};

#endif
