#include "c4d_string.h"
#include "c4d_memory.h"

CHAR* String::GetCStringCopy(StringEncoding type) const
{
	LONG len = C4DOS.St->GetCStringLen(this,type);
	if (!len) return 0;

	CHAR *txt = (CHAR*)GeAlloc(len+2);
	if (!txt) return NULL;

	C4DOS.St->GetCString(this,txt,len+2,type);
	txt[len] = 0;

	return txt;
}

const String LongToString(LONG l)
{
	String str,*s=C4DOS.St->LongToString(l);
	if (s) str=*s;
	FreeString(s);
	return str;
}

const String LLongToString(LLONG l)
{
	String str;
	C4DOS.St->LLongToString(l,&str);
	return str;
}

const String RealToString(Real v, LONG vvk, LONG nnk, Bool e, UWORD xchar)
{
	String str,*s=C4DOS.St->RealToString(v,vvk,nnk,e,xchar);
	if (s) str=*s;
	FreeString(s);
	return str;
}

#if (defined _DEBUG) && (defined __PC)
static CHAR array[1000];

CHAR *cstr(String &str)
{
	str.GetCString(array,1000);
	return array;
}

CHAR *cstr(const String &str)
{
	str.GetCString(array,1000);
	return array;
}

#include "c4d_baselist.h"

CHAR *cstr(GeListNode *node)
{
	if (node->IsInstanceOf(Tbaselist2d))
		((BaseList2D*)node)->GetName().GetCString(array,1000);
	else
		strcpy(array,"no baselist");
	return array;
}

#include "c4d_file.h"

CHAR *cstr(Filename &fn)
{
	fn.GetString().GetCString(array,1000);
	return array;
}

CHAR *cstr(const Filename &fn)
{
	fn.GetString().GetCString(array,1000);
	return array;
}

#endif


String PtrToString(void *t_hex)
{
	VLONG hex = (VLONG)t_hex;
	CHAR hexstring[sizeof(VULONG)*2+4];
	LONG t,i;

	t = 0;
	hexstring[t++] = '0';
	hexstring[t++] = 'x';

	for (i=sizeof(VULONG)*8-4; i>=0; i-=4)
	{
		VULONG x = ((hex>>i)&0xF);
		if (x<10) hexstring[t++] = x+'0';
		else hexstring[t++] = x-10+'A';
	}
	hexstring[t]=0;
	return String(hexstring);
}

String MemoryToString(LLONG mem)
{
	if (mem>1024*1024*1024)
		return RealToString(Real(mem >> 20)/1024,0,2)+String(" GB");
	else if (mem>1024*1024)
		return RealToString(Real(mem >> 10)/1024,0,2)+String(" MB");
	else if (mem>1024)
		return RealToString(Real(mem)/(1024),0,2)+String(" KB");

	return LongToString(mem)+String(" B");
}
