#include "ge_lvector.h"
#include "ge_lmatrix.h"

#include "c4d_file.h"
#include "c4d_memory.h"
#include "c4d_basecontainer.h"
#include "c4d_basebitmap.h"
#include "c4d_basechannel.h"
#include "c4d_general.h"

#ifdef	__C4D_NO_NEW_DELETE__
void* Filename::operator new(size_t,const std::nothrow_t&,int line,const CHAR *file) throw()
{
	return C4DOS.Fn->Alloc();
}

void Filename::operator delete(void* del,int line, const CHAR *file)
{
	C4DOS.Fn->Free((Filename*)del);
}

void Filename::operator delete(void* del)
{
	C4DOS.Fn->Free((Filename*)del);
}
#endif

Filename::Filename(void)
{
	C4DOS.Fn->Init(this);
}

Filename::Filename(const CHAR *string)
{
	C4DOS.Fn->Init(this);
	C4DOS.Fn->SetCString(this,string);
}

Filename::Filename(const String &string)
{
	C4DOS.Fn->Init(this);
	C4DOS.Fn->SetString(this,&string);
}

Filename::Filename(const Filename &src)
{
	C4DOS.Fn->Init(this);	
	C4DOS.Fn->CopyTo(&src,this);
}

Filename::~Filename(void)
{
	C4DOS.Fn->Flush(this);
}

void Filename::CopyTo(Filename *dst) const
{
	C4DOS.Fn->CopyTo(this,dst);
}

Filename *Filename::GetClone(void) const
{
 	return C4DOS.Fn->GetClone(this);
}

Bool Filename::FileSelect(LONG type, LONG flags, const String *title)
{
	return C4DOS.Fn->FileSelect(this,type,flags,title);
}

Bool Filename::FileSelect(LONG type, LONG flags, const String &title)
{
	return C4DOS.Fn->FileSelect(this,type,flags,&title);
}

Bool Filename::Content(void) const
{
	return C4DOS.Fn->Content(this);
}

String Filename::GetString(void) const
{
	String s,*str=C4DOS.Fn->GetString(this);
	if (str)
	{
		str->CopyTo(&s);
		FreeString(str);
	}
	return s;
}

void Filename::SetString(const String &str)
{
	C4DOS.Fn->SetString(this,&str);
}

Filename Filename::GetDirectory(void) const
{
	Filename f,*fn=C4DOS.Fn->GetDirectory(this);
	if (fn) f=*fn;
	FreeFilename(fn);
	return f;
}

Filename Filename::GetFile(void) const
{
	Filename f,*fn=C4DOS.Fn->GetFile(this);
	if (fn) f=*fn;
	FreeFilename(fn);
	return f;
}

String Filename::GetFileString(void) const
{
	return GetFile().GetString();
}

void Filename::ClearSuffix(void)
{
	C4DOS.Fn->ClearSuffix(this);
}

void Filename::ClearSuffixComplete(void)
{
	C4DOS.Fn->ClearSuffixComplete(this);
}

void Filename::SetSuffix(const String &str)
{
	C4DOS.Fn->SetSuffix(this,&str);
}

Bool Filename::CheckSuffix(const String &str) const
{
	return C4DOS.Fn->CheckSuffix(this,&str);
}

void Filename::SetDirectory(const Filename &str)
{
	C4DOS.Fn->SetDirectory(this,&str);
}

void Filename::SetFile(const Filename &str)
{
	C4DOS.Fn->SetFile(this,&str);
}

const Filename& Filename::operator = (const Filename &cs)
{
	C4DOS.Fn->CopyTo(&cs,this);
	return *this;
}

const Filename operator + (const Filename &Str1,const Filename &Str2)
{
	Filename fn = Str1;
	C4DOS.Fn->Add(&fn,&Str2);
	return fn;
}

const Filename& Filename::operator += (const Filename &Str)
{
	C4DOS.Fn->Add(this,&Str);
	return *this;
}

Bool Filename::operator == (const Filename &Str) const
{
	return C4DOS.Fn->Compare(this,&Str);
}

Bool Filename::operator != (const Filename &Str) const
{
	return !C4DOS.Fn->Compare(this,&Str);
}

void FreeFilename(Filename *&fn)
{
	if (fn) C4DOS.Fn->Free(fn);
	fn=NULL;
}

void Filename::SetMemoryReadMode(void *adr, VLONG size)
{
	C4DOS.Fn->SetMemoryReadMode(this, adr, size);
}

void Filename::SetMemoryWriteMode(MemoryFileStruct *mfs)
{
	C4DOS.Fn->SetMemoryWriteMode(this, mfs);
}

MemoryFileStruct* MemoryFileStruct::Alloc()
{
	return C4DOS.Fn->MemoryFileStructAlloc();
}

void MemoryFileStruct::Free(MemoryFileStruct *&mfs)
{
	C4DOS.Fn->MemoryFileStructFree(mfs);
}

void MemoryFileStruct::GetData(void *&data, VLONG &size, Bool release)
{
	C4DOS.Fn->MemoryFileStructGetData(this, data, size, release);
}


BaseFile *BaseFile::Alloc(void)
{
	return C4DOS.Fl->Alloc();
}

void BaseFile::Free(BaseFile *&fl)
{
	C4DOS.Fl->Free(fl);
	fl=NULL;
}

Bool BaseFile::Open(const Filename &name, LONG mode, LONG error_dialog, LONG order, LONG type, LONG creator)
{
	return C4DOS.Fl->Open(this,&name,mode,error_dialog,order,type,creator);
}

Bool BaseFile::Close(void)
{
	return C4DOS.Fl->Close(this);
}

void BaseFile::SetOrder(LONG order)
{
	C4DOS.Fl->SetOrder(this,order);
}

VLONG BaseFile::ReadBytes(void *data, VLONG len, Bool just_try_it)
{
	return C4DOS.Fl->ReadBytes(this,data,len,just_try_it);
}

Bool BaseFile::WriteBytes(const void *data, VLONG len)
{
	return C4DOS.Fl->WriteBytes(this,data,len);
}

VLONG BaseFile::TryReadBytes(void *data, VLONG len)
{
	return C4DOS.Fl->ReadBytes(this,data,len,TRUE);
}

Bool BaseFile::Seek(VLONG pos, LONG mode)
{
	return C4DOS.Fl->Seek(this,pos,mode);
}

VLONG BaseFile::GetPosition(void)
{
	return C4DOS.Fl->GetPosition(this);
}

VLONG BaseFile::GetLength(void)
{
	return C4DOS.Fl->GetLength(this);
}

LONG BaseFile::GetError(void)
{
	return C4DOS.Fl->GetError(this);
}

void BaseFile::SetError(LONG error)
{
	C4DOS.Fl->SetError(this,error);
}

Bool BaseFile::ReadChar (CHAR *v)
{
	return C4DOS.Fl->ReadChar(this,v);
}

Bool BaseFile::ReadUChar(UCHAR *v)
{
	return C4DOS.Fl->ReadUChar(this,v);
}

Bool BaseFile::ReadWord (SWORD *v)
{
	return C4DOS.Fl->ReadWord(this,v);
}

Bool BaseFile::ReadUWord(UWORD *v)
{
	return C4DOS.Fl->ReadUWord(this,v);
}

Bool BaseFile::ReadLong (LONG  *v)
{
	return C4DOS.Fl->ReadLong(this,v);
}

Bool BaseFile::ReadLLong(LLONG *v)
{
	return C4DOS.Fl->ReadLLong(this,v);
}

Bool BaseFile::ReadULong(ULONG *v)
{
	return C4DOS.Fl->ReadULong(this,v);
}

Bool BaseFile::ReadReal (Real  *v)
{
	return C4DOS.Fl->ReadReal(this,v);
}

Bool BaseFile::ReadLReal(LReal *v)
{
	return C4DOS.Fl->ReadLReal(this,v);
}

Bool BaseFile::ReadString(String *v)
{
	LONG  len=0;
	CHAR	*c = NULL;

	if (!ReadLong(&len)) return FALSE;
	if (!len) { *v=String(); return TRUE; }

	c = (CHAR*) GeAlloc(sizeof(CHAR)*len);
	if (!c)
	{
		SetError(FILEERROR_MEMORY);
		return FALSE;
	}
	if (!ReadBytes(c,len))
	{
		GeFree(c);
		return FALSE;
	}

	v->SetCString(c,len-1);
	GeFree(c);

	return TRUE;
}

Bool BaseFile::ReadFilename(Filename *v)
{
	String str;
	if (!ReadString(&str)) return FALSE;
	v->SetString(str);
	return TRUE;
}

Bool BaseFile::ReadBool(Bool *v)
{
	CHAR c;
	if (!ReadChar(&c)) return FALSE;
	*v = c!=0;
	return TRUE;
}

Bool BaseFile::ReadTime(BaseTime *v)
{
	return ReadReal(&v->nominator) && ReadReal(&v->denominator);
}

Bool BaseFile::ReadVector(Vector *v)
{
	return ReadReal(&v->x) && ReadReal(&v->y) && ReadReal(&v->z);
}

Bool BaseFile::ReadLVector(LVector *v)
{
	return ReadLReal(&v->x) && ReadLReal(&v->y) && ReadLReal(&v->z);
}

Bool BaseFile::ReadMatrix(Matrix *v)
{
	return ReadVector(&v->off) && ReadVector(&v->v1) && ReadVector(&v->v2) && ReadVector(&v->v3);
}

Bool BaseFile::ReadLMatrix(LMatrix *v)
{
	return ReadLVector(&v->off) && ReadLVector(&v->v1) && ReadLVector(&v->v2) && ReadLVector(&v->v3);
}

Bool BaseFile::WriteBool(Bool v)
{
	return WriteChar(CHAR(v!=0));
}

Bool BaseFile::WriteTime(const BaseTime &v)
{
	return WriteReal(v.nominator) && WriteReal(v.denominator);
}

Bool BaseFile::WriteVector(const Vector  &v)
{
	return WriteReal(v.x) && WriteReal(v.y) && WriteReal(v.z);
}

Bool BaseFile::WriteLVector(const LVector &v)
{
	return WriteLReal(v.x) && WriteLReal(v.y) && WriteLReal(v.z);
}

Bool BaseFile::WriteMatrix(const Matrix  &v)
{
	return WriteVector(v.off) && WriteVector(v.v1) && WriteVector(v.v2) && WriteVector(v.v3);
}

Bool BaseFile::WriteLMatrix(const LMatrix  &v)
{
	return WriteLVector(v.off) && WriteLVector(v.v1) && WriteLVector(v.v2) && WriteLVector(v.v3);
}

Bool BaseFile::WriteString(const String &v)
{
	Bool ok;
	LONG len  = v.GetCStringLen()+1;
	CHAR *mem = (CHAR*) GeAlloc(sizeof(CHAR)*len);
	if (!mem)
	{
		SetError(FILEERROR_MEMORY);
		return FALSE;
	}

	v.GetCString(mem,len);
	ok = WriteLong(len) && WriteBytes(mem,len);
	GeFree(mem);

	return ok;
}

Bool BaseFile::WriteFilename(const Filename &v)
{
	return WriteString(v.GetString());
}

Bool BaseFile::WriteChar (CHAR v)
{
	return C4DOS.Fl->WriteChar(this,v);
}

Bool BaseFile::WriteUChar(UCHAR v)
{
	return C4DOS.Fl->WriteUChar(this,v);
}

Bool BaseFile::WriteWord (SWORD v)
{
	return C4DOS.Fl->WriteWord(this,v);
}

Bool BaseFile::WriteUWord(UWORD v)
{
	return C4DOS.Fl->WriteUWord(this,v);
}

Bool BaseFile::WriteLong (LONG v)
{
	return C4DOS.Fl->WriteLong(this,v);
}

Bool BaseFile::WriteLLong(LLONG v)
{
	return C4DOS.Fl->WriteLLong(this,v);
}

Bool BaseFile::WriteULong(ULONG v)
{
	return C4DOS.Fl->WriteULong(this,v);
}

Bool BaseFile::WriteReal(Real v)
{
	return C4DOS.Fl->WriteReal(this,v);
}

Bool BaseFile::WriteLReal(LReal v)
{
	return C4DOS.Fl->WriteLReal(this,v);
}



AESFile *AESFile::Alloc(void)
{
	return C4DOS.Fl->AESAlloc();
}

void AESFile::Free(AESFile *&fl)
{
	C4DOS.Fl->Free((BaseFile*)fl);
	fl=NULL;
}

Bool AESFile::Open(const Filename &name, const char* key, LONG keylen, LONG blocksize, ULONG aes_flags, LONG mode, LONG error_dialog, LONG order, LONG type, LONG creator)
{
	return C4DOS.Fl->AESOpen(this,&name,key,keylen,blocksize,aes_flags,mode,error_dialog,order,type,creator);
}

Bool AESFile::Close(void)
{
	return C4DOS.Fl->Close((BaseFile*)this);
}

void AESFile::SetOrder(LONG order)
{
	C4DOS.Fl->SetOrder((BaseFile*)this,order);
}

VLONG AESFile::ReadBytes(void *data, VLONG len, Bool just_try_it)
{
	return C4DOS.Fl->ReadBytes((BaseFile*)this,data,len,just_try_it);
}

Bool AESFile::WriteBytes(const void *data, VLONG len)
{
	return C4DOS.Fl->WriteBytes((BaseFile*)this,data,len);
}

VLONG AESFile::TryReadBytes(void *data, VLONG len)
{
	return C4DOS.Fl->ReadBytes((BaseFile*)this,data,len,TRUE);
}

Bool AESFile::Seek(VLONG pos, LONG mode)
{
	return C4DOS.Fl->Seek((BaseFile*)this,pos,mode);
}

VLONG AESFile::GetPosition(void)
{
	return C4DOS.Fl->GetPosition((BaseFile*)this);
}

VLONG AESFile::GetLength(void)
{
	return C4DOS.Fl->GetLength((BaseFile*)this);
}

LONG AESFile::GetError(void)
{
	return C4DOS.Fl->GetError((BaseFile*)this);
}

void AESFile::SetError(LONG error)
{
	C4DOS.Fl->SetError((BaseFile*)this,error);
}

Bool AESFile::ReadChar (CHAR *v)
{
	return C4DOS.Fl->ReadChar((BaseFile*)this,v);
}

Bool AESFile::ReadUChar(UCHAR *v)
{
	return C4DOS.Fl->ReadUChar((BaseFile*)this,v);
}

Bool AESFile::ReadWord (SWORD *v)
{
	return C4DOS.Fl->ReadWord((BaseFile*)this,v);
}

Bool AESFile::ReadUWord(UWORD *v)
{
	return C4DOS.Fl->ReadUWord((BaseFile*)this,v);
}

Bool AESFile::ReadLong (LONG  *v)
{
	return C4DOS.Fl->ReadLong((BaseFile*)this,v);
}

Bool AESFile::ReadLLong(LLONG *v)
{
	return C4DOS.Fl->ReadLLong((BaseFile*)this,v);
}

Bool AESFile::ReadULong(ULONG *v)
{
	return C4DOS.Fl->ReadULong((BaseFile*)this,v);
}

Bool AESFile::ReadReal (Real  *v)
{
	return C4DOS.Fl->ReadReal((BaseFile*)this,v);
}

Bool AESFile::ReadLReal(LReal *v)
{
	return C4DOS.Fl->ReadLReal((BaseFile*)this,v);
}

Bool AESFile::ReadString(String *v)
{
	LONG  len=0;
	CHAR	*c = NULL;

	if (!ReadLong(&len)) return FALSE;
	if (!len) { *v=String(); return TRUE; }

	c = (CHAR*) GeAlloc(sizeof(CHAR)*len);
	if (!c)
	{
		SetError(FILEERROR_MEMORY);
		return FALSE;
	}
	if (!ReadBytes(c,len))
	{
		GeFree(c);
		return FALSE;
	}

	v->SetCString(c,len-1);
	GeFree(c);

	return TRUE;
}

Bool AESFile::ReadFilename(Filename *v)
{
	String str;
	if (!ReadString(&str)) return FALSE;
	v->SetString(str);
	return TRUE;
}

Bool AESFile::ReadBool(Bool *v)
{
	CHAR c;
	if (!ReadChar(&c)) return FALSE;
	*v = c!=0;
	return TRUE;
}

Bool AESFile::ReadTime(BaseTime *v)
{
	return ReadReal(&v->nominator) && ReadReal(&v->denominator);
}

Bool AESFile::ReadVector(Vector *v)
{
	return ReadReal(&v->x) && ReadReal(&v->y) && ReadReal(&v->z);
}

Bool AESFile::ReadLVector(LVector *v)
{
	return ReadLReal(&v->x) && ReadLReal(&v->y) && ReadLReal(&v->z);
}

Bool AESFile::ReadMatrix(Matrix *v)
{
	return ReadVector(&v->off) && ReadVector(&v->v1) && ReadVector(&v->v2) && ReadVector(&v->v3);
}

Bool AESFile::ReadLMatrix(LMatrix *v)
{
	return ReadLVector(&v->off) && ReadLVector(&v->v1) && ReadLVector(&v->v2) && ReadLVector(&v->v3);
}

Bool AESFile::WriteBool(Bool v)
{
	return WriteChar(CHAR(v!=0));
}

Bool AESFile::WriteTime(const BaseTime &v)
{
	return WriteReal(v.nominator) && WriteReal(v.denominator);
}

Bool AESFile::WriteVector(const Vector  &v)
{
	return WriteReal(v.x) && WriteReal(v.y) && WriteReal(v.z);
}

Bool AESFile::WriteLVector(const LVector &v)
{
	return WriteLReal(v.x) && WriteLReal(v.y) && WriteLReal(v.z);
}

Bool AESFile::WriteMatrix(const Matrix  &v)
{
	return WriteVector(v.off) && WriteVector(v.v1) && WriteVector(v.v2) && WriteVector(v.v3);
}

Bool AESFile::WriteLMatrix(const LMatrix  &v)
{
	return WriteLVector(v.off) && WriteLVector(v.v1) && WriteLVector(v.v2) && WriteLVector(v.v3);
}

Bool AESFile::WriteString(const String &v)
{
	Bool ok;
	LONG len  = v.GetCStringLen()+1;
	CHAR *mem = (CHAR*) GeAlloc(sizeof(CHAR)*len);
	if (!mem)
	{
		SetError(FILEERROR_MEMORY);
		return FALSE;
	}

	v.GetCString(mem,len);
	ok = WriteLong(len) && WriteBytes(mem,len);
	GeFree(mem);

	return ok;
}

Bool AESFile::WriteFilename(const Filename &v)
{
	return WriteString(v.GetString());
}

Bool AESFile::WriteChar (CHAR v)
{
	return C4DOS.Fl->WriteChar((BaseFile*)this,v);
}

Bool AESFile::WriteUChar(UCHAR v)
{
	return C4DOS.Fl->WriteUChar((BaseFile*)this,v);
}

Bool AESFile::WriteWord (SWORD v)
{
	return C4DOS.Fl->WriteWord((BaseFile*)this,v);
}

Bool AESFile::WriteUWord(UWORD v)
{
	return C4DOS.Fl->WriteUWord((BaseFile*)this,v);
}

Bool AESFile::WriteLong (LONG v)
{
	return C4DOS.Fl->WriteLong((BaseFile*)this,v);
}

Bool AESFile::WriteLLong(LLONG v)
{
	return C4DOS.Fl->WriteLLong((BaseFile*)this,v);
}

Bool AESFile::WriteULong(ULONG v)
{
	return C4DOS.Fl->WriteULong((BaseFile*)this,v);
}

Bool AESFile::WriteReal(Real v)
{
	return C4DOS.Fl->WriteReal((BaseFile*)this,v);
}

Bool AESFile::WriteLReal(LReal v)
{
	return C4DOS.Fl->WriteLReal((BaseFile*)this,v);
}

Bool AESFile::CheckEncryption(const Filename& encrypt, const Filename& decrypt, const char* key, LONG keylen, LONG blocksize)
{
	return C4DOS.Fl->AESCheckEncryption(encrypt, decrypt, key, keylen, blocksize);
}

BrowseVolumes *BrowseVolumes::Alloc()
{
	return C4DOS.Bf->BvAlloc();
}

void BrowseVolumes::Init(void)
{
	(this->*C4DOS.Bf->BvInit)();
}

void BrowseVolumes::Free(BrowseVolumes *&bf)
{
	C4DOS.Bf->BvFree(bf);
	bf=NULL;
}

Bool BrowseVolumes::GetNext(void)
{
	return (this->*C4DOS.Bf->BvGetNext)();
}

Filename BrowseVolumes::GetFilename(void)
{
	return (this->*C4DOS.Bf->BvGetFilename)();
}

String	BrowseVolumes::GetVolumeName( LONG *out_flags )
{
	return (this->*C4DOS.Bf->BvGetVolumeName)( out_flags );
}

BrowseFiles *BrowseFiles::Alloc()
{
	return C4DOS.Bf->Alloc(NULL,0);
}

void BrowseFiles::Init(const Filename &directory, LONG flags)
{
	C4DOS.Bf->Init(this,&directory,flags);
}

void BrowseFiles::Free(BrowseFiles *&bf)
{
	C4DOS.Bf->Free(bf);
	bf=NULL;
}

Bool BrowseFiles::GetNext(void)
{
	return C4DOS.Bf->GetNext(this);
}

VLONG BrowseFiles::GetSize(void)
{
	return C4DOS.Bf->GetSize(this);
}

Bool BrowseFiles::IsDir(void)
{
	return C4DOS.Bf->IsDir(this);
}

Bool BrowseFiles::IsHidden(void)
{
	return (this->*C4DOS.Bf->IsHidden)();
}

Bool BrowseFiles::IsReadOnly(void)
{
	return (this->*C4DOS.Bf->IsReadOnly)();
}

Bool BrowseFiles::IsBundle(void)
{
	return (this->*C4DOS.Bf->IsBundle)();
}

void BrowseFiles::GetFileTime(LONG mode, LocalFileTime *out)
{
	(this->*C4DOS.Bf->GetFileTime)(mode,out);
}

Bool GeGetFileTime(const Filename &name, LONG mode, LocalFileTime *out)
{
	return C4DOS.Bf->GeGetFileTime(name,mode,out);
}

Bool GeSetFileTime(const Filename &name, LONG mode, const LocalFileTime *in)
{
	return C4DOS.Bf->GeSetFileTime(name,mode,in);
}

void GeGetCurrentTime(LocalFileTime *out)
{
	C4DOS.Bf->GeGetCurrentTime(out);
}

Filename BrowseFiles::GetFilename(void)
{
	Filename f,*fn=C4DOS.Bf->GetFilename(this);
	if (fn) f=*fn;
	FreeFilename(fn);
	return f;
}

Bool GeFExist(const Filename &name, Bool isdir)
{
	return C4DOS.Ge->FExist(&name,isdir);
}

Bool GeSearchFile(const Filename &directory, const Filename &name, Filename *found)
{
	return C4DOS.Ge->SearchFile(&directory,&name,found);
}

Bool GeFKill(const Filename &name, LONG flags)
{
	return C4DOS.Ge->FKill(&name,flags);
}

Bool GeFCopyFile(const Filename &source, const Filename &dest, LONG flags)
{
	return C4DOS.Ge->FCopyFile(&source,&dest,flags);
}

Bool GeFRename(const Filename &source, const Filename &dest)
{
	return C4DOS.Ge->FRename(&source,&dest);
}

Bool GeFMove(const Filename &source, const Filename &dest)
{
	return C4DOS.Ge->FMove(source,dest);
}

Bool GeFCreateDir(const Filename &name)
{
	return C4DOS.Ge->FCreateDir(&name);
}

Bool GeFCreateDirRec(const Filename &fn)
{
	Filename parent = fn.GetDirectory();

	if (!parent.Content()) return FALSE;

	if (!GeFExist(parent,TRUE))
	{
		if (!GeFCreateDirRec(parent))
			return FALSE;
	}

	if (!GeFExist(fn,TRUE))
	{
		if (!GeFCreateDir(fn))
		{
			return FALSE;
		}
	}
	return TRUE;
}

Bool GeExecuteFile(const Filename &path)
{
	return C4DOS.Ge->ExecuteFile(&path);
}

Bool GeExecuteProgram(const Filename &program, const Filename &img)
{
	return C4DOS.Ge->ExecuteProgram(&program,&img);
}

Bool GeExecuteProgramEx(const Filename &program, const String *args, LONG argcnt, GeExecuteProgramExCallback callback, void *userdata)
{
	return C4DOS.Ge->GeExecuteProgramEx(program,args,argcnt,callback,userdata);
}

Bool GeFGetDiskFreeSpace(const Filename &vol, LULONG &freecaller, LULONG &total, LULONG &freespace)
{
	return C4DOS.Ge->GeFGetDiskFreeSpace(vol, freecaller, total, freespace);
}

ULONG GeFGetAttributes(const Filename &name)
{
	return C4DOS.Ge->GeFGetAttributes(&name);
}

Bool GeFSetAttributes(const Filename &name, ULONG flags, ULONG mask)
{
	return C4DOS.Ge->GeFSetAttributes(&name, flags, mask);
}


Filename GeGetStartupPath(void)
{
	Filename f,*fn=C4DOS.Ge->GetStartupPath();
	if (fn) f=*fn;
	FreeFilename(fn);
	return f;
}

Filename GeGetStartupApplication(void)
{
	Filename f,*fn=C4DOS.Ge->GetStartupApplication();
	if (fn) f=*fn;
	FreeFilename(fn);
	return f;
}

Bool RequestFileFromServer(const Filename &fn, Filename &res)
{
	return C4DOS.Ge->RequestFileFromServer(fn,res);
}

Filename GeGetPluginPath(void)
{
	extern Filename *path_storage;

	return path_storage ? path_storage->GetDirectory() : Filename();
}

Filename GeGetC4DPath(LONG whichpath)
{
	return C4DOS.Ge->GetC4DPath(whichpath);
}

Filename GeGetStartupWritePath(void)
{
	return GeGetC4DPath(C4D_PATH_STARTUPWRITE);
}



HyperFile *HyperFile::Alloc(void)
{
	return C4DOS.Hf->AllocHF();
}

void HyperFile::Free(HyperFile *&fl)
{
	C4DOS.Hf->FreeHF(fl);
	fl=NULL;
}

Bool HyperFile::Open(const Filename &filename, LONG mode, LONG ident)
{
	return C4DOS.Hf->OpenHF(this,filename,mode,ident);
}

Bool HyperFile::Close()
{
	return C4DOS.Hf->CloseHF(this);
}

BaseDocument* HyperFile::GetDocument(void)
{
	return C4DOS.Hf->GetDocument(this);
}

Bool HyperFile::ReadChar (CHAR *v)
{
	return C4DOS.Hf->ReadChar(this,v);
}

Bool HyperFile::ReadUChar(UCHAR *v)
{
	return C4DOS.Hf->ReadUChar(this,v);
}

Bool HyperFile::ReadWord (SWORD  *v)
{
	return C4DOS.Hf->ReadWord(this,v);
}

Bool HyperFile::ReadUWord(UWORD *v)
{
	return C4DOS.Hf->ReadUWord(this,v);
}

Bool HyperFile::ReadLong (LONG  *v)
{
	return C4DOS.Hf->ReadLong(this,v);
}

Bool HyperFile::ReadULong(ULONG *v)
{
	return C4DOS.Hf->ReadULong(this,v);
}

Bool HyperFile::ReadLLong(LLONG *v)
{
	return C4DOS.Hf->ReadLLong(this,v);
}

Bool HyperFile::ReadReal (Real  *v)
{
	return C4DOS.Hf->ReadReal(this,v);
}

Bool HyperFile::ReadLReal(LReal *v)
{
	return C4DOS.Hf->ReadLReal(this,v);
}

Bool HyperFile::ReadBool(Bool *v)
{
	return C4DOS.Hf->ReadBool(this,v);
}

Bool HyperFile::ReadTime(BaseTime *v)
{
	return C4DOS.Hf->ReadTime(this,v);
}

Bool HyperFile::ReadVector(Vector *v)
{
	return C4DOS.Hf->ReadVector(this,v);
}

Bool HyperFile::ReadLVector(LVector *v)
{
	return C4DOS.Hf->ReadLVector(this,v);
}

Bool HyperFile::ReadMatrix(Matrix *v)
{
	return C4DOS.Hf->ReadMatrix(this,v);
}

Bool HyperFile::ReadLMatrix(LMatrix *v)
{
	return C4DOS.Hf->ReadLMatrix(this,v);
}

Bool HyperFile::ReadString(String *v)
{
	return C4DOS.Hf->ReadString(this,v);
}

Bool HyperFile::ReadFilename(Filename *v)
{
	return C4DOS.Hf->ReadFilename(this,v);
}

Bool HyperFile::ReadGeData(GeData *v)
{
	return C4DOS.Hf->ReadGeData(this,v);
}

Bool HyperFile::ReadContainer(BaseContainer *v, Bool flush)
{
	return C4DOS.Hf->ReadContainer(this,v,flush);
}

Bool HyperFile::ReadMemory(void **data, VLONG *size)
{
	return C4DOS.Hf->ReadMemory(this,data,size);
}

Bool HyperFile::ReadImage(BaseBitmap *v)
{
	return C4DOS.Hf->ReadImage(this,v);
}

Bool HyperFile::ReadChannel(BaseChannel *bc)
{
	return bc && C4DOS.Ba->ReadData(this,bc);
}

Bool HyperFile::ReadChannelConvert(GeListNode *node, LONG link_id)
{
	return C4DOS.Ba->ReadDataConvert(node,link_id,this);
}

Bool HyperFile::WriteChannel(BaseChannel *bc)
{
	if (!bc) return FALSE;
	C4DOS.Ba->WriteData(this,bc);
	return TRUE;
}

Bool HyperFile::WriteChar (CHAR v)
{
	return C4DOS.Hf->WriteChar(this,v);
}

Bool HyperFile::WriteUChar(UCHAR v)
{
	return C4DOS.Hf->WriteUChar(this,v);
}

Bool HyperFile::WriteWord (SWORD v)
{
	return C4DOS.Hf->WriteWord(this,v);
}

Bool HyperFile::WriteUWord(UWORD v)
{
	return C4DOS.Hf->WriteUWord(this,v);
}

Bool HyperFile::WriteLong (LONG v)
{
	return C4DOS.Hf->WriteLong(this,v);
}

Bool HyperFile::WriteULong(ULONG v)
{
	return C4DOS.Hf->WriteULong(this,v);
}

Bool HyperFile::WriteLLong(LLONG v)
{
	return C4DOS.Hf->WriteLLong(this,v);
}

Bool HyperFile::WriteReal(Real v)
{
	return C4DOS.Hf->WriteReal(this,v);
}

Bool HyperFile::WriteLReal(LReal v)
{
	return C4DOS.Hf->WriteLReal(this,v);
}

Bool HyperFile::WriteBool(Bool v)
{
	return C4DOS.Hf->WriteBool(this,v);
}

Bool HyperFile::WriteTime(const BaseTime &v)
{
	return C4DOS.Hf->WriteTime(this,v);
}

Bool HyperFile::WriteVector(const Vector &v)
{
	return C4DOS.Hf->WriteVector(this,v);
}

Bool HyperFile::WriteLVector(const LVector &v)
{
	return C4DOS.Hf->WriteLVector(this,v);
}

Bool HyperFile::WriteMatrix(const Matrix &v)
{
	return C4DOS.Hf->WriteMatrix(this,v);
}

Bool HyperFile::WriteLMatrix(const LMatrix &v)
{
	return C4DOS.Hf->WriteLMatrix(this,v);
}

Bool HyperFile::WriteString(const String &v)
{
	return C4DOS.Hf->WriteString(this,&v);
}

Bool HyperFile::WriteFilename(const Filename &v)
{
	return C4DOS.Hf->WriteFilename(this,&v);
}

Bool HyperFile::WriteImage(BaseBitmap *v, LONG format, BaseContainer *data, LONG savebits)
{
	return C4DOS.Hf->WriteImage(this,v,format,data,savebits);
}

Bool HyperFile::WriteContainer(const BaseContainer &v)
{
	return C4DOS.Hf->WriteContainer(this,&v);
}

Bool HyperFile::WriteGeData(const GeData &v)
{
	return C4DOS.Hf->WriteGeData(this,v);
}

Bool HyperFile::WriteMemory(void *data, VLONG count)
{
	return C4DOS.Hf->WriteMemory(this,data,count);
}

LONG HyperFile::GetError(void)
{
	return C4DOS.Hf->GetError(this);
}

void HyperFile::SetError(LONG err)
{
	C4DOS.Hf->SetError(this,err);
}

Bool HyperFile::ReadValueHeader(UCHAR *h)
{
	return C4DOS.Hf->ReadValueHeader(this,h);
}

Bool HyperFile::SkipValue(UCHAR h)
{
	return C4DOS.Hf->SkipValue(this,h);
}

Bool HyperFile::WriteChunkStart(LONG id, LONG level)
{
	return C4DOS.Hf->WriteChunkStart(this,id,level);
}

Bool HyperFile::WriteChunkEnd(void)
{
	return C4DOS.Hf->WriteChunkEnd(this);
}

Bool HyperFile::ReadChunkStart(LONG *id, LONG *level)
{
	return C4DOS.Hf->ReadChunkStart(this,id,level);
}

Bool HyperFile::ReadChunkEnd(void)
{
	return C4DOS.Hf->ReadChunkEnd(this);
}

Bool HyperFile::SkipToEndChunk(void)
{
	return C4DOS.Hf->SkipToEndChunk(this);
}

LONG HyperFile::GetFileVersion(void)
{
	return C4DOS.Hf->GetFileVersion(this);
}

LONG ReadHyperFile(BaseDocument *doc, GeListNode *node, const Filename &filename, LONG ident, String *warning_string)
{
	return C4DOS.Hf->ReadFile(doc,node,filename,ident,warning_string);
}

LONG WriteHyperFile(BaseDocument *doc, GeListNode *node, const Filename &filename, LONG ident)
{
	return C4DOS.Hf->WriteFile(doc,node,filename,ident);
}

String DateToString(const LocalFileTime &t, Bool date_only)
{
	return C4DOS.Ge->DateToString(t,date_only);
}

Bool ShowInFinder(const Filename &fn, Bool open)
{
	return C4DOS.Ge->ShowInFinder(fn,open);
}
