#include "customgui_pla.h"
#include "c4d_string.h"
#include "c4d_gui.h"
#include "lib_ca.h"

PLALib *lib_pla = NULL;

static PLALib *CheckPrefsLib(LONG offset)
{
	return (PLALib*)CheckLib(CUSTOMDATATYPE_PLA, offset, (C4DLibrary**)&lib_pla);
}

void PLAData::GetVariableTags(VariableTag *&ptag, VariableTag *&htag)
{
	PLALib *lib = CheckPrefsLib(LIBOFFSET(PLALib, GetVariableTags)); if (!lib || !lib->GetVariableTags) return;

	(((iPLAData*)this)->*lib->GetVariableTags)(ptag,htag);
}

GeListHead*	mttag_data::GetLayerHead(void)
{
	PLALib *lib = CheckPrefsLib(LIBOFFSET(PLALib, xGetLayerHead)); if (!lib || !lib->xGetLayerHead) return NULL;

	return (*lib->xGetLayerHead)((MT_TagData*)this);
}

Bool mtlayer_data::IsAnimationLayer(void)
{
	PLALib *lib = CheckPrefsLib(LIBOFFSET(PLALib, xIsAnimationLayer)); if (!lib || !lib->xIsAnimationLayer) return FALSE;

	return (*lib->xIsAnimationLayer)((MT_LayerData*)this);
}

GeListHead*	mtlayer_data::GetAnimationHead(void)
{
	PLALib *lib = CheckPrefsLib(LIBOFFSET(PLALib, xGetAnimationHead)); if (!lib || !lib->xGetAnimationHead) return NULL;

	return (*lib->xGetAnimationHead)((MT_LayerData*)this);
}

GeListHead*	mtlayer_data::GetClipHead(void)
{
	PLALib *lib = CheckPrefsLib(LIBOFFSET(PLALib, xGetClipHead)); if (!lib || !lib->xGetClipHead) return NULL;

	return (*lib->xGetClipHead)((MT_LayerData*)this);
}

Bool AnimateNLA(BaseDocument *doc, BaseObject *op, const BaseTime &time, LONG flags)
{
	PLALib *lib = CheckPrefsLib(LIBOFFSET(PLALib, xAnimateNLA)); if (!lib || !lib->xAnimateNLA) return NULL;

	return (*lib->xAnimateNLA)(doc,op,time,flags);
}
