/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _CUSTOMGUI_TREEVIEW_H_
#define _CUSTOMGUI_TREEVIEW_H_

#include "customgui_base.h"
#include "c4d_basecontainer.h"



#define CUSTOMGUI_TREEVIEW		1000475 // user gadget


#define TREEVIEW_BORDER             'brdr'
#define TREEVIEW_OUTSIDE_DROP       'tvod' // TRUE, if object may be dropped under all objects in the tree view
#define TREEVIEW_HIDE_LINES         'tvhl' // TRUE, if no lines should be drawn
#define TREEVIEW_CTRL_DRAG          'ctdr' // TRUE, if item may be duplicated by Ctrl + Drag
#define TREEVIEW_NO_MULTISELECT     'tvnm' // TRUE, if no multi select is allowed
#define TREEVIEW_HAS_HEADER         'tvhh' // TRUE, if the tree view may have a header line
#define TREEVIEW_RESIZE_HEADER      'tvrh' // TRUE, if the column width can be changed by the user
#define TREEVIEW_MOVE_COLUMN        'tvmc' // TRUE, if the user can move a column
#define TREEVIEW_FIXED_LAYOUT       'tvfl' // TRUE, if all lines have the same height
#define TREEVIEW_NOAUTOCOLUMNS			'noau' // TRUE, only the first line is asked for the columnswidth -> huge speedup!
#define TREEVIEW_NO_OPEN_CTRLCLK    'tvcd' // TRUE, if it's not allowed to open the complete tree with ctrl + click
#define TREEVIEW_ALT_DRAG           'tvad' // use alt instead of Ctrl for Drag & Drop, implies item may be duplicated by Alt + Drag
#define TREEVIEW_NO_BACK_DELETE     'tvnb' // Disable DeletePressed messages if Backspace was hit
#define TREEVIEW_ALTERNATE_BG       'tvab' // Alternate background color per line
#define TREEVIEW_CURSORKEYS         'tvck' // Process cursor keys (set the focus item NULL if you delete it and this flag is set)
#define TREEVIEW_NOENTERRENAME			'tver' // Does not open a rename popup when the user presses enter

#define TREEVIEW_DRAGSTART_ALLOW		1
#define TREEVIEW_DRAGSTART_SELECT		2

#define LV_TREE				'tree'
#define LV_USERTREE		'ustr'
#define LV_USER				'user'
#define LV_CHECKBOX		'cbox'
	#define LV_CHECKBOX_ENABLED		1
	#define LV_CHECKBOX_CHECKED		2
	#define LV_CHECKBOX_TRISTATE	4
	#define LV_CHECKBOX_HIDE			8
	
#define ACCEPT_DRAG_OBJECT_FORCE_COPY	(1 << 30) // Use this to force a copy cursor. The next InsertObject call will have set bCopy = TRUE
#define LISTVIEW_TABLE_SIZE						51

typedef UCHAR OBSOLETE;
class TreeViewCustomGui;

class GeUserArea;

struct CellInfo
{
	GeUserArea *frame;

	LONG xpos,ypos,width,height;
	LONG line,col;
};

struct DrawInfo : public CellInfo
{
	GeData bgCol;
};

struct MouseInfo : public CellInfo
{
	Real mx;
	Real my;
	BaseContainer msg;
	Bool rightButton;
	Real mxRelative; // use this in LV_USERTREE
	Bool startDrag;
	Bool startpaint, inpaint;
	const BaseContainer* bc;
};

struct DragInfo : public CellInfo
{
	Real	mx;
	Real	my;
	BaseContainer msg;

	void	*dragobject;
	LONG	dragtype;
};

// if bCont is false, the branch is not visited any more
typedef Bool (*VisitChildrenCallback)(void* root, void* obj, void* userdata, void* data1, void* data2, Bool &bCont);

enum
{
  ID_TREEVIEW_CONTEXT_REMOVE = FIRST_POPUP_ID,
  ID_TREEVIEW_CONTEXT_RESET,
  ID_TREEVIEW_FIRST_NEW_ID = FIRST_POPUP_ID + 10
};

class TreeViewFunctions
{
	public:
		// Navigation Functions
		virtual void*		GetFirst(void *root,void *userdata) = 0;
		virtual void*		GetDown(void *root,void *userdata,void *obj) = 0;
		virtual void*		GetNext(void *root,void *userdata,void *obj) = 0;
		virtual void*		GetPred(void *root,void *userdata,void *obj); // only for drag&drop check

		// Layout functions
		virtual LONG    GetColumnWidth(void *root,void *userdata,void *obj,LONG col, GeUserArea* area);
		virtual LONG    GetHeaderColumnWidth(void *root,void *userdata,LONG col, GeUserArea* area); // return a negative number for auto header width
		virtual LONG		GetLineHeight(void *root,void *userdata,void *obj,LONG col, GeUserArea* area); // always return a value > 0 !
		virtual void		DrawCell(void *root,void *userdata,void *obj,LONG col,DrawInfo *drawinfo, const GeData &bgColor);
		virtual Bool    DrawHeaderCell(void *root, void *userdata, LONG col, DrawInfo *drawinfo); // return FALSE if the header should be drawn by the tree view

		// Get Functions
		virtual Bool		IsSelected(void *root,void *userdata,void *obj) = 0;
		virtual Bool		IsOpened(void *root,void *userdata,void *obj) = 0;
		virtual String	GetName(void *root,void *userdata,void *obj) = 0;
		virtual VLONG		GetId(void *root,void *userdata,void *obj) = 0;
		virtual LONG		GetDragType(void *root,void *userdata,void *obj) = 0; // return NOTOK to disable D&D
		virtual LONG    DragStart(void *root,void *userdata,void *obj);
		virtual void    GetColors(void *root,void *userdata,void *obj, GeData* pNormal, GeData* pSelected);
		virtual void		GetBackgroundColor(void* root, void* userdata, void* obj, LONG line, GeData* col);
		virtual LONG		GetMinHeaderHeight(void *root,void *userdata); // return < 0 for auto header height
		virtual LONG		IsChecked(void *root,void *userdata,void *obj, LONG lColumn); // for checkboxes (return a combination of LV_CHECKBOX_* or NOTOK if you don't want to show the checkbox)

		// bc already contains a delete element, you may delete the contents of bc. Your own elements should start at ID_TREEVIEW_FIRST_NEW_ID
		virtual void    CreateContextMenuColumn(void *root, void *userdata, void *obj, LONG lColumn, BaseContainer* bc);
		// return TRUE, if you proceeded the command and the data needs to be updated
		virtual Bool    ContextMenuColumn(void *root,void *userdata,void *obj, LONG lColumn, LONG lCommand); // called by a command in the context menu, return TRUE if you processed the message

		virtual Bool    IsTristate(void *root, void *userdata);

		// Set Functions
		virtual void		Open(void *root,void *userdata,void *obj,Bool onoff);
		virtual void		Select(void *root,void *userdata,void *obj,LONG mode);
		virtual LONG		AcceptDragObject(void *root,void *userdata,void *obj,LONG dragtype,void *dragobject, Bool &bAllowCopy); // return INSERT_xxx
		// if obj == NULL, the dragobject should be inserted as a child of the root 
		virtual void		InsertObject(void *root,void *userdata,void *obj,LONG dragtype,void *dragobject,LONG insertmode, Bool bCopy);
			#define INSERT_BEFORE		(1<<0)
			#define INSERT_AFTER		(1<<1)
			#define INSERT_UNDER		(1<<2)
		virtual void		SetCheck(void *root,void *userdata,void *obj, LONG lColumn, Bool bCheck, const BaseContainer& bcMsg); // for checkboxes
		virtual void		Scrolled(void *root, void *userdata, LONG h, LONG v, LONG x, LONG y);

		virtual void    SetName(void *root,void *userdata,void *obj, const String &str);
		virtual void    SetDragObject(void *root,void *userdata,void *obj);
		virtual void    GenerateDragArray(void *root,void *userdata,void *obj, AtomArray* ar);
		virtual void    GenerateDragData(void *root, void *userdata, void* obj, void **dragdata);
		virtual void    FreeDragData(void *root, void *userdata, void *dragdata);

		virtual Bool		MouseDown(void *root,void *userdata,void *obj,LONG col,MouseInfo *mouseinfo, Bool rightButton);
		virtual Bool		DoubleClick(void *root,void *userdata,void *obj,LONG col,MouseInfo *mouseinfo); // return FALSE, if you want to open the rename dialog
		virtual void    DeletePressed(void *root, void *userdata);

		virtual void    SelectionChanged(void *root, void *userdata);
		virtual LONG    GetHeaderSortArrow(void *root, void *userdata, LONG lColID);
		virtual Bool    HeaderClick(void *root, void *userdata, LONG lColID, LONG lChannel, Bool bDblClk); // return TRUE, if the tree view needs to be updated
		virtual Bool    UserCanResizeCol(void *root, void *userdata, LONG lColID);
		virtual Bool    UserCanMoveCol(void *root, void *userdata, LONG lColID);

		// called after the user released the cursor, return FALSE if you want to cancel the layout change
		// NOTE : lInsertBeforeCol is the index of the column
		virtual Bool    ColumnMoved(void *root, void *userdata, LONG lColID, LONG lInsertBeforeCol, LONG* plIndexMap, const BaseContainer* pbcLayout);
		virtual void		InitCache(void *root, void *userdata);

		virtual OBSOLETE GetColumnWidth(void *root,void *userdata,void *obj,LONG col); // changed in 8.6
		virtual OBSOLETE GetHeaderColumnWidth(void *root,void *userdata,LONG col); // changed in 8.6
		virtual OBSOLETE GetLineHeight(void *root,void *userdata,void *obj,LONG col);// changed in 8.6
		virtual OBSOLETE DrawCell(void *root,void *userdata,void *obj,LONG col,DrawInfo *drawinfo, LONG bgColor);
		// Note : CreateContextMenu and ContextMenu were replaced by CreateContextMenuColumn and ContextMenuColumn with version 8.15
		virtual OBSOLETE CreateContextMenu(void *root, void *userdata, void *obj, BaseContainer* bc);
		virtual OBSOLETE ContextMenu(void *root,void *userdata,void *obj, LONG lCommand); // called by a command in the context menu, return TRUE if you processed the message
		virtual Bool InputEvent(void* root, void* userdata, GeUserArea* pArea, const BaseContainer &msg);

		// non-overridable

		// calls fn for obj and all its children
		Bool VisitChildren(void* root, void* obj, VisitChildrenCallback fn, void* userdata, void* data1, void* data2);
};


// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

class TreeViewF
{
public:
	// version 8.0
	void*  GetFirst(TreeViewFunctions* pFuncs, void *root,void *userdata);
	void*  GetDown(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	void*  GetNext(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	void*  GetPred(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	LONG   GetColumnWidth(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col);
	LONG   GetLineHeight(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col);
	void   DrawCell(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,DrawInfo *drawinfo, LONG bgColor);
	void   DrawCellGD(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,DrawInfo *drawinfo, const GeData& bgColor);
	Bool   DrawHeaderCell(TreeViewFunctions* pFuncs, void *root,void *userdata,LONG col,DrawInfo *drawinfo);
	Bool   IsSelected(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	Bool   IsOpened(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	String GetName(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	LONG   GetId(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	LONG   GetDragType(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	void   GetColors(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, GeData* pNormal, GeData* pSelected);
	void   CreateContextMenu(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, BaseContainer* bc); // only for compatibility
	Bool   ContextMenu(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lCommand); // only for compatibility
	Bool   IsTristate(TreeViewFunctions* pFuncs, void *root, void *userdata);
	void   Open(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,Bool onoff);
	void   Select(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG mode);
	LONG   AcceptDragObject(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG dragtype,void *dragobject, Bool &bAllowCopy);
	void   InsertObject(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG dragtype,void *dragobject,LONG insertmode, Bool bCopy);
	void   SetName(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, const String &str);
	void   SetDragObject(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	void   GenerateDragArray(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, AtomArray* ar);
	Bool   MouseDown(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,MouseInfo *mouseinfo, Bool rightButton);
	Bool   DoubleClick(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,MouseInfo *mouseinfo);
	void   DeletePressed(TreeViewFunctions* pFuncs, void *root, void *userdata);

	// version 8.1
	void    SelectionChanged(TreeViewFunctions* pFuncs, void *root, void *userdata);
	LONG    GetHeaderSortArrow(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID);
	Bool    HeaderClick(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID, LONG lChannel, Bool bDbl);
	Bool    UserCanResizeCol(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID);
	Bool    UserCanMoveCol(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID);
	Bool    ColumnMoved(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID, LONG lInsertBeforeCol, LONG* plIndexMap, const BaseContainer* pbcLayout);
	LONG		GetHeaderColumnWidth(TreeViewFunctions* pFuncs, void *root,void *userdata,LONG col);
	LONG		GetMinHeaderHeight(TreeViewFunctions* pFuncs, void *root,void *userdata);

	// new from version 8.15
	void   CreateContextMenuColumn(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn, BaseContainer* bc);
	Bool   ContextMenuColumn(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn, LONG lCommand);

	// new from version 8.6
	LONG   GetColumnWidthArea(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col, GeUserArea* area);
	LONG	 GetHeaderColumnWidthArea(TreeViewFunctions* pFuncs, void *root,void *userdata,LONG col, GeUserArea* area);
	LONG	 GetLineHeightArea(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col, GeUserArea* area);

	// new in 9.5
	void    GenerateDragData(TreeViewFunctions* pFuncs, void *root, void *userdata, void* obj, void **dragdata);
	void    FreeDragData(TreeViewFunctions* pFuncs, void *root, void *userdata, void *dragdata);

	LONG		IsChecked(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn);
	void		SetCheck(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn, Bool bCheck, const BaseContainer& bcMsg);
	LONG    DragStart(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	void		InitCache(TreeViewFunctions* pFuncs, void *root,void *userdata);

	void		GetBackgroundColor(TreeViewFunctions* pFuncs, void* root, void* userdata, void* obj, LONG line, GeData* col);
	Bool		InputEvent(TreeViewFunctions* pFuncs, void* root, void* userdata, GeUserArea* pArea, const BaseContainer &msg);

	LONG		GetTableSize() { return LISTVIEW_TABLE_SIZE; }

	void		Scrolled(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG h, LONG v, LONG x, LONG y);
};

struct InternalFunctionTable
{
	// tree view version 8.0
	/* 1*/ void*		(TreeViewF::*GetFirst)(TreeViewFunctions* pFuncs, void *root,void *userdata);
	/* 2*/ void*		(TreeViewF::*GetDown)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/* 3*/ void*		(TreeViewF::*GetNext)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/* 4*/ void*		(TreeViewF::*GetPred)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj); // only for drag&drop check

	// Layout functions
	/* 5*/ LONG		(TreeViewF::*GetColumnWidth)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col);
	/* 6*/ LONG		(TreeViewF::*GetLineHeight)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col);
	/* 7*/ void		(TreeViewF::*DrawCell)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,DrawInfo *drawinfo, LONG bgColor);

	// Get Functions
	/* 8*/ Bool		(TreeViewF::*IsSelected)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/* 9*/ Bool		(TreeViewF::*IsOpened)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/*10*/ String	(TreeViewF::*GetName)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/*11*/ LONG		(TreeViewF::*GetId)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/*12*/ LONG		(TreeViewF::*GetDragType)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj); // return NOTOK to disable D&D
	/*13*/ void    (TreeViewF::*GetColors)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, GeData* pNormal, GeData* pSelected);
	       // bc already contains a delete elment, you may delete the contents of bc. Your own elements should start at ID_TREEVIEW_FIRST_NEW_ID
	/*14*/ void    (TreeViewF::*CreateContextMenu)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, BaseContainer* bc);
	       // return TRUE, if you proceeded the command and the data needs to be updated
	/*15*/ Bool    (TreeViewF::*ContextMenu)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lCommand); // calles by the delete command in the context menu
	/*16*/ Bool    (TreeViewF::*IsTristate)(TreeViewFunctions* pFuncs, void *root, void *userdata);

	// Set Functions
	/*17*/ void		(TreeViewF::*Open)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,Bool onoff);
	/*18*/ void		(TreeViewF::*Select)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG mode);
	/*19*/ LONG		(TreeViewF::*AcceptDragObject)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG dragtype,void *dragobject, Bool &bAllowCopy); // retrun INSERT_xxx
	// if obj == NULL, the dragobject sould be inserted as a child of the root 
	/*20*/ void		(TreeViewF::*InsertObject)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG dragtype,void *dragobject,LONG insertmode, Bool bCopy);
	/*21*/ void    (TreeViewF::*SetName)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, const String &str);
	/*22*/ void    (TreeViewF::*SetDragObject)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/*23*/ void    (TreeViewF::*GenerateDragArray)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, AtomArray* ar);

	/*24*/ Bool		(TreeViewF::*MouseDown)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,MouseInfo *mouseinfo, Bool rightButton);
	/*25*/ Bool		(TreeViewF::*DoubleClick)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,MouseInfo *mouseinfo); // return FALSE, if you want to open the rename dialog
	/*26*/ void    (TreeViewF::*DeletePressed)(TreeViewFunctions* pFuncs, void *root, void *userdata);

	// version 8.1 functions
	/*27*/ void    (TreeViewF::*SelectionChanged)(TreeViewFunctions* pFuncs, void *root, void *userdata);
	/*28*/ LONG    (TreeViewF::*GetHeaderSortArrow)(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID);
	/*29*/ Bool    (TreeViewF::*HeaderClick)(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID, LONG lChannel, Bool bDbl);
	/*30*/ Bool    (TreeViewF::*UserCanResizeCol)(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID);
	/*31*/ Bool    (TreeViewF::*UserCanMoveCol)(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID);
	/*32*/ Bool    (TreeViewF::*ColumnMoved)(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG lColID, LONG lInsertBeforeCol, LONG* plIndexMap, const BaseContainer* pbcLayout);
	/*33*/ LONG		(TreeViewF::*GetHeaderColumnWidth)(TreeViewFunctions* pFuncs, void *root,void *userdata,LONG col);
	/*34*/ Bool		(TreeViewF::*DrawHeaderCell)(TreeViewFunctions* pFuncs, void *root,void *userdata,LONG col,DrawInfo *drawinfo);
	/*35*/ LONG		(TreeViewF::*GetMinHeaderHeight)(TreeViewFunctions* pFuncs, void *root,void *userdata);

	// version 8.15 functions
	/*36*/ void    (TreeViewF::*CreateContextMenuColumn)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn, BaseContainer* bc);
	/*37*/ Bool    (TreeViewF::*ContextMenuColumn)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn, LONG lCommand); // called by the delete command in the context menu

	// version 8.6 functions
	/*38*/ LONG   (TreeViewF::*GetColumnWidthArea)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col, GeUserArea* area);
	/*39*/ LONG	 (TreeViewF::*GetHeaderColumnWidthArea)(TreeViewFunctions* pFuncs, void *root,void *userdata,LONG col, GeUserArea* area);
	/*40*/ LONG	 (TreeViewF::*GetLineHeightArea)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col, GeUserArea* area);

	// new in 9.5
	/*41*/ void    (TreeViewF::*GenerateDragData)(TreeViewFunctions* pFuncs, void *root, void *userdata, void* obj, void **dragdata);
	/*42*/ void    (TreeViewF::*FreeDragData)(TreeViewFunctions* pFuncs, void *root, void *userdata, void *dragdata);

	/*43*/ LONG		(TreeViewF::*IsChecked)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn);
	/*44*/ void		(TreeViewF::*SetCheck)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj, LONG lColumn, Bool bCheck, const BaseContainer& bcMsg);
	/*45*/ LONG    (TreeViewF::*DragStart)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj);
	/*46*/ void		(TreeViewF::*InitCache)(TreeViewFunctions* pFuncs, void *root,void *userdata);

	/*47*/ void		(TreeViewF::*GetBackgroundColor)(TreeViewFunctions* pFuncs, void* root, void* userdata, void* obj, LONG line, GeData* col);
	/*48*/ void		(TreeViewF::*DrawCellGD)(TreeViewFunctions* pFuncs, void *root,void *userdata,void *obj,LONG col,DrawInfo *drawinfo, const GeData &bgColor);
	/*49*/ Bool		(TreeViewF::*InputEvent)(TreeViewFunctions* pFuncs, void* root, void* userdata, GeUserArea* pArea, const BaseContainer &msg);

	/*50*/ LONG		(TreeViewF::*GetTableSize)();

	/*51*/ void		(TreeViewF::*Scrolled)(TreeViewFunctions* pFuncs, void *root, void *userdata, LONG h, LONG v, LONG x, LONG y);
};




// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


class TreeViewCustomGui : public BaseCustomGui<CUSTOMGUI_TREEVIEW>
{
		TreeViewCustomGui();
		~TreeViewCustomGui();

	public:
		Bool    SetRoot(void *root,TreeViewFunctions *functions,void *userdata);
		Bool		SetLayout(LONG columns,const BaseContainer &data);
		Bool    SetHeaderText(LONG lColumnID, const String &str);
		GeUserArea* GetTreeViewArea();
		GeUserArea* GetHeaderArea();
		void		Refresh();
		LONG    GetAutoColumnWidth(LONG lColID); // the auto-width of the column
		LONG    GetColumnWidthUser(LONG lColID); // the size the user has set

		LONG    GetRealColumnWidth(LONG lColID); // the real column width
		Bool    SetColumnWidthUser(LONG lColID, LONG lWidth);
		Bool    MakeVisible(void* pObj); // scrolls to pObj and expands the tree if necessary
		Bool    ShowObject(void* pObj); // expands the tree to pObj
		Bool		GetCellPosition(void* pObj, LONG lColID, GeUserArea *&pArea, LONG &x, LONG &y, LONG &w, LONG &h, LONG &lTextOffset);
		Bool		IsFocusItem(void* pObj);
		void*		GetFocusItem();
		void		SetFocusItem(void* pItem);
		const BaseContainer* GetLayout();
		void*		GetObject(LONG line, LONG *level);
};



// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#ifndef _INTERNAL_DEF_
	class iTreeViewCustomGui
	{
	};
#else
	class iTreeViewCustomGui;
#endif

struct TreeViewLib : public BaseCustomGuiLib
{
	Bool    (iTreeViewCustomGui::*SetRoot		)(void *root, InternalFunctionTable* f, void *userdata, LONG lSize, TreeViewF* pControl, TreeViewFunctions* pFunctions);
	void		(iTreeViewCustomGui::*Refresh		)();
	Bool		(iTreeViewCustomGui::*SetLayout	)(LONG columns,const BaseContainer &data);
	Bool		(iTreeViewCustomGui::*ShowObject)(void *o);
	Bool    (iTreeViewCustomGui::*SetHeaderText)(LONG lColumnID, const String &str);
	GeUserArea* (iTreeViewCustomGui::*GetTreeViewArea)();
	GeUserArea* (iTreeViewCustomGui::*GetHeaderArea)();
	LONG    (iTreeViewCustomGui::*GetAutoColumnWidth)(LONG lColID);
	LONG    (iTreeViewCustomGui::*GetColumnWidthUser)(LONG lColID);
	LONG    (iTreeViewCustomGui::*GetRealColumnWidth)(LONG lColID);
	Bool    (iTreeViewCustomGui::*SetColumnWidthUser)(LONG lColID, LONG lWidth);
	Bool    (iTreeViewCustomGui::*MakeVisible)(void* pObj);
	Bool		(iTreeViewCustomGui::*GetCellPosition)(void* pObj, LONG lColID, GeUserArea *&pArea, LONG &x, LONG &y, LONG &w, LONG &h, LONG &lTextOffset);
	Bool		(iTreeViewCustomGui::*IsFocusItem)(void* pObj);
	void*		(iTreeViewCustomGui::*GetFocusItem)();
	void		(iTreeViewCustomGui::*SetFocusItem)(void* pItem);
	const BaseContainer*	(iTreeViewCustomGui::*GetLayout)();
	void*		(iTreeViewCustomGui::*GetObject)(LONG line, LONG *level);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
