CONTAINER Ocamera
{
	NAME Ocamera;
	INCLUDE Obase;

	GROUP ID_OBJECTPROPERTIES
	{
		COLUMNS 2;
		
		LONG CAMERA_PROJECTION { CYCLE { Pperspective;Pparallel;Pleft;Pright;Pfront;Pback;Ptop;Pbottom;Pmilitary;Pfrog;Pbird;Pgentleman;Pisometric;Pdimetric; } }
		STATICTEXT { NEWLINE; }
		
		REAL CAMERA_FOCUS { MIN 1; MAX 10000; }
		STATICTEXT { NEWLINE; }
		REAL CAMERAOBJECT_APERTURE { MIN 1.0; MAX 2000.0; STEP 0.1; }
		STATICTEXT { NEWLINE; }
		REAL CAMERAOBJECT_FOV	{ MIN 0.2; MAX 174.0; UNIT DEGREE; }
		STATICTEXT { NEWLINE; }
		REAL CAMERA_ZOOM  { MIN 0.0001; MAX 10000.0; STEP 0.1; }
		STATICTEXT { NEWLINE; }

		REAL CAMERAOBJECT_FILM_OFFSET_X { UNIT PERCENT; }
		STATICTEXT { NEWLINE; }
		REAL CAMERAOBJECT_FILM_OFFSET_Y {	UNIT PERCENT; }
		STATICTEXT { NEWLINE; }

		BOOL CAMERAOBJECT_NEAR_CLIPPING_ENABLE {}
		STATICTEXT { NEWLINE; }
		REAL CAMERAOBJECT_NEAR_CLIPPING { UNIT METER; }
		STATICTEXT { NEWLINE; }

		BOOL CAMERAOBJECT_SHOW {}
		STATICTEXT { NEWLINE; }
		FILENAME CAMERAOBJECT_PROJECTIONRENDER { HIDDEN; }
		STATICTEXT { NEWLINE; }
		
		SEPARATOR { }
		STATICTEXT { JOINEND; }
		
		LONG CAMERAOBJECT_MODE { CYCLE { CAMERAOBJECT_MODE_DEFAULT; CAMERAOBJECT_MODE_OBJECT; CAMERAOBJECT_MODE_CENTER; CAMERAOBJECT_MODE_WORLD; CAMERAOBJECT_MODE_CAMERA; } }
		STATICTEXT { NEWLINE; }
		
		LONG CAMERAOBJECT_PIVOT
		{
			CYCLE
			{
				CAMERAOBJECT_PIVOT_AXIS;
				CAMERAOBJECT_PIVOT_VIEW;
				CAMERAOBJECT_PIVOT_CLOSEST;
				CAMERAOBJECT_PIVOT_OBJECT;
				CAMERAOBJECT_PIVOT_CUSTOM;
			}
		}
	
		BOOL CAMERAOBJECT_SHOW_CENTER {}
			
		LINK CAMERAOBJECT_MODE_LINK { ACCEPT { Obase; } }
		STATICTEXT { JOINEND; }		
			
		VECTOR CAMERAOBJECT_PIVOT_POSITION { UNIT METER; }
		STATICTEXT { NEWLINE; }
	}

	GROUP ID_GROUP_DEPTHOFFIELD
	{
		REAL CAMERAOBJECT_TARGETDISTANCE { UNIT METER; MINEX; MIN 0.0; }
		BOOL CAMERAOBJECT_USETARGETOBJECT	{ }

		SEPARATOR { }

		GROUP
		{
			LAYOUTGROUP; COLUMNS 2;

			GROUP
			{
				BOOL CAMERAOBJECT_FRONTBLUR	{ }

				REAL CAMERAOBJECT_FRONTSTART { PARENTID CAMERAOBJECT_FRONTBLUR; UNIT METER; MIN 0.0; }
				REAL CAMERAOBJECT_FRONTEND { PARENTID CAMERAOBJECT_FRONTBLUR; UNIT METER; MIN 0.0; }
			}

			GROUP
			{
				BOOL CAMERAOBJECT_REARBLUR { }

				REAL CAMERAOBJECT_REARSTART	{ PARENTID CAMERAOBJECT_REARBLUR; UNIT METER; MIN 0.0; }
				REAL CAMERAOBJECT_REAREND { PARENTID CAMERAOBJECT_REARBLUR; UNIT METER; MIN 0.0; }
			}
		}
	}
}
